/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.login;

import com.sap.engine.frame.client.ClientFactory;
import com.sap.engine.frame.client.ClientThreadContextFactory;
import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.SecurityControl;
import com.sap.engine.services.security.gui.login.FourthTablePanel;
import com.sap.engine.services.security.login.SecuritySession;
import com.sap.engine.services.security.remote.sessions.RemoteSecuritySessions;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.event.ListSelectionEvent;

public class LoginControl
extends FourthTablePanel {
    Frame frame = null;
    RemoteSecuritySessions sessions = null;
    SecurityControl security = null;
    SecuritySession[] currentSessions = null;

    public LoginControl(SecurityControl security) {
        super("#", "Principal", "Creation Timestamp", "Expires At", new String[0]);
        this.security = security;
    }

    public void update() {
        if (this.sessions == null) {
            try {
                this.sessions = this.security.getSecurityInterface().getSecuritySessions();
            }
            catch (Exception e) {
                ExceptionHandler.error("Unable to retrieve the security sessions!", e);
            }
        }
        try {
            this.tableModel.clearAll();
            this.currentSessions = this.sessions.listSecuritySessions();
            int i = 0;
            while (i < this.currentSessions.length) {
                this.tableModel.addRow("" + (i + 1), this.currentSessions[i].getPrincipal().getName(), this.convertDate(this.currentSessions[i].getCreationTime()), this.currentSessions[i].getExpirationPeriod() < 0L ? "never expires" : this.convertDate(this.currentSessions[i].getCreationTime() + this.currentSessions[i].getExpirationPeriod()));
                ++i;
            }
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to visualize one or more of the security sessions!", e);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            SecuritySession removeSession = this.currentSessions[this.table.getSelectedRow()];
            if (this.isCurrentSessionSelected()) {
                throw new BaseSecurityException("security_0501");
            }
            this.sessions.removeSecuritySession(removeSession);
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to terminate security session!", e);
        }
        this.update();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            this.killButton.setEnabled(false);
        } else {
            this.killButton.setEnabled(!this.isCurrentSessionSelected());
        }
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    private String convertDate(long date) {
        return new Date(date).toString();
    }

    private final boolean isCurrentSessionSelected() {
        try {
            ClientThreadContextFactory threadFactory = ClientFactory.getThreadContextFactory();
            ClientThreadContext thread = threadFactory.getThreadContext();
            SecurityContextObject security = (SecurityContextObject)((Object)thread.getContextObject("security"));
            SecuritySession currentSession = (SecuritySession)security.getSession();
            SecuritySession selectedSession = this.currentSessions[this.table.getSelectedRow()];
            return currentSession.equals(selectedSession);
        }
        catch (Exception e) {
            ExceptionHandler.debug("Unable to check if the current session is the selected one!", e);
            return false;
        }
    }
}

