/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.jaas;

import com.sap.engine.gui.CListDialog;
import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.SecurityControl;
import com.sap.engine.services.security.gui.jaas.AbstractTripleTablePanel;
import com.sap.engine.services.security.gui.jaas.DefaultLoginModuleEditor;
import com.sap.engine.services.security.gui.jaas.TripleTableModel;
import com.sap.engine.services.security.gui.util.ComboBoxCellRenderer;
import com.sap.engine.services.security.gui.util.SortedComponentsList;
import com.sap.engine.services.security.remote.RemoteAuthentication;
import com.sap.engine.services.security.remote.RemoteUserStore;
import com.sap.engine.services.security.remote.authentication.RemoteAppConfigurationEntry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;

public class LoginModuleControl
extends AbstractTripleTablePanel {
    private SecurityControl security = null;
    private RemoteAuthentication authentication = null;
    private RemoteUserStore userstore = null;
    private String userStoreName = null;
    private String selectedId = null;

    public LoginModuleControl(SecurityControl security) {
        this.security = security;
    }

    public LoginModuleControl(SecurityControl security, String userStore) {
        this(security);
        this.userStoreName = userStore;
    }

    public void setFrame(Frame frame) {
    }

    public void onComponentChange(String policyConfigurationId) {
        try {
            this.selectedId = policyConfigurationId;
            if (this.selectedId != null) {
                this.authentication = this.getAuthentication();
                this.userstore = this.getUserStore();
                this.viewLoginModules();
                this.newButton.setEnabled(true);
            } else {
                this.templateUsage.removeAllItems();
                this.table.clearSelection();
                this.newButton.setEnabled(false);
            }
            this.repaint();
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to update authentication stack for the selected configuration!", e);
        }
    }

    protected void setTemplates() {
        if (this.templateUsage.getItemCount() > 2) {
            return;
        }
        boolean embededBlock = this.blockTemplates;
        try {
            try {
                this.blockTemplates = true;
                this.templateUsage.removeAllItems();
                this.templateUsage.setRenderer(new ComboBoxCellRenderer());
                Object[] result = this.security.getSecurityInterface().listPolicyConfigurations();
                SortedComponentsList.sortList(result);
                this.templateUsage.addItem("no");
                int i = 0;
                while (i < result.length) {
                    try {
                        if (this.security.getSecurityInterface().getPolicyConfiguration((String)result[i]).getAuthentication().getTemplate() == null) {
                            this.templateUsage.addItem(result[i]);
                        }
                    }
                    catch (Exception ee) {
                        ExceptionHandler.debug("Unable to determine if the policy configuration has template!", ee);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                ExceptionHandler.error("Unable to set template for the authentication stack!", e);
                Object var6_7 = null;
                this.blockTemplates = embededBlock;
            }
            Object var6_6 = null;
            this.blockTemplates = embededBlock;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.blockTemplates = embededBlock;
            throw throwable;
        }
    }

    protected void modifyTemplate(String template) {
        try {
            if ("no".equalsIgnoreCase(template)) {
                template = null;
            }
            if (!("" + template).equals("" + this.selectedId) && !("" + template).equals("" + this.authentication.getTemplate())) {
                this.authentication.setTemplate(template);
            }
            this.changeTable();
            this.changeTemplateUsage();
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to modify the template of the authentication stack!", e);
        }
    }

    protected void modifyBtnAction() {
        int index = this.table.getSelectedRow();
        String loginModule = null;
        if (index >= 0) {
            loginModule = (String)this.table.getValueAt(index, 0);
            DefaultLoginModuleEditor editor = new DefaultLoginModuleEditor(this.security.getFrame(), "Edit Login Module", true, loginModule, this.userstore);
            editor.setPosition(index);
            editor.setFlag((String)this.table.getValueAt(index, 1));
            try {
                editor.setOptions((Map)this.table.getValueAt(index, 2));
            }
            catch (Exception e) {
                ExceptionHandler.warning("The options are not in the proper format!", e);
            }
            ((Component)editor).setSize(500, 300);
            editor.setModal(true);
            editor.setLocationRelativeTo(this);
            ((Component)editor).setVisible(true);
            if (editor.isOK()) {
                this.modifyAction(index, editor.getPosition(), editor.getName(), editor.getFlag(), editor.getOptions());
            }
        }
    }

    protected void modifyAction(int oldPosition, int newPosition, String name, String flag, Map options) {
        try {
            RemoteAppConfigurationEntry[] entries = this.userStoreName == null ? this.authentication.getLoginModules() : this.authentication.getLoginModules(this.userStoreName);
            LoginModuleConfiguration[] modules = this.userstore.getConfiguration().getLoginModules();
            String className = name;
            int i = 0;
            while (i < modules.length) {
                if (modules[i].getName().equals(name)) {
                    className = modules[i].getLoginModuleClassName();
                    break;
                }
                ++i;
            }
            AppConfigurationEntry entry = new AppConfigurationEntry(className, this.convertToControlFlag(flag), options);
            if (newPosition >= entries.length) {
                newPosition = entries.length - 1;
            } else if (newPosition < 0) {
                newPosition = 0;
            }
            int difference = oldPosition - newPosition;
            if (difference < 0) {
                int i2 = oldPosition;
                while (i2 < newPosition) {
                    entries[i2] = entries[i2 + 1];
                    ++i2;
                }
                entries[newPosition] = new RemoteAppConfigurationEntry(entry, name);
            } else {
                int i3 = oldPosition;
                while (i3 > newPosition) {
                    entries[i3] = entries[i3 - 1];
                    --i3;
                }
                entries[newPosition] = new RemoteAppConfigurationEntry(entry, name);
            }
            if (this.userStoreName == null) {
                this.authentication.setLoginModules(entries);
            } else {
                this.authentication.setLoginModules(this.userStoreName, entries);
            }
            this.viewLoginModules();
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to modify the authentication stack!", e);
        }
    }

    protected void removeBtnAction() {
        try {
            int removeIndex = this.table.getSelectedRow();
            if (removeIndex >= 0) {
                RemoteAppConfigurationEntry[] oldEntries = this.userStoreName == null ? this.authentication.getLoginModules() : this.authentication.getLoginModules(this.userStoreName);
                RemoteAppConfigurationEntry[] newEntries = new RemoteAppConfigurationEntry[oldEntries.length - 1];
                System.arraycopy(oldEntries, 0, newEntries, 0, removeIndex);
                System.arraycopy(oldEntries, removeIndex + 1, newEntries, removeIndex, newEntries.length - removeIndex);
                if (this.userStoreName == null) {
                    this.authentication.setLoginModules(newEntries);
                } else {
                    this.authentication.setLoginModules(this.userStoreName, newEntries);
                }
            }
            this.viewLoginModules();
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to remove login module!", e);
        }
    }

    protected void newBtnAction() {
        try {
            Object[] values;
            this.table.clearSelection();
            this.userstore = this.getUserStore();
            LoginModuleConfiguration[] modules = this.userstore.getConfiguration().getLoginModules();
            Object[] moduleNames = new String[modules.length];
            int i = 0;
            while (i < modules.length) {
                moduleNames[i] = modules[i].getName();
                ++i;
            }
            Arrays.sort(moduleNames);
            CListDialog availableLoginModules = new CListDialog(null, "Available Login Modules");
            ((Component)availableLoginModules).setSize(new Dimension(500, 300));
            availableLoginModules.setTitle(" Available Login Modules ");
            availableLoginModules.initList((String[])moduleNames);
            if (availableLoginModules.showDialog() && (values = availableLoginModules.getSelected()).length > 0) {
                String stringValue;
                String className = stringValue = (String)values[0];
                Map<Object, Object> options = new Properties();
                int i2 = 0;
                while (i2 < modules.length) {
                    if (modules[i2].getName().equals(stringValue)) {
                        options = modules[i2].getOptions();
                        className = modules[i2].getLoginModuleClassName();
                        break;
                    }
                    ++i2;
                }
                AppConfigurationEntry entry = new AppConfigurationEntry(className, AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, options);
                RemoteAppConfigurationEntry[] oldEntries = this.userStoreName == null ? this.authentication.getLoginModules() : this.authentication.getLoginModules(this.userStoreName);
                RemoteAppConfigurationEntry[] newEntries = new RemoteAppConfigurationEntry[oldEntries.length + 1];
                System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
                newEntries[oldEntries.length] = new RemoteAppConfigurationEntry(entry, stringValue);
                if (this.userStoreName == null) {
                    this.authentication.setLoginModules(newEntries);
                } else {
                    this.authentication.setLoginModules(this.userStoreName, newEntries);
                }
            }
            this.viewLoginModules();
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to add login module to the authentication stack!", e);
        }
    }

    private AppConfigurationEntry.LoginModuleControlFlag convertToControlFlag(String flag) {
        if ("OPTIONAL".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        if ("REQUIRED".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if ("REQUISITE".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        if ("SUFFICIENT".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        return null;
    }

    private String convertControlFlag(AppConfigurationEntry.LoginModuleControlFlag flag) {
        if (flag == AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL) {
            return "OPTIONAL";
        }
        if (flag == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
            return "REQUIRED";
        }
        if (flag == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
            return "REQUISITE";
        }
        if (flag == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
            return "SUFFICIENT";
        }
        return "unknown";
    }

    private void viewLoginModules() throws Exception {
        this.changeTable();
        this.changeTemplateUsage();
    }

    private void changeTable() throws Exception {
        if (this.authentication == null) {
            return;
        }
        if (this.userstore == null) {
            this.userstore = this.getUserStore();
        }
        LoginModuleConfiguration[] modules = this.userstore.getConfiguration().getLoginModules();
        TripleTableModel model = (TripleTableModel)this.table.getModel();
        RemoteAppConfigurationEntry[] entries = null;
        entries = this.userStoreName == null ? this.authentication.getLoginModules() : this.authentication.getLoginModules(this.userStoreName);
        model.clearAll();
        int i = 0;
        while (i < entries.length) {
            Map options;
            String name = entries[i].getLoginModuleName();
            Map entryOptions = entries[i].getOptions();
            int j = 0;
            while (j < modules.length) {
                if (modules[j].getLoginModuleClassName().equals(name)) {
                    options = modules[j].getOptions();
                    if (options == null && entryOptions == null) {
                        name = modules[j].getName();
                    } else if (options != null && entryOptions != null && options.equals(entryOptions)) {
                        name = modules[j].getName();
                    }
                }
                ++j;
            }
            options = new Hashtable();
            ((Hashtable)options).putAll(entries[i].getOptions());
            model.addRow(name, this.convertControlFlag(entries[i].getControlFlag()), (Hashtable)options);
            ++i;
        }
    }

    private void changeTemplateUsage() throws Exception {
        boolean embededBlock = this.blockTemplates;
        try {
            this.blockTemplates = true;
            String template = this.authentication.getTemplate();
            if (template != null) {
                this.setTemplates();
                this.templateUsage.setSelectedItem(template);
            } else {
                this.templateUsage.setSelectedItem("no");
            }
            if (template != null) {
                this.table.setEnabled(false);
                this.modifyButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                this.newButton.setEnabled(false);
            } else {
                this.table.setEnabled(true);
                this.newButton.setEnabled(true);
            }
            Object var4_3 = null;
            this.blockTemplates = embededBlock;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.blockTemplates = embededBlock;
            throw throwable;
        }
    }

    private final RemoteAuthentication getAuthentication() throws RemoteException {
        return this.security.getSecurityInterface().getPolicyConfiguration(this.selectedId).getAuthentication();
    }

    private RemoteUserStore getUserStore() throws RemoteException {
        this.userstore = this.userStoreName == null ? this.authentication.getAuthenticationUserStore() : this.security.getSecurityInterface().getRemoteUserStoreFactory().getUserStore(this.userStoreName);
        return this.userstore;
    }
}

