/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.jaas;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.CScrollField;
import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.interfaces.security.userstore.config.LoginModuleOptionsEditor;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.stores.DefaultOptionsEditor;
import com.sap.engine.services.security.remote.RemoteUserStore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class DefaultLoginModuleEditor
extends CEscapeDialog
implements ActionListener {
    private JPanel dialogPane = new JPanel(new BorderLayout());
    private JPanel centerPane = new JPanel(new GridBagLayout());
    private JPanel southPane = new JPanel(new FlowLayout());
    private JLabel moduleNameLabel;
    private JTextField moduleNameField;
    private JLabel flagLabel;
    private JLabel positionLabel;
    private CScrollField positions;
    private JComboBox comboFlags;
    private JButton okButt;
    private JButton cancelButt;
    private boolean isOK = false;
    private String name = null;
    private LoginModuleOptionsEditor optionsEditor;
    private JScrollPane scrollOptions;

    public DefaultLoginModuleEditor(Frame frame, String title, boolean modal, String name, RemoteUserStore userstore) {
        super(frame, title, modal);
        this.name = name;
        try {
            this.init(userstore, frame);
            this.pack();
        }
        catch (Exception ex) {
            ExceptionHandler.error("Unable to visualize default login module editor!", ex);
        }
    }

    void init(RemoteUserStore userstore, Frame frame) throws Exception {
        this.isOK = false;
        this.moduleNameLabel = new JLabel("Name: ");
        this.moduleNameField = new JTextField(this.name);
        this.moduleNameField.setEditable(false);
        this.positionLabel = new JLabel("Position: ");
        this.positions = new CScrollField();
        this.positions.setValue(1);
        this.positions.setMinimumValue(1);
        this.flagLabel = new JLabel("Flag: ");
        this.comboFlags = new JComboBox<String>(new String[]{"REQUIRED", "SUFFICIENT", "REQUISITE", "OPTIONAL"});
        try {
            LoginModuleConfiguration[] modules = userstore.getConfiguration().getLoginModules();
            int i = 0;
            while (i < modules.length) {
                if (modules[i].getName().equals(this.name)) {
                    String editor = modules[i].getOptionsEditor();
                    if (editor != null && !"".equals(editor)) {
                        this.optionsEditor = (LoginModuleOptionsEditor)Class.forName(editor).newInstance();
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            ExceptionHandler.warning("The specified editor cannot be loaded! The default one will be used.", e);
        }
        if (this.optionsEditor == null || !(this.optionsEditor instanceof Component)) {
            this.optionsEditor = new DefaultOptionsEditor();
        }
        this.scrollOptions = new JScrollPane((Component)((Object)this.optionsEditor));
        this.scrollOptions.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Options"));
        this.okButt = new JButton("   OK  ");
        this.cancelButt = new JButton("Cancel");
        this.okButt.setActionCommand("OK_CMD");
        this.okButt.addActionListener(this);
        this.cancelButt.setActionCommand("CANCEL_CMD");
        this.cancelButt.addActionListener(this);
        this.southPane.add(this.okButt);
        this.southPane.add(this.cancelButt);
        this.centerPane.add((Component)this.moduleNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.centerPane.add((Component)this.moduleNameField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 10, 5), 0, 0));
        this.centerPane.add((Component)this.positionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.centerPane.add((Component)this.positions, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPane.add((Component)this.flagLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.centerPane.add((Component)this.comboFlags, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 17, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPane.add((Component)this.scrollOptions, new GridBagConstraints(0, 3, 3, 3, 1.0, 0.1, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.dialogPane.add((Component)this.centerPane, "Center");
        this.dialogPane.add((Component)this.southPane, "South");
        this.getContentPane().add(this.dialogPane);
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }

    private void okAction() {
        this.isOK = true;
        ((Component)this).setVisible(false);
    }

    private void cancelAction() {
        this.isOK = false;
        ((Component)this).setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK_CMD")) {
            this.okAction();
        } else if (e.getActionCommand().equals("CANCEL_CMD")) {
            this.cancelAction();
        }
    }

    public boolean isOK() {
        return this.isOK;
    }

    public String getName() {
        return this.name;
    }

    public String getFlag() {
        return (String)this.comboFlags.getSelectedItem();
    }

    public int getPosition() {
        return this.positions.getValue() - 1;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFlag(String flag) {
        this.comboFlags.setSelectedItem(flag);
    }

    public void setPosition(int position) {
        this.positions.setValue(position + 1);
    }

    public Map getOptions() {
        return this.optionsEditor.getOptions();
    }

    public void setOptions(Map options) {
        this.optionsEditor.setOptions(options);
    }
}

