/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.jaas;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.services.security.gui.jaas.TripleTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractTripleTablePanel
extends JPanel
implements ActionListener,
FocusListener,
ItemListener,
ListSelectionListener {
    public static final String MODIFY_CMD = "MODIFY_CMD";
    public static final String REMOVE_CMD = "REMOVE_CMD";
    public static final String NEW_CMD = "NEW_CMD";
    public static final int INIT_WIDTH = 450;
    public static final int INIT_HEIGHT = 300;
    public boolean blockTemplates = true;
    public JComboBox templateUsage;
    public JTable table;
    public JButton modifyButton;
    public JButton removeButton;
    public JButton newButton;

    public AbstractTripleTablePanel() {
        this.initPanel();
        LookAndFeelHandler.add(this);
        this.blockTemplates = false;
    }

    private void initPanel() {
        JComboBox<String> flags = new JComboBox<String>(new String[]{"OPTIONAL", "REQUIRED", "REQUISITE", "SUFFICIENT"});
        this.setLayout(new BorderLayout());
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new GridBagLayout());
        this.table = new JTable(new TripleTableModel(this));
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(flags));
        this.table.getSelectionModel().setSelectionMode(0);
        tablePanel.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 3, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.modifyButton = new JButton("Modify");
        this.modifyButton.setActionCommand(MODIFY_CMD);
        this.modifyButton.setEnabled(false);
        this.modifyButton.addActionListener(this);
        buttonPanel.add(this.modifyButton);
        this.removeButton = new JButton("Remove");
        this.removeButton.setActionCommand(REMOVE_CMD);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        buttonPanel.add(this.removeButton);
        this.newButton = new JButton("Add New");
        this.newButton.setActionCommand(NEW_CMD);
        this.newButton.addActionListener(this);
        buttonPanel.add(this.newButton);
        JPanel templatePanel = new JPanel(new GridBagLayout());
        this.templateUsage = new JComboBox<String>(new String[0]);
        this.templateUsage.addItemListener(this);
        this.templateUsage.addFocusListener(this);
        this.templateUsage.addItem("no");
        templatePanel.add((Component)new JLabel(" Authentication template: "), new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        templatePanel.add((Component)this.templateUsage, new GridBagConstraints(1, 0, 2, 2, 0.1, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)templatePanel, "North");
        this.add((Component)tablePanel, "Center");
        this.add((Component)buttonPanel, "South");
        this.setPreferredSize(new Dimension(450, 300));
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(MODIFY_CMD)) {
            this.modifyBtnAction();
        }
        if (cmd.equals(REMOVE_CMD)) {
            this.removeBtnAction();
        }
        if (cmd.equals(NEW_CMD)) {
            this.newBtnAction();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (!this.blockTemplates && e.getStateChange() == 1) {
            this.modifyTemplate((String)e.getItem());
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            this.removeButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
            return;
        }
        this.removeButton.setEnabled(true);
        this.modifyButton.setEnabled(true);
    }

    public void focusGained(FocusEvent fe) {
        Object component = this.templateUsage.getSelectedItem();
        this.setTemplates();
        if (component != null && component != this.templateUsage.getSelectedItem()) {
            this.templateUsage.setSelectedItem(component);
        }
    }

    public void focusLost(FocusEvent fe) {
    }

    protected abstract void modifyAction(int var1, int var2, String var3, String var4, Map var5);

    protected abstract void modifyTemplate(String var1);

    protected abstract void modifyBtnAction();

    protected abstract void removeBtnAction();

    protected abstract void newBtnAction();

    protected abstract void setTemplates();
}

