/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.domains;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.SecurityControl;
import com.sap.engine.services.security.gui.domains.DomainsTreePanel;
import com.sap.engine.services.security.gui.domains.PermissionControl;
import com.sap.engine.services.security.remote.domains.RemoteProtectionDomains;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class ProtectionDomainControl
extends JPanel
implements TreeSelectionListener {
    public static Frame frame = null;
    DomainsTreePanel domains = null;
    PermissionControl permissions = null;
    RemoteProtectionDomains service = null;
    SecurityControl security = null;

    public ProtectionDomainControl(SecurityControl security) {
        this.security = security;
        this.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1);
        JPanel leftPanel = this.getLeftPanel();
        JPanel rightPanel = this.getRightPanel();
        splitPane.setLeftComponent(leftPanel);
        splitPane.setRightComponent(rightPanel);
        splitPane.setDividerLocation(200);
        this.add((Component)splitPane, "Center");
        this.repaint();
    }

    public ProtectionDomainControl(SecurityControl security, Frame frame) {
        this(security);
        this.setFrame(frame);
    }

    public void update() {
        if (this.security != null) {
            try {
                this.service = this.security.getSecurityInterface().getProtectionDomains();
                this.domains.init(this.service.getDomainsNames());
                this.permissions.setRemoteProtectionDomainManager(this.service);
            }
            catch (Exception e) {
                ExceptionHandler.error("Unable to visualize protection domain control panel!", e);
            }
        }
    }

    public void setFrame(Frame f) {
        frame = f;
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.permissions.setSelectedProtectionDomain(this.domains.getSelectedDomain());
    }

    protected JPanel getLeftPanel() {
        this.domains = new DomainsTreePanel(" Protection Domains ");
        this.domains.addTreeSelectionListener(this);
        return this.domains;
    }

    private JPanel getRightPanel() {
        this.permissions = new PermissionControl();
        return this.permissions;
    }
}

