/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.domains;

import com.sap.engine.services.security.domains.PRecord;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.domains.PermissionsCellRenderer;
import com.sap.engine.services.security.gui.domains.PermissionsTreeActionNode;
import com.sap.engine.services.security.gui.domains.PermissionsTreeCollectionNode;
import com.sap.engine.services.security.gui.domains.PermissionsTreeNode;
import com.sap.engine.services.security.gui.domains.PermissionsTreeRootNode;
import com.sap.engine.services.security.remote.domains.RemoteProtectionDomains;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PermissionsTreePanel
extends JPanel {
    protected JTree tree = new JTree();
    protected PermissionsTreeRootNode root = null;
    private String domainName = null;
    private RemoteProtectionDomains domainManager = null;
    private boolean showAvaible = false;

    public PermissionsTreePanel(String title) throws Exception {
        JScrollPane scroll = new JScrollPane();
        if (title != null) {
            this.showAvaible = title.equals(" Available Permissions ");
            if (!this.showAvaible) {
                this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
            }
            this.showAvaible = title.equals(" Available Permissions ");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        scroll.getViewport().add((Component)this.tree, null);
        this.empty();
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new PermissionsCellRenderer());
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(listener);
    }

    public void init(String domainName, RemoteProtectionDomains manager) throws Exception {
        this.domainManager = manager;
        this.domainName = domainName;
        this.refreshTree();
    }

    public String[] getSelectedPermission() {
        TreePath selection = this.tree.getSelectionPath();
        if (selection == null) {
            return null;
        }
        Object[] path = selection.getPath();
        if (path.length == 1) {
            return null;
        }
        String[] result = null;
        result = this.showAvaible ? new String[4] : new String[3];
        int i = 0;
        while (i < result.length && i < path.length - 1) {
            result[i] = path[i + 1].toString();
            ++i;
        }
        return result;
    }

    private TreeNode findChild(TreeNode parent, String child) {
        if (child == null) {
            return null;
        }
        int count = parent.getChildCount();
        int i = 0;
        while (i < count) {
            if (child.equalsIgnoreCase(parent.getChildAt(i).toString())) {
                return parent.getChildAt(i);
            }
            ++i;
        }
        return null;
    }

    public void expandTree(String[] selection) {
        TreeNode node = null;
        TreePath path = new TreePath(this.root);
        if (selection != null && (node = this.findChild(this.root, selection[0])) != null) {
            path = path.pathByAddingChild(node);
            if ((node = this.findChild(node, selection[2])) != null) {
                path = path.pathByAddingChild(node);
            } else {
                node = this.findChild(this.root, selection[0]);
            }
            node = this.findChild(node, selection[1]);
            if (node != null) {
                path = path.pathByAddingChild(node);
            }
        }
        this.tree.expandPath(path);
        this.tree.setSelectionPath(path);
    }

    public void empty() {
        this.root = new PermissionsTreeRootNode("select a domain");
        ((DefaultTreeModel)this.tree.getModel()).setRoot(this.root);
    }

    public void refreshTree() throws Exception {
        if (this.showAvaible) {
            this.root = new PermissionsTreeRootNode("available");
            Vector allKnownPermissions = this.domainManager.getAllKnownPermissions();
            int i = 0;
            while (i < allKnownPermissions.size()) {
                String[][] record = (String[][])allKnownPermissions.get(i);
                String className = record[0][0];
                String[] names = record[1];
                String[] actions = record[2];
                PermissionsTreeCollectionNode permissionNode = new PermissionsTreeCollectionNode(className);
                PermissionsTreeCollectionNode namesNode = new PermissionsTreeCollectionNode("TARGETS");
                PermissionsTreeCollectionNode actionNode = new PermissionsTreeCollectionNode("ACTIONS");
                PermissionsTreeCollectionNode combNode = new PermissionsTreeCollectionNode("VARIANTS");
                permissionNode.add(namesNode);
                permissionNode.add(actionNode);
                permissionNode.add(combNode);
                int j = 0;
                while (j < names.length) {
                    PermissionsTreeNode nameNode = new PermissionsTreeNode(names[j]);
                    namesNode.add(nameNode);
                    ++j;
                }
                int k = 0;
                while (k < actions.length) {
                    PermissionsTreeActionNode actions_ = new PermissionsTreeActionNode(actions[k]);
                    actionNode.add(actions_);
                    ++k;
                }
                int j2 = 0;
                while (j2 < names.length) {
                    PermissionsTreeNode nameNode = new PermissionsTreeNode(names[j2]);
                    PermissionsTreeActionNode[] actionsNode = new PermissionsTreeActionNode[actions.length];
                    int k2 = 0;
                    while (k2 < actions.length) {
                        actionsNode[k2] = new PermissionsTreeActionNode(actions[k2]);
                        nameNode.add(actionsNode[k2]);
                        ++k2;
                    }
                    combNode.add(nameNode);
                    ++j2;
                }
                this.root.add(permissionNode);
                ++i;
            }
        } else {
            String alias;
            this.root = new PermissionsTreeRootNode(this.domainName);
            Vector grantedPermissions = null;
            try {
                grantedPermissions = this.domainManager.getPermissions(this.domainName);
            }
            catch (Exception e) {
                ExceptionHandler.error("Did not get permissions for domain " + this.domainName, e);
                return;
            }
            Hashtable all_permissions = new Hashtable();
            int i = 0;
            while (i < grantedPermissions.size()) {
                PRecord record = (PRecord)grantedPermissions.get(i);
                alias = record.getClassName();
                String name = record.getName();
                Hashtable permission = null;
                permission = (Hashtable)all_permissions.get(alias);
                if (permission == null) {
                    permission = new Hashtable();
                    all_permissions.put(alias, permission);
                }
                if (name != null) {
                    Vector<String> all_actions = (Vector<String>)permission.get(name);
                    if (all_actions == null) {
                        all_actions = new Vector<String>();
                        permission.put(name, all_actions);
                    }
                    if (record.getActions() != null) {
                        all_actions.add(record.getActions());
                    }
                }
                ++i;
            }
            Enumeration keys = all_permissions.keys();
            while (keys.hasMoreElements()) {
                alias = (String)keys.nextElement();
                PermissionsTreeCollectionNode permissionNode = new PermissionsTreeCollectionNode(alias);
                this.root.add(permissionNode);
                Hashtable names = (Hashtable)all_permissions.get(alias);
                Enumeration nameKeys = names.keys();
                while (nameKeys.hasMoreElements()) {
                    String name = (String)nameKeys.nextElement();
                    Vector actions = (Vector)names.get(name);
                    PermissionsTreeNode nameNode = new PermissionsTreeNode(name);
                    permissionNode.add(nameNode);
                    int i2 = 0;
                    while (i2 < actions.size()) {
                        PermissionsTreeActionNode actionNode = new PermissionsTreeActionNode((String)actions.get(i2));
                        nameNode.add(actionNode);
                        ++i2;
                    }
                }
            }
        }
        ((DefaultTreeModel)this.tree.getModel()).setRoot(this.root);
    }
}

