/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.domains;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.domains.AddNewPermissionDialog;
import com.sap.engine.services.security.gui.domains.PermissionsTreePanel;
import com.sap.engine.services.security.gui.domains.ProtectionDomainControl;
import com.sap.engine.services.security.remote.domains.RemoteProtectionDomains;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class PermissionControl
extends JPanel
implements ActionListener,
TreeSelectionListener {
    RemoteProtectionDomains service = null;
    PermissionsTreePanel permissionsPanel = null;
    PermissionsTreePanel availablePermissionsPanel = null;
    JButton grantButton = null;
    JButton denyButton = null;
    JButton addButton = null;
    JButton removeButton = null;
    String protectionDomain = null;

    public PermissionControl() {
        try {
            this.init();
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to visualize protection domain panel!", e);
        }
    }

    public void setRemoteProtectionDomainManager(RemoteProtectionDomains domains) {
        try {
            this.service = domains;
            this.availablePermissionsPanel.init(null, this.service);
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to visualize available permissions!", e);
        }
    }

    public void setSelectedProtectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
        try {
            if (protectionDomain == null) {
                this.permissionsPanel.empty();
            } else {
                this.permissionsPanel.init(protectionDomain, this.service);
            }
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to update the selected protection domain!", e);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            String[] selection = null;
            if (ae.getActionCommand().equals("GRANT_CMD")) {
                selection = this.availablePermissionsPanel.getSelectedPermission();
                if (selection != null) {
                    this.service.grantPermission(this.protectionDomain, selection[0], selection[2], selection[3]);
                    this.permissionsPanel.refreshTree();
                    this.permissionsPanel.expandTree(selection);
                }
            } else if (ae.getActionCommand().equals("DENY_CMD")) {
                selection = this.permissionsPanel.getSelectedPermission();
                if (selection != null) {
                    this.service.clearPermission(this.protectionDomain, selection[0], selection[1], selection[2]);
                    this.permissionsPanel.refreshTree();
                    this.permissionsPanel.expandTree(selection);
                }
                this.permissionsPanel.refreshTree();
                if (selection != null) {
                    this.permissionsPanel.expandTree(selection);
                }
            } else if (ae.getActionCommand().equals("ADD_CMD")) {
                selection = this.availablePermissionsPanel.getSelectedPermission();
                AddNewPermissionDialog addDialog = new AddNewPermissionDialog(ProtectionDomainControl.frame, this.service.getAllKnownPermissions(), selection != null ? selection[0] : null);
                String[] result = addDialog.getResult();
                if (result == null) {
                    return;
                }
                this.service.addKnownPermission(result[0], new String[]{result[1]}, new String[]{result[2]});
                this.availablePermissionsPanel.refreshTree();
            } else if (ae.getActionCommand().equals("REMOVE_CMD") && (selection = this.availablePermissionsPanel.getSelectedPermission()) != null) {
                String[] stringArray;
                String[] stringArray2;
                if (selection[2] == null) {
                    stringArray2 = null;
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray2 = stringArray3;
                    stringArray3[0] = selection[2];
                }
                String[] targets = stringArray2;
                if (selection[3] == null) {
                    stringArray = null;
                } else {
                    String[] stringArray4 = new String[1];
                    stringArray = stringArray4;
                    stringArray4[0] = selection[3];
                }
                String[] actions = stringArray;
                this.service.removeKnownPermission(selection[0], targets, actions);
                this.availablePermissionsPanel.refreshTree();
                this.availablePermissionsPanel.expandTree(selection);
            }
        }
        catch (RemoteException re) {
            ExceptionHandler.error("Grant/deny action failed!", re);
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to refresh protection domains panel!", e);
        }
    }

    public void valueChanged(TreeSelectionEvent event) {
        Object event_source = null;
        String[] selection = null;
        if (event == null) {
            return;
        }
        event_source = event.getSource();
        if (event_source.equals(this.availablePermissionsPanel.tree)) {
            selection = this.availablePermissionsPanel.getSelectedPermission();
            boolean isEnabled = selection != null && selection[0] != null && (selection[1] != null && !selection[1].equals("VARIANTS") && selection[2] != null || selection[1] == null);
            this.removeButton.setEnabled(isEnabled);
            this.grantButton.setEnabled(selection != null && selection[0] != null && selection[1] != null && selection[1].equals("VARIANTS") && selection[2] != null);
        } else if (event_source.equals(this.permissionsPanel.tree)) {
            selection = this.permissionsPanel.getSelectedPermission();
            this.denyButton.setEnabled(selection != null && selection[1] != null);
        }
    }

    private void init() throws Exception {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        this.grantButton = new JButton();
        this.grantButton.setText("Grant");
        this.grantButton.setEnabled(false);
        this.grantButton.addActionListener(this);
        this.grantButton.setActionCommand("GRANT_CMD");
        this.denyButton = new JButton();
        this.denyButton.setText("Clear");
        this.denyButton.setEnabled(false);
        this.denyButton.addActionListener(this);
        this.denyButton.setActionCommand("DENY_CMD");
        this.addButton = new JButton();
        this.addButton.setText("New");
        this.addButton.addActionListener(this);
        this.addButton.setActionCommand("ADD_CMD");
        this.removeButton = new JButton();
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(this);
        this.removeButton.setActionCommand("REMOVE_CMD");
        JPanel permissionPanel = new JPanel(new BorderLayout());
        this.permissionsPanel = new PermissionsTreePanel(" Granted Permissions ");
        this.permissionsPanel.addTreeSelectionListener(this);
        permissionPanel.add((Component)this.permissionsPanel, "Center");
        JPanel allPanel = new JPanel(new BorderLayout());
        this.availablePermissionsPanel = new PermissionsTreePanel(" Available Permissions ");
        this.availablePermissionsPanel.addTreeSelectionListener(this);
        allPanel.add((Component)this.availablePermissionsPanel, "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        btnPanel.add(this.addButton);
        btnPanel.add(this.removeButton);
        allPanel.add((Component)btnPanel, "South");
        allPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "  Available permissions "));
        this.add((Component)permissionPanel, new GridBagConstraints(0, 0, 1, 2, 1.4, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.grantButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.5, 15, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.denyButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.5, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)allPanel, new GridBagConstraints(2, 0, 1, 2, 0.4, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }
}

