/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.domains;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.domains.DomainsTreeNode;
import com.sap.engine.services.security.gui.domains.DomainsTreeParentNode;
import com.sap.engine.services.security.gui.domains.PermissionsCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DomainsTreePanel
extends JPanel {
    protected JTree tree = new JTree();

    public DomainsTreePanel(String title) {
        try {
            JScrollPane scroll = new JScrollPane();
            if (title != null) {
                this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
            }
            this.setLayout(new BorderLayout());
            this.add((Component)scroll, "Center");
            scroll.getViewport().add((Component)this.tree, null);
            DomainsTreeParentNode root = new DomainsTreeParentNode("domains");
            ((DefaultTreeModel)this.tree.getModel()).setRoot(root);
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.setCellRenderer(new PermissionsCellRenderer());
        }
        catch (Exception ex) {
            ExceptionHandler.error("Unable to initialize protection domains panel!", ex);
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(listener);
    }

    public void init(String[] domains) {
        DomainsTreeParentNode root = new DomainsTreeParentNode("domains");
        int i = 0;
        while (i < domains.length) {
            DefaultMutableTreeNode child = root;
            DomainsTreeParentNode parent = root;
            String token = null;
            StringTokenizer tokenizer = new StringTokenizer(domains[i], "/");
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                child = (DefaultMutableTreeNode)this.findChild(parent, token);
                if (child == null) break;
                parent = child;
            }
            while (tokenizer.hasMoreTokens()) {
                child = new DomainsTreeParentNode(token);
                parent.add(child);
                parent = child;
                token = tokenizer.nextToken();
            }
            if (this.findChild(parent, token) == null) {
                child = new DomainsTreeNode(token, domains[i]);
                parent.add(child);
            }
            ++i;
        }
        ((DefaultTreeModel)this.tree.getModel()).setRoot(root);
        this.repaint();
    }

    public String getSelectedDomain() {
        Object node;
        TreePath selection = this.tree.getSelectionPath();
        if (selection != null && (node = selection.getLastPathComponent()) instanceof DomainsTreeNode) {
            return ((DomainsTreeNode)node).getName();
        }
        return null;
    }

    private TreeNode findChild(TreeNode parent, String child) {
        if (child == null) {
            return null;
        }
        int count = parent.getChildCount();
        int i = 0;
        while (i < count) {
            if (child.equalsIgnoreCase(parent.getChildAt(i).toString())) {
                return parent.getChildAt(i);
            }
            ++i;
        }
        return null;
    }
}

