/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.domains;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddNewPermissionDialog
extends JDialog
implements ActionListener,
ItemListener,
DocumentListener {
    private String[] result = null;
    Vector all_known_permissions = null;
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JComboBox classNames = new JComboBox();
    private JComboBox targets = new JComboBox();
    private JComboBox actions = new JComboBox();
    private JPanel mainPanel = new JPanel();
    JPanel buttonsPanel = new JPanel();

    public AddNewPermissionDialog(Frame frame, Vector all_permissions, String initialPermission) throws Exception {
        super(frame, "Add new permission", true);
        this.all_known_permissions = all_permissions;
        this.okButton.setActionCommand("OK");
        this.okButton.setEnabled(false);
        this.cancelButton.setActionCommand("CANCEL");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.buttonsPanel.setLayout(new FlowLayout());
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(this.cancelButton);
        int i = 0;
        while (i < this.all_known_permissions.size()) {
            String[][] p = (String[][])this.all_known_permissions.get(i);
            this.classNames.addItem(p[0][0]);
            ++i;
        }
        if (initialPermission != null) {
            this.classNames.setSelectedItem(initialPermission);
        }
        String className = (String)this.classNames.getSelectedItem();
        int i2 = 0;
        while (i2 < this.all_known_permissions.size()) {
            String[][] p = (String[][])this.all_known_permissions.get(i2);
            if (p[0][0].equals(className)) {
                this.targets.removeAllItems();
                int j = 0;
                while (j < p[1].length) {
                    this.targets.addItem(p[1][j]);
                    ++j;
                }
                this.actions.removeAllItems();
                int j2 = 0;
                while (j2 < p[2].length) {
                    this.actions.addItem(p[2][j2]);
                    ++j2;
                }
                break;
            }
            ++i2;
        }
        this.targets.addItemListener(this);
        this.actions.addItemListener(this);
        this.classNames.addItemListener(this);
        this.targets.addActionListener(this);
        this.actions.addActionListener(this);
        this.classNames.addActionListener(this);
        this.targets.setEditable(true);
        this.actions.setEditable(true);
        this.classNames.setEditable(true);
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)new JLabel("  Specify Class Name: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)new JLabel("  Specify Target Name: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)new JLabel("  Specify Action: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.classNames, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.targets, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.1, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.actions, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.1, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.buttonsPanel, new GridBagConstraints(0, 3, 2, 1, 0.1, 0.1, 15, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.setAllSizes();
        this.getContentPane().add(this.mainPanel);
        ((Component)this).setSize(700, 300);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int posX = (int)((double)d.width - this.getSize().getWidth());
        int posY = (int)((double)d.height - this.getSize().getHeight());
        ((Component)this).setLocation(posX / 2, posY / 2);
        ((Component)this).setVisible(true);
    }

    private void setAllSizes() {
        this.targets.setMaximumSize(new Dimension(200, (int)this.targets.getPreferredSize().getHeight()));
        this.targets.setMinimumSize(new Dimension(200, (int)this.targets.getPreferredSize().getHeight()));
        this.actions.setMaximumSize(new Dimension(200, (int)this.actions.getPreferredSize().getHeight()));
        this.actions.setMinimumSize(new Dimension(200, (int)this.actions.getPreferredSize().getHeight()));
        this.classNames.setMaximumSize(new Dimension(200, (int)this.classNames.getPreferredSize().getHeight()));
        this.classNames.setMinimumSize(new Dimension(200, (int)this.classNames.getPreferredSize().getHeight()));
    }

    public synchronized void actionPerformed(ActionEvent e) {
        String className = null;
        String targetName = null;
        String actionNames = null;
        if (e.getActionCommand().equals("OK")) {
            className = (String)this.classNames.getSelectedItem();
            targetName = (String)this.targets.getSelectedItem();
            actionNames = (String)this.actions.getSelectedItem();
            if (targetName == null || targetName.length() == 0) {
                targetName = null;
            }
            if (actionNames == null || actionNames.length() == 0) {
                actionNames = null;
            }
            this.result = new String[]{className, targetName, actionNames};
        } else if (e.getActionCommand().equals("CANCEL")) {
            this.result = null;
        } else {
            if (e.getSource().equals(this.classNames)) {
                return;
            }
            if (e.getSource().equals(this.targets)) {
                return;
            }
            if (e.getSource().equals(this.actions)) {
                return;
            }
        }
        ((Component)this).setVisible(false);
    }

    public synchronized void itemStateChanged(ItemEvent e) {
        String className;
        if (e.getStateChange() == 1 && e.getSource().equals(this.classNames)) {
            className = (String)this.classNames.getSelectedItem();
            int i = 0;
            while (i < this.all_known_permissions.size()) {
                String[][] p = (String[][])this.all_known_permissions.get(i);
                if (p[0][0].equals(className)) {
                    this.targets.removeAllItems();
                    int j = 0;
                    while (j < p[1].length) {
                        this.targets.addItem(p[1][j]);
                        ++j;
                    }
                    this.actions.removeAllItems();
                    int j2 = 0;
                    while (j2 < p[2].length) {
                        this.actions.addItem(p[2][j2]);
                        ++j2;
                    }
                    break;
                }
                ++i;
            }
        }
        className = (String)this.classNames.getSelectedItem();
        String targetName = (String)this.targets.getSelectedItem();
        if (className == null || targetName == null) {
            return;
        }
        this.okButton.setEnabled(className.trim().length() != 0 && targetName.trim().length() != 0);
        this.setAllSizes();
    }

    public String[] getResult() {
        return this.result;
    }

    public void insertUpdate(DocumentEvent e) {
        String className = (String)this.classNames.getSelectedItem();
        String targetName = (String)this.targets.getSelectedItem();
        this.okButton.setEnabled(className.trim().length() != 0 && targetName.trim().length() != 0);
    }

    public void removeUpdate(DocumentEvent e) {
        String className = (String)this.classNames.getSelectedItem();
        String targetName = (String)this.targets.getSelectedItem();
        this.okButton.setEnabled(className.trim().length() != 0 && targetName.trim().length() != 0);
    }

    public void changedUpdate(DocumentEvent e) {
        String className = (String)this.classNames.getSelectedItem();
        String targetName = (String)this.targets.getSelectedItem();
        this.okButton.setEnabled(className.trim().length() != 0 && targetName.trim().length() != 0);
    }
}

