/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.crypt;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.SecurityControl;
import com.sap.engine.services.security.remote.crypt.RemoteCryptography;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CryptographyControlProviders
extends JPanel
implements ActionListener,
ChangeListener,
ListSelectionListener {
    static final String CREATE_BUTTON = "create";
    static final String DELETE_BUTTON = "delete";
    static final String MOVE_UP_BUTTON = "move up";
    static final String MOVE_DOWN_BUTTON = "move down";
    static final String SET_BUTTON = "set";
    static final String RESTORE_BUTTON = "restore";
    SecurityControl security = null;
    RemoteCryptography crypt = null;
    Vector providers = null;
    JList list = null;
    JScrollPane scrollArea = null;
    JTextArea textArea = new JTextArea();
    private Frame frame;
    boolean isAction = false;

    public CryptographyControlProviders(SecurityControl security) {
        this.security = security;
        this.providers = new Vector();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.list = new JList(this.providers);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        this.scrollArea = new JScrollPane(this.list);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        JScrollPane areaScrollPane = new JScrollPane(this.textArea);
        areaScrollPane.setPreferredSize(new Dimension(10, 200));
        areaScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Provider Information "));
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new GridBagLayout());
        panelButtons.add((Component)this.createButton("Create", CREATE_BUTTON), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 5, 5, 5), 0, 0));
        panelButtons.add((Component)this.createButton("Delete", DELETE_BUTTON), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelButtons.add((Component)this.createButton("Move Up", MOVE_UP_BUTTON), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelButtons.add((Component)this.createButton("Move Down", MOVE_DOWN_BUTTON), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelButtons.add((Component)this.createButton("Set", SET_BUTTON), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelButtons.add((Component)this.createButton("Restore", RESTORE_BUTTON), new GridBagConstraints(0, 5, 1, 1, 0.1, 0.1, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Providers "));
        panel.add((Component)this.scrollArea, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)areaScrollPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        this.add((Component)panelButtons, "East");
    }

    private JButton createButton(String text, String action) {
        JButton result = new JButton(text);
        result.setActionCommand(action);
        result.addActionListener(this);
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        try {
            if (actionCommand.equals(CREATE_BUTTON)) {
                this.create();
            } else if (actionCommand.equals(SET_BUTTON)) {
                this.set();
            } else if (actionCommand.equals(RESTORE_BUTTON)) {
                this.restore();
            } else if (this.list.getSelectedIndex() < 0) {
                this.textArea.setText("Please, select a provider!\n");
            } else if (actionCommand.equals(DELETE_BUTTON)) {
                this.delete();
            } else if (actionCommand.equals(MOVE_UP_BUTTON)) {
                this.moveUp();
            } else if (actionCommand.equals(MOVE_DOWN_BUTTON)) {
                this.moveDown();
            }
        }
        catch (Exception re) {
            ExceptionHandler.error(this.frame, "Unable to " + actionCommand + " cryptography provider!", re);
        }
    }

    private void create() throws Exception {
        String insertProvider = JOptionPane.showInputDialog(this.frame, (Object)"Specify provider class name: ");
        if (insertProvider != null) {
            this.providers.add(insertProvider);
        }
        this.updateView();
    }

    private void delete() throws Exception {
        if (!this.providers.elementAt(this.list.getSelectedIndex()).equals("sun.security.provider.Sun")) {
            this.providers.remove(this.list.getSelectedIndex());
        }
        this.updateView();
    }

    private void moveUp() throws Exception {
        int selectItem = this.list.getSelectedIndex();
        if (selectItem != 0) {
            this.providers.insertElementAt(this.providers.elementAt(selectItem), selectItem - 1);
            this.providers.removeElementAt(selectItem + 1);
            this.list.setSelectedIndex(selectItem - 1);
        }
        this.updateView();
    }

    private void moveDown() throws Exception {
        int selectItem = this.list.getSelectedIndex();
        if (selectItem < this.providers.size() - 1) {
            this.providers.insertElementAt(this.providers.elementAt(selectItem + 1), selectItem);
            this.providers.removeElementAt(selectItem + 2);
            this.list.setSelectedIndex(selectItem + 1);
        }
        this.updateView();
    }

    private void set() throws Exception {
        this.crypt.setInstalledProviders(this.providers);
        this.updateProviders();
    }

    private void restore() throws Exception {
        this.updateProviders();
    }

    public void stateChanged(ChangeEvent event) {
        if (this.crypt == null) {
            try {
                this.crypt = this.security.getSecurityInterface().getCryptography();
            }
            catch (Exception e) {
                ExceptionHandler.error(this.frame, "Unable to retrieve cryptography information from server!", e);
            }
        }
        try {
            this.restore();
        }
        catch (Exception r) {
            ExceptionHandler.error(this.frame, "Unable to update cryptography providers list!", r);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        String selectedItem = (String)this.list.getSelectedValue();
        if (selectedItem != null) {
            try {
                String str = this.crypt.getProviderInfo(selectedItem);
                this.textArea.setText(str);
                this.scrollArea.repaint();
            }
            catch (Exception r) {
                ExceptionHandler.error(this.frame, "Unable to retrieve information for cryptography provider '" + selectedItem + "'!", r);
            }
        }
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    private void updateView() throws Exception {
        this.list.setListData(this.providers);
        this.list.validate();
        this.scrollArea.repaint();
    }

    private void updateProviders() throws Exception {
        Vector newProviders = this.crypt.getInstalledProviders();
        this.providers.clear();
        this.providers.addAll(newProviders);
        this.updateView();
    }
}

