/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.gui.UserNode;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.PolicyConfigurationsControl;
import com.sap.engine.services.security.gui.crypt.CryptographyControlProviders;
import com.sap.engine.services.security.gui.domains.ProtectionDomainControl;
import com.sap.engine.services.security.gui.login.LoginControl;
import com.sap.engine.services.security.gui.userstore.UserStoreControl;
import com.sap.engine.services.security.gui.userstore.usermanagement.UMHash;
import com.sap.engine.services.security.remote.RemoteSecurity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SecurityControl
extends JPanel
implements VisualRuntimeControl,
ChangeListener {
    private Frame frame = null;
    private JTabbedPane tabs = null;
    private RemoteSecurity securityInterface = null;
    private CryptographyControlProviders crypt = null;
    private UserStoreControl users = new UserStoreControl(this);
    private ProtectionDomainControl domains = null;
    private LoginControl login = null;
    private PolicyConfigurationsControl policyConfigurations = null;

    public SecurityControl() {
        this.crypt = new CryptographyControlProviders(this);
        this.domains = new ProtectionDomainControl(this);
        this.login = new LoginControl(this);
        this.policyConfigurations = new PolicyConfigurationsControl(this);
    }

    private void initialize() {
        try {
            UMHash.clear();
        }
        catch (Exception e) {
            ExceptionHandler.error("Cannot clear user tree table!", e);
        }
        try {
            this.setLayout(new BorderLayout());
            this.policyConfigurations.initialize();
            this.tabs = new JTabbedPane();
            this.tabs.add("Policy Configurations", this.policyConfigurations);
            this.tabs.add("User Management", this.users);
            this.tabs.add("Login Sessions", this.login);
            this.tabs.add("Protection Domains", this.domains);
            this.tabs.add("Cryptography Providers", this.crypt);
            this.tabs.addChangeListener(this);
            this.tabs.addChangeListener(this.crypt);
            this.tabs.setSelectedIndex(0);
            this.add((Component)this.tabs, "Center");
        }
        catch (Throwable e) {
            ExceptionHandler.error("Cannot initialize security control!", e);
        }
    }

    public Frame getFrame() {
        return this.frame;
    }

    public RemoteSecurity getSecurityInterface() {
        return this.securityInterface;
    }

    public void stateChanged(ChangeEvent e) {
        if (this.tabs.getSelectedComponent() == this.login) {
            this.login.update();
        } else if (this.tabs.getSelectedComponent() == this.users) {
            this.users.update();
        } else if (this.tabs.getSelectedComponent() == this.domains) {
            this.domains.update();
        } else if (this.tabs.getSelectedComponent() == this.policyConfigurations) {
            this.policyConfigurations.update();
        }
    }

    public JComponent getRuntimeControlComponent() {
        return this;
    }

    public JMenu getRuntimeMenu() {
        return null;
    }

    public JButton[] getRuntimeButtons() {
        return null;
    }

    public void freeResources() {
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
        ExceptionHandler.setParentComponent(frame);
        this.domains.setFrame(frame);
        this.login.setFrame(frame);
        this.policyConfigurations.setFrame(frame);
    }

    public void setUserTree(UserNode root) {
    }

    public void setTaskManager(EditorViewManager manager) {
    }

    public void setEnvironment(String editorToolName, Object environment) {
        ExceptionHandler.setViewer(environment);
    }

    public void setRuntime(ManagementInterface service) {
        this.show(service);
    }

    public void setGlobalRuntime(ManagementInterface service) {
        this.show(service);
    }

    public void show(ManagementInterface service) {
        try {
            this.securityInterface = (RemoteSecurity)service;
            this.initialize();
        }
        catch (Throwable e) {
            ExceptionHandler.error(this.frame, "Error in vizualization", e);
        }
    }

    public String getSelectedUserStore() {
        return this.users.getSelectedStore();
    }
}

