/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.SecurityControl;
import com.sap.engine.services.security.gui.jaas.LoginModuleControl;
import com.sap.engine.services.security.gui.resource.ResourceControl;
import com.sap.engine.services.security.gui.roles.RolePanel;
import com.sap.engine.services.security.gui.util.SortedComponentsList;
import com.sap.engine.services.security.remote.RemotePolicyConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PolicyConfigurationsControl
extends JPanel
implements ActionListener,
ChangeListener,
ListSelectionListener {
    private static final String IS_CUSTOM = "custom";
    private ResourceControl resources = null;
    private LoginModuleControl jaas = null;
    private RolePanel roles = null;
    private SortedComponentsList componentList = null;
    private SecurityControl security = null;
    private JTabbedPane tabs = null;
    private RemotePolicyConfiguration selectedComponent = null;
    private JButton removeComponent = null;

    public PolicyConfigurationsControl(SecurityControl security) {
        this.security = security;
        this.componentList = new SortedComponentsList(new String[0]);
        this.resources = new ResourceControl(security);
        this.jaas = new LoginModuleControl(security);
        this.roles = new RolePanel(security, this);
    }

    public void onComponentChange(String component) {
        this.jaas.onComponentChange(component);
        this.roles.onComponentChange(component);
        this.resources.onComponentChange(component);
        if (this.removeComponent != null) {
            try {
                this.removeComponent.setEnabled("yes".equals(this.selectedComponent.getAuthentication().getProperty(IS_CUSTOM)));
            }
            catch (RemoteException e) {
                this.removeComponent.setEnabled(false);
                ExceptionHandler.debug("Unable to determine if policy configuration can be removed!", e);
            }
        }
    }

    public void update() {
        if (this.tabs.getSelectedComponent() == this.jaas) {
            this.jaas.onComponentChange((String)this.componentList.getSelectedValue());
        } else if (this.tabs.getSelectedComponent() == this.resources) {
            this.resources.onComponentChange((String)this.componentList.getSelectedValue());
        } else if (this.tabs.getSelectedComponent() == this.roles) {
            this.roles.update();
        }
    }

    public void initialize() {
        try {
            this.setLayout(new BorderLayout());
            this.tabs = new JTabbedPane();
            this.tabs.add("Authentication", this.jaas);
            this.tabs.add("Security Roles", this.roles);
            this.tabs.add("Resources", this.resources);
            this.tabs.addChangeListener(this);
            this.componentList.setListData(this.security.getSecurityInterface().listPolicyConfigurations());
            this.componentList.setSelectionMode(0);
            this.componentList.addListSelectionListener(this);
            if (this.componentList.getModel().getSize() > 0) {
                this.componentList.setSelectedIndex(0);
            }
            JScrollPane scroll = new JScrollPane(this.componentList);
            scroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Components"));
            JPanel componentsPanel = new JPanel(new BorderLayout());
            componentsPanel.add((Component)scroll, "Center");
            JPanel buttonsPanel = new JPanel();
            JButton addComponent = new JButton("Add");
            addComponent.addActionListener(this);
            addComponent.setActionCommand("Add");
            buttonsPanel.add(addComponent);
            this.removeComponent = new JButton("Remove");
            this.removeComponent.addActionListener(this);
            this.removeComponent.setActionCommand("Remove");
            this.removeComponent.setEnabled(false);
            buttonsPanel.add(this.removeComponent);
            componentsPanel.add((Component)buttonsPanel, "South");
            JSplitPane splitPane = new JSplitPane(1);
            splitPane.setLeftComponent(componentsPanel);
            splitPane.setRightComponent(this.tabs);
            splitPane.setOneTouchExpandable(true);
            splitPane.setDividerLocation(180);
            this.add((Component)splitPane, "Center");
            this.tabs.setSelectedIndex(0);
        }
        catch (Throwable e) {
            ExceptionHandler.error("Unable to initialize policy configurations control!", e);
        }
    }

    public RemotePolicyConfiguration getSelectedComponent() {
        return this.selectedComponent;
    }

    public void actionPerformed(ActionEvent e) {
        String component;
        String command = e.getActionCommand();
        String newSelection = this.getSelectedComponentName();
        if ("Add".equals(command)) {
            try {
                component = JOptionPane.showInputDialog(this, "Enter name for the new policy configuration: ", "Add Security Policy Configuration", 3);
                if (component == null) {
                    return;
                }
                this.security.getSecurityInterface().registerPolicyConfiguration(component);
                RemotePolicyConfiguration componentSecurity = this.security.getSecurityInterface().getPolicyConfiguration(component);
                componentSecurity.getAuthentication().setProperty(IS_CUSTOM, "yes");
                newSelection = component;
            }
            catch (Exception ex) {
                ExceptionHandler.error("Unable to register new policy configuration!", ex);
            }
        } else if ("Remove".equals(command) && (component = (String)this.componentList.getSelectedValue()) != null) {
            try {
                RemotePolicyConfiguration componentSecurity = this.security.getSecurityInterface().getPolicyConfiguration(component);
                if (!"yes".equals(componentSecurity.getAuthentication().getProperty(IS_CUSTOM))) {
                    throw new IllegalArgumentException("Policy configuration cannot be removed!");
                }
                this.security.getSecurityInterface().unregisterPolicyConfiguration(component);
                newSelection = (String)this.componentList.getModel().getElementAt(0);
            }
            catch (Exception ex) {
                ExceptionHandler.error("Unable to unregister policy configuration \"" + component + "\"!", ex);
            }
        }
        try {
            this.componentList.setListData(this.security.getSecurityInterface().listPolicyConfigurations());
            this.componentList.setSelectedValue(newSelection, true);
            if (this.getSelectedComponentName() == null && this.componentList.getModel().getSize() > 0) {
                this.componentList.setSelectedIndex(0);
            }
            this.componentList.repaint();
        }
        catch (RemoteException ex) {
            ExceptionHandler.debug("Unable to update list of policy configurations!", ex);
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.update();
    }

    public void valueChanged(ListSelectionEvent e) {
        try {
            if (e.getValueIsAdjusting()) {
                return;
            }
            String component = this.getSelectedComponentName();
            if (component == null) {
                return;
            }
            RemotePolicyConfiguration componentSecurity = this.security.getSecurityInterface().getPolicyConfiguration(component);
            if (componentSecurity != null) {
                this.selectedComponent = componentSecurity;
                this.onComponentChange(component);
            }
        }
        catch (Exception ex) {
            ExceptionHandler.debug("Unable to list policy configurations!", ex);
        }
    }

    public void setFrame(Frame frame) {
        this.jaas.setFrame(frame);
        this.roles.setFrame(frame);
        this.resources.setFrame(frame);
    }

    public String getSelectedComponentName() {
        return (String)this.componentList.getSelectedValue();
    }
}

