/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.exceptions;

import com.sap.engine.lib.security.LoginExceptionDetails;
import com.sap.engine.services.security.exceptions.SecurityResourceAccessor;
import com.sap.exception.BaseExceptionInfo;
import com.sap.exception.IBaseException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.TimeZone;
import javax.security.auth.login.LoginException;

public class BaseLoginException
extends LoginException
implements IBaseException,
LoginExceptionDetails {
    public static final long serialVersionUID = 5485264041767498558L;
    public static final String USER_SESSIONS_LIMIT_REACHED = "security_1003";
    public static final String LOGIN_PRIVILEGED_ACTION_EXCEPTION = "security_1004";
    public static final String LOGIN_BEFORE_LOGOUT = "security_1005";
    public static final String LOGOUT_PRIVILEGED_ACTION_EXCEPTION = "security_1006";
    public static final String MODULES_PROCESS_ACTION1 = "security_1007";
    public static final String MODULES_PROCESS_ACTION2 = "security_1009";
    public static final String MODULES_PROCESS_ACTION_WEAK = "security_1010";
    public static final String NO_LOGIN_MODULE_SUCCEEDED = "security_1011";
    public static final String NO_CALLBACKHANDLER_AVAILABLE = "security_1015";
    public static final String NOT_AVAILABLE_AUTHENTICATION_INFO = "security_1016";
    public static final String REMOTE_LOGIN_ERROR = "security_1017";
    public static final String CANNOT_AUTHENTICATE_USER = "security_1018";
    public static final String LOGOUT_BEFORE_LOGIN = "security_1019";
    public static final String CANNOT_HANDLE_CALLBACKS = "security_4000";
    public static final String INVALID_TICKET = "security_4001";
    public static final String TICKET_EXPIRED = "security_4002";
    public static final String TICKET_NOT_PROVIDED = "security_4003";
    public static final String DIGEST_NOT_CONFIGURED = "security_4077";
    public static final String CANNOT_LOCK = "security_4096";
    public static final String LOGIN_MODULE_ERROR = "security_4046";
    public static final String CANNOT_CREATE_NEW_REMOTE_LOGIN_CONTEXT = "security_9000";
    public static final String EXCEPTION_IN_CREATING_REMOTE_LOGIN_CONTEXT = "security_9001";
    public static final String CANNOT_CREATE_NEW_REMOTE_LOGIN_CONTEXT_INSTANCE = "security_9002";
    public static final String REMOTE_LOGIN_EXEPTION = "security_9003";
    public static final String REMOTE_LOGOUT_EXEPTION = "security_9004";
    public static final String CHANGE_PASSWORD_IO_EXCEPTION = "security_4106";
    public static final String CHANGE_PASSWORD_NO_CREDENTIALS_EXCEPTION = "security_4107";
    public static final String CANNOT_SET_NEW_PASSWORD_EXCEPTION = "security_4108";
    private byte cause = (byte)-1;
    private BaseExceptionInfo info = null;

    public BaseLoginException(String key) {
        super(key);
        this.info = new BaseExceptionInfo(SecurityResourceAccessor.category, 500, SecurityResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(SecurityResourceAccessor.getResourceAccessor(), key, null), (Throwable)this, null);
    }

    public BaseLoginException(String key, Object[] args) {
        super(key);
        this.info = new BaseExceptionInfo(SecurityResourceAccessor.category, 500, SecurityResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(SecurityResourceAccessor.getResourceAccessor(), key, args), (Throwable)this, null);
    }

    public BaseLoginException(String key, Throwable linkedException) {
        super(key);
        this.info = new BaseExceptionInfo(SecurityResourceAccessor.category, 500, SecurityResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(SecurityResourceAccessor.getResourceAccessor(), key, null), (Throwable)this, linkedException);
    }

    public BaseLoginException(String key, Object[] args, Throwable linkedException) {
        super(key);
        this.info = new BaseExceptionInfo(SecurityResourceAccessor.category, 500, SecurityResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(SecurityResourceAccessor.getResourceAccessor(), key, args), (Throwable)this, linkedException);
    }

    public BaseLoginException(String key, byte cause) {
        super(key);
        this.info = new BaseExceptionInfo(SecurityResourceAccessor.category, 500, SecurityResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(SecurityResourceAccessor.getResourceAccessor(), key, null), (Throwable)this, null);
        this.cause = cause;
    }

    public BaseLoginException(String key, Object[] args, byte cause) {
        super(key);
        this.info = new BaseExceptionInfo(SecurityResourceAccessor.category, 500, SecurityResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(SecurityResourceAccessor.getResourceAccessor(), key, args), (Throwable)this, null);
        this.cause = cause;
    }

    public BaseLoginException(String key, Throwable linkedException, byte cause) {
        super(key);
        this.info = new BaseExceptionInfo(SecurityResourceAccessor.category, 500, SecurityResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(SecurityResourceAccessor.getResourceAccessor(), key, null), (Throwable)this, linkedException);
        this.cause = cause;
    }

    public BaseLoginException(String key, Object[] args, Throwable linkedException, byte cause) {
        super(key);
        this.info = new BaseExceptionInfo(SecurityResourceAccessor.category, 500, SecurityResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(SecurityResourceAccessor.getResourceAccessor(), key, args), (Throwable)this, linkedException);
        this.cause = cause;
    }

    public Throwable initCause(Throwable throwable) {
        return this.info.initCause(throwable);
    }

    public Throwable getCause() {
        return this.info.getCause();
    }

    public String getMessage() {
        if (this.getCause() != null) {
            return this.getCause().getMessage();
        }
        return this.info.getLocalizedMessage();
    }

    public LocalizableText getLocalizableMessage() {
        return this.info.getLocalizableMessage();
    }

    public String getLocalizedMessage() {
        return this.info.getLocalizedMessage();
    }

    public String getLocalizedMessage(Locale locale) {
        return this.info.getLocalizedMessage(locale);
    }

    public String getLocalizedMessage(TimeZone zone) {
        return this.info.getLocalizedMessage(zone);
    }

    public String getLocalizedMessage(Locale locale, TimeZone zone) {
        return this.info.getLocalizedMessage(locale, zone);
    }

    public String getNestedLocalizedMessage() {
        return this.info.getNestedLocalizedMessage();
    }

    public String getNestedLocalizedMessage(Locale locale) {
        return this.info.getNestedLocalizedMessage(locale);
    }

    public String getNestedLocalizedMessage(TimeZone zone) {
        return this.info.getNestedLocalizedMessage(zone);
    }

    public String getNestedLocalizedMessage(Locale locale, TimeZone zone) {
        return this.info.getNestedLocalizedMessage(locale, zone);
    }

    public void finallyLocalize() {
        this.info.finallyLocalize();
    }

    public void finallyLocalize(Locale locale) {
        this.info.finallyLocalize(locale);
    }

    public void finallyLocalize(TimeZone zone) {
        this.info.finallyLocalize(zone);
    }

    public void finallyLocalize(Locale locale, TimeZone zone) {
        this.info.finallyLocalize(locale, zone);
    }

    public String getSystemStackTraceString() {
        StringWriter s = new StringWriter();
        super.printStackTrace(new PrintWriter(s));
        return s.toString();
    }

    public String getStackTraceString() {
        return this.info.getStackTraceString();
    }

    public String getNestedStackTraceString() {
        return this.info.getNestedStackTraceString();
    }

    public void printStackTrace() {
        this.info.printStackTrace();
    }

    public void printStackTrace(PrintStream stream) {
        this.info.printStackTrace(stream);
    }

    public void printStackTrace(PrintWriter writer) {
        this.info.printStackTrace(writer);
    }

    public void setLogSettings(Category category, int i, Location location) {
        this.info.setLogSettings(category, i, location);
    }

    public void log() {
        this.info.log();
    }

    public void trace(int level, Location location) {
        this.info.trace(level, location);
    }

    public byte getExceptionCause() {
        return this.cause;
    }
}

