/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.crypt;

import com.sap.engine.services.security.crypt.CryptographyLock;
import com.sap.engine.services.security.exceptions.BaseKeyStoreException;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptographyModuleCreator {
    private static final byte[] IV = new byte[8];
    private static final String ALGORITHM = "DES";
    private static final String CIPHER = "DES/CBC/PKCS5Padding";
    private static final String DIGEST = "MD5";
    private String name = null;
    private CryptographyLock lock = null;

    public CryptographyModuleCreator(String name, CryptographyLock lock) {
        this.lock = lock;
        this.name = name;
    }

    public Cipher getCipher(int opmode) {
        try {
            if (this.lock.isLocked()) {
                throw new BaseSecurityException("security_0011");
            }
            try {
                byte[] salt = MessageDigest.getInstance(DIGEST).digest(this.name.getBytes());
                Cipher cipher = Cipher.getInstance(CIPHER);
                cipher.init(1, this.lock.getMasterKey(), new IvParameterSpec(IV));
                byte[] encrypted = cipher.doFinal(salt);
                SecretKeySpec spec = new SecretKeySpec(encrypted, ALGORITHM);
                SecretKeyFactory factory = SecretKeyFactory.getInstance(ALGORITHM);
                cipher.init(opmode, (Key)factory.generateSecret(spec), new IvParameterSpec(IV));
                return cipher;
            }
            catch (Exception e) {
                return null;
            }
        }
        catch (NoClassDefFoundError err) {
            throw new BaseSecurityException("security_0012", err);
        }
    }

    public KeyStore getKeyStore(String component) throws KeyStoreException {
        KeyStore store = null;
        try {
            store = KeyStore.getInstance("EBSDKS");
            store.load(null, null);
        }
        catch (Exception e) {
            throw new BaseKeyStoreException("security_0013", e);
        }
        return store;
    }

    public MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(DIGEST);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }
}

