/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.crypt;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.exceptions.StorageException;
import com.sap.engine.services.security.server.ModificationContextImpl;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptographyLock {
    private static final byte[] IV = new byte[8];
    private static final String ALGORITHM = "DES";
    private static final String CIPHER = "DES/CBC/PKCS5Padding";
    private static final String CONFIGURATION_ENTRY_VERIFICATION = "verification_string";
    private static final String CONFIGURATION_ENTRY_MASTER = "master_key";
    private static final String DIGEST = "MD5";
    private static final String VERIFY_STRING = "verification_string";
    private boolean isLocked = true;
    private Key masterKey = null;
    private SecurityContext root = null;

    public CryptographyLock(SecurityContext root) {
        this.root = root;
        ModificationContextImpl mc = (ModificationContextImpl)root.getModificationContext();
        mc.beginModifications();
        try {
            Configuration configuration = null;
            try {
                configuration = mc.getConfiguration("security/securestore", false, false);
                this.isLocked = configuration != null;
            }
            catch (Exception e) {
                this.isLocked = false;
            }
            if (!this.isLocked) {
                mc.getConfiguration("security/securestore", true, true);
            }
            mc.commitModifications();
        }
        catch (StorageException se) {
            mc.rollbackModifications();
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public synchronized void lock(char[] password) {
        try {
            if (this.isLocked) {
                throw new BaseSecurityException("security_0002");
            }
            this.changeLockData(password);
        }
        catch (Exception e) {
            throw new BaseSecurityException("security_0003", e);
        }
        catch (NoClassDefFoundError err) {
            throw new BaseSecurityException("security_0004", err);
        }
    }

    public synchronized void unlock(char[] password) throws SecurityException {
        try {
            if (!this.isLocked) {
                return;
            }
            byte[] verification = null;
            byte[] rawkey = null;
            Configuration container = null;
            ModificationContextImpl mc = (ModificationContextImpl)this.root.getModificationContext();
            mc.beginModifications();
            try {
                container = mc.getConfiguration("security/securestore", false, false);
                verification = this.loadVerificationArray(container);
                rawkey = this.loadMasterKey(container);
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                mc.commitModifications();
                throw throwable;
            }
            mc.commitModifications();
            if (rawkey == null) {
                this.generateMasterKey();
                this.changeLockData(password);
            } else {
                try {
                    this.getLockData(password, rawkey, verification);
                }
                catch (Exception e) {
                    throw new BaseSecurityException("security_0005", e);
                }
            }
            this.isLocked = false;
        }
        catch (SecurityException se) {
            throw new BaseSecurityException("security_0006", se);
        }
        catch (Exception e) {
            throw new BaseSecurityException("security_0007", e);
        }
        catch (NoClassDefFoundError err) {
            throw new BaseSecurityException("security_0008", err);
        }
    }

    Key getMasterKey() {
        return this.masterKey;
    }

    private void generateMasterKey() throws Exception {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = random.generateSeed(8);
        SecretKeySpec spec = new SecretKeySpec(salt, ALGORITHM);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(ALGORITHM);
        this.masterKey = factory.generateSecret(spec);
    }

    private void getLockData(char[] password, byte[] rawkey, byte[] verification) throws Exception {
        byte[] salt = MessageDigest.getInstance(DIGEST).digest(new String(password).getBytes());
        SecretKeySpec spec = new SecretKeySpec(salt, ALGORITHM);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(ALGORITHM);
        Cipher cipher = Cipher.getInstance(CIPHER);
        cipher.init(2, (Key)factory.generateSecret(spec), new IvParameterSpec(IV));
        if (verification == null) {
            throw new BaseSecurityException("security_0009");
        }
        if (!"verification_string".equals(new String(cipher.doFinal(verification)))) {
            throw new BaseSecurityException("security_0010");
        }
        cipher = Cipher.getInstance(CIPHER);
        cipher.init(2, (Key)factory.generateSecret(spec), new IvParameterSpec(IV));
        byte[] decrypted = cipher.doFinal(rawkey);
        spec = new SecretKeySpec(decrypted, ALGORITHM);
        this.masterKey = factory.generateSecret(spec);
    }

    private void changeLockData(char[] password) throws Exception {
        byte[] salt = MessageDigest.getInstance(DIGEST).digest(new String(password).getBytes());
        SecretKeySpec spec = new SecretKeySpec(salt, ALGORITHM);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(ALGORITHM);
        SecretKey adminKey = factory.generateSecret(spec);
        Cipher cipher = Cipher.getInstance(CIPHER);
        cipher.init(1, (Key)adminKey, new IvParameterSpec(IV));
        byte[] encrypted = cipher.doFinal(this.masterKey.getEncoded());
        cipher = Cipher.getInstance(CIPHER);
        cipher.init(1, (Key)adminKey, new IvParameterSpec(IV));
        byte[] verificationArray = cipher.doFinal("verification_string".getBytes());
        ModificationContextImpl mc = (ModificationContextImpl)this.root.getModificationContext();
        try {
            Configuration container = mc.getConfiguration("security/securestore", false, false);
            this.storeMasterKey(container, encrypted);
            this.storeVerificationArray(container, verificationArray);
            mc.commitModifications();
        }
        catch (Exception e) {
            mc.rollbackModifications();
            throw e;
        }
    }

    private byte[] loadMasterKey(Configuration container) {
        try {
            return (byte[])container.getConfigEntry(CONFIGURATION_ENTRY_MASTER);
        }
        catch (Exception e) {
            return null;
        }
    }

    private byte[] loadVerificationArray(Configuration container) {
        try {
            return (byte[])container.getConfigEntry("verification_string");
        }
        catch (Exception e) {
            return null;
        }
    }

    private void storeMasterKey(Configuration container, byte[] encrypted) throws Exception {
        try {
            container.addConfigEntry(CONFIGURATION_ENTRY_MASTER, encrypted);
        }
        catch (Exception e) {
            container.modifyConfigEntry(CONFIGURATION_ENTRY_MASTER, encrypted);
        }
    }

    private void storeVerificationArray(Configuration container, byte[] array) throws Exception {
        try {
            container.addConfigEntry("verification_string", array);
        }
        catch (Exception e) {
            container.modifyConfigEntry("verification_string", array);
        }
    }
}

