/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.ServerInternalLocking;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.log.Logger;
import com.sap.engine.interfaces.security.auth.AbstractLoginModule;
import com.sap.engine.interfaces.security.auth.RemoteLoginContextFactory;
import com.sap.engine.interfaces.security.userstore.UserStore;
import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.ContainerEventListenerImpl;
import com.sap.engine.services.security.DebugSecurityLogger;
import com.sap.engine.services.security.cluster.SecurityMessenger;
import com.sap.engine.services.security.exceptions.SecurityResourceAccessor;
import com.sap.engine.services.security.exceptions.SecurityServiceException;
import com.sap.engine.services.security.gui.userstore.stores.RuntimeLoginModuleConfiguration;
import com.sap.engine.services.security.gui.userstore.stores.RuntimeUserStoreConfiguration;
import com.sap.engine.services.security.login.LoginContextConfiguration;
import com.sap.engine.services.security.login.SecurityContext;
import com.sap.engine.services.security.login.SecurityReferenceImpl;
import com.sap.engine.services.security.patch.ChangeDaemon;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.restriction.Restrictions;
import com.sap.engine.services.security.server.AuthenticationContextImpl;
import com.sap.engine.services.security.server.SecurityContextImpl;
import com.sap.engine.services.security.server.storage.HandlerPool;
import com.sap.engine.services.security.server.storage.StartupStorage;
import com.sap.engine.services.security.server.storage.Storage;
import com.sap.engine.system.SystemLoginConfiguration;
import com.sap.engine.system.SystemSubjectDomainCombiner;
import com.sap.engine.system.SystemURLStreamHandlerFactory;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import iaik.security.provider.IAIK;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class SecurityServerFrame
implements ApplicationServiceFrame {
    private static Properties properties = null;
    public static ApplicationServiceContext context = null;
    public static ThreadSystem threadContext = null;
    public static LockingContext lockingContext = null;
    public static ServerInternalLocking internalLock = null;
    private SecurityReferenceImpl secRef = null;
    public static SecurityServerFrame frame = null;
    private static Logger logger = null;
    public static SystemMonitor systemMonitor = null;
    private static com.sap.engine.interfaces.security.SecurityContext securityImpl = null;
    public static int currentParticipant = -1;
    public static final String SECURITY_CATEGORY = "/System/Security";
    public static final String SECURITY_LOCATION = "com.sap.engine.services.security";
    private static RemoteSecurity remoteSecurity = null;
    private static boolean emergencyMode = false;
    LoginContextConfiguration defaultConfiguration = null;
    static /* synthetic */ Class class$com$sap$engine$system$SystemLoginConfiguration;
    static /* synthetic */ Class class$iaik$security$provider$IAIK;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        frame = this;
        currentParticipant = serviceContext.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
        properties = serviceContext.getServiceState().getProperties();
        context = serviceContext;
        threadContext = serviceContext.getCoreContext().getThreadSystem();
        systemMonitor = serviceContext.getContainerContext().getSystemMonitor();
        new SecurityResourceAccessor().init(Category.getCategory((String)SECURITY_CATEGORY), Location.getLocation((String)SECURITY_LOCATION));
        MessageContext messageContext = serviceContext.getClusterContext().getMessageContext();
        messageContext.registerListener((MessageListener)new SecurityMessenger(serviceContext));
        lockingContext = serviceContext.getCoreContext().getLockingContext();
        HandlerPool.setFactory((ConfigurationHandlerFactory)serviceContext.getCoreContext().getConfigurationHandlerFactory());
        try {
            internalLock = lockingContext.createServerInternalLocking("$service.security", "Global Synchronization For Security Service");
        }
        catch (TechnicalLockException tle) {
            SecurityServiceException sse = new SecurityServiceException("security_0001", (Throwable)((Object)tle));
            sse.log();
            throw sse;
        }
        this.lock();
        boolean lock = true;
        try {
            try {
                this.registerIAIKProvider();
                SecurityContext threadContextObject = null;
                ChangeDaemon changeDaemon = new ChangeDaemon((ServiceContext)serviceContext);
                if (changeDaemon.init() && !changeDaemon.run()) {
                    this.releaseLock();
                    lock = false;
                }
                ((StartupStorage)Storage.getStorage(null)).globalBegin(lock);
                securityImpl = new SecurityContextImpl((ServiceContext)serviceContext);
                this.initializeLoginConfiguration(securityImpl);
                UserStore userStore = securityImpl.getUserStoreContext().getActiveUserStore();
                SecurityContext.setAnonymousPrincipal(userStore);
                threadContextObject = new SecurityContext(AuthenticationContextImpl.getSessionPool());
                serviceContext.getCoreContext().getThreadSystem().registerContextObject("security", threadContextObject);
                SecurityServerFrame.updateEmergencyModeFlag();
                Restrictions.setUpRestrictions((ThreadSystem)serviceContext.getCoreContext().getThreadSystem());
                ContainerEventListenerImpl clistener = new ContainerEventListenerImpl(this, securityImpl, serviceContext.getContainerContext().getObjectRegistry());
                int mask = 228;
                HashSet<String> names = new HashSet<String>(5);
                names.add("naming");
                names.add("keystore");
                names.add("shell");
                names.add("cross");
                names.add("log");
                serviceContext.getServiceState().registerContainerEventListener(mask, names, clistener);
                serviceContext.getServiceState().registerManagementInterface(clistener.getRemoteSecurity());
                remoteSecurity = clistener.getRemoteSecurity();
                this.secRef = new SecurityReferenceImpl(AuthenticationContextImpl.getSessionPool());
                SystemSubjectDomainCombiner.useSecurityReference(this.secRef);
                ((StartupStorage)Storage.getStorage(null)).globalCommit();
                this.addAssertionTicketAuthenticationTemplate();
                serviceContext.getContainerContext().getObjectRegistry().registerInterface(securityImpl);
                serviceContext.getContainerContext().getObjectRegistry().registerInterfaceProvider("security", securityImpl);
            }
            catch (ServiceException se) {
                ((StartupStorage)Storage.getStorage(null)).globalRollback();
                SecurityServiceException sse = new SecurityServiceException("security_0000", (Throwable)((Object)se));
                sse.log();
                throw sse;
            }
            catch (Throwable e) {
                ((StartupStorage)Storage.getStorage(null)).globalRollback();
                SecurityServiceException sse = new SecurityServiceException("security_0001", e);
                sse.log();
                throw sse;
            }
            Object var11_16 = null;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            try {
                if (!lock) throw throwable;
                this.releaseLock();
                throw throwable;
            }
            catch (TechnicalLockException tle) {
                throw new SecurityServiceException("security_0001", (Throwable)((Object)tle));
            }
        }
        try {}
        catch (TechnicalLockException tle) {
            throw new SecurityServiceException("security_0001", (Throwable)((Object)tle));
        }
        if (!lock) return;
        this.releaseLock();
    }

    public static RemoteSecurity getManagementContext() {
        return remoteSecurity;
    }

    public static com.sap.engine.interfaces.security.SecurityContext getSecurityContext() {
        return securityImpl;
    }

    public static ApplicationServiceContext getServiceContext() {
        return context;
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = new DebugSecurityLogger();
        }
        return logger;
    }

    public static Properties getServiceProperties() {
        return properties;
    }

    public static boolean isEmergencyMode() {
        return emergencyMode;
    }

    public static void updateEmergencyModeFlag() {
        emergencyMode = securityImpl.getUserStoreContext().getActiveUserStore().getUserContext().isInEmergencyMode();
    }

    public void stop() {
        frame = null;
        threadContext = null;
        context = null;
        systemMonitor = null;
        AbstractLoginModule.setLoginModuleHelper(null);
        RemoteLoginContextFactory.setRemoteLoginContextFactory(null);
    }

    protected void setServiceProperties(Properties serviceProperties) {
        properties = serviceProperties;
    }

    private void lock() throws SecurityServiceException {
        long waitLimit = 1800000L;
        long waitInterval = 1000L;
        long beginTime = System.currentTimeMillis();
        try {
            waitLimit = new Long(properties.getProperty("ServiceStartupLockTimeLimit", "" + waitLimit));
        }
        catch (Exception e) {
            SecurityServerFrame.getLogger().log((byte)2, "Unable to get value of \"ServiceStartupLockTimeLimit\" property! " + e.getMessage());
        }
        try {
            waitInterval = new Long(properties.getProperty("ServiceStartupLockAttemptsInterval", "" + waitInterval));
        }
        catch (Exception e) {
            SecurityServerFrame.getLogger().log((byte)2, "Unable to get value of \"ServiceStartupLockAttemptsInterval\" property! " + e.getMessage());
        }
        while (System.currentTimeMillis() <= beginTime + waitLimit) {
            try {
                internalLock.lock("$service.security", "", 'X');
                return;
            }
            catch (Exception e) {
                SecurityServerFrame securityServerFrame = this;
                synchronized (securityServerFrame) {
                    try {
                        this.wait(waitInterval);
                    }
                    catch (InterruptedException ex) {
                        throw new SecurityServiceException("security_5021", (Throwable)ex);
                    }
                }
            }
        }
        throw new SecurityServiceException("security_5021");
    }

    private void releaseLock() throws TechnicalLockException {
        internalLock.unlock("$service.security", "", 'X');
    }

    private void initializeLoginConfiguration(com.sap.engine.interfaces.security.SecurityContext root) {
        try {
            Configuration.getConfiguration().refresh();
        }
        catch (Exception e) {
            try {
                String filename = ((SecurityContextImpl)root).getEnvironment().getServiceState().getWorkingDirectoryName() + File.separator + "fallback.config";
                FileOutputStream fos = new FileOutputStream(filename);
                fos.write("other{};".getBytes());
                fos.close();
                Security.setProperty("policy.allowSystemProperty", "true");
                System.setProperty("java.security.auth.login.config", filename);
            }
            catch (Exception ee) {
                SecurityServerFrame.getLogger().logThrowable((byte)3, ee);
            }
        }
        try {
            Configuration.getConfiguration().refresh();
        }
        catch (Exception e) {
            SecurityServerFrame.getLogger().log((byte)4, "Default JAAS configuration was not accepted. " + e);
        }
        this.defaultConfiguration = new LoginContextConfiguration(root);
        try {
            Security.setProperty("login.configuration.provider", (class$com$sap$engine$system$SystemLoginConfiguration == null ? (class$com$sap$engine$system$SystemLoginConfiguration = SecurityServerFrame.class$("com.sap.engine.system.SystemLoginConfiguration")) : class$com$sap$engine$system$SystemLoginConfiguration).getName());
            SystemLoginConfiguration.useConfiguration(this.defaultConfiguration);
        }
        catch (Exception e) {
            SecurityServerFrame.getLogger().logThrowable((byte)4, e);
        }
        Configuration.setConfiguration(this.defaultConfiguration);
    }

    private void registerIAIKProvider() {
        try {
            Provider[] provider = Security.getProviders();
            if (provider.length == 0 || !provider[0].getClass().getName().equals((class$iaik$security$provider$IAIK == null ? (class$iaik$security$provider$IAIK = SecurityServerFrame.class$("iaik.security.provider.IAIK")) : class$iaik$security$provider$IAIK).getName())) {
                IAIK iaik = new IAIK();
                Security.removeProvider(iaik.getName());
                IAIK.addAsJDK14Provider();
                SecurityServerFrame.getLogger().log((byte)2, "IAIK.addAsJDK14Provider() OK");
            }
        }
        catch (Throwable e) {
            SecurityServerFrame.getLogger().log((byte)4, "Unable to set up IAIK cryptography provider!");
            SecurityServerFrame.getLogger().logThrowable((byte)4, e);
        }
        try {
            SystemURLStreamHandlerFactory urlStreamHandlerFactory = new SystemURLStreamHandlerFactory();
            urlStreamHandlerFactory.registerClassLoader(this.getClass().getClassLoader());
            urlStreamHandlerFactory.registerHandlerPackage("iaik.protocol");
            URL.setURLStreamHandlerFactory(urlStreamHandlerFactory);
        }
        catch (Exception e) {
            SecurityServerFrame.getLogger().log((byte)4, "Unable to set up IAIK URL stream handler!");
            SecurityServerFrame.getLogger().logThrowable((byte)4, e);
        }
        catch (Error e) {
            SecurityServerFrame.getLogger().log((byte)4, "Unable to set up IAIK URL stream handler!");
            SecurityServerFrame.getLogger().log((byte)4, e.getMessage());
            SecurityServerFrame.getLogger().logThrowable((byte)4, e);
        }
    }

    private void addAssertionTicketAuthenticationTemplate() {
        com.sap.engine.interfaces.security.SecurityContext assertionTicketContext = securityImpl.getPolicyConfigurationContext("evaluate_assertion_ticket");
        if (assertionTicketContext == null) {
            String loginModuleClassName = "com.sap.security.core.server.jaas.EvaluateAssertionTicketLoginModule";
            UserStoreConfiguration oldConfig = securityImpl.getUserStoreContext().getActiveUserStore().getConfiguration();
            LoginModuleConfiguration[] oldModules = oldConfig.getLoginModules();
            LoginModuleConfiguration[] newModules = new LoginModuleConfiguration[oldModules.length + 1];
            System.arraycopy(oldModules, 0, newModules, 0, oldModules.length);
            newModules[oldModules.length] = new RuntimeLoginModuleConfiguration("EvaluateAssertionTicketLoginModule", "This login module verifys SAP Authentication Assertion tickets.", loginModuleClassName, new Hashtable(), new String[0], new String[0], null);
            RuntimeUserStoreConfiguration config = new RuntimeUserStoreConfiguration(oldConfig);
            config.setLoginModules(newModules);
            securityImpl.getUserStoreContext().updateUserStore(config, this.getClass().getClassLoader());
            securityImpl.registerPolicyConfiguration("evaluate_assertion_ticket");
            assertionTicketContext = securityImpl.getPolicyConfigurationContext("evaluate_assertion_ticket");
            AppConfigurationEntry[] modules = new AppConfigurationEntry[]{new AppConfigurationEntry(loginModuleClassName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new Hashtable())};
            assertionTicketContext.getAuthenticationContext().setLoginModules(modules);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

