/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.log.LogRecord;
import com.sap.engine.interfaces.log.Logger;
import com.sap.engine.services.security.exceptions.SecurityResourceAccessor;
import java.util.Properties;

public class DebugSecurityLogger
implements Logger {
    private static boolean category_location = false;

    public static void useCategory_Location(boolean flag) {
        category_location = flag && SecurityResourceAccessor.category != null;
    }

    public String getName() {
        return "security";
    }

    public boolean setLoggingProperty(String key, String value) {
        return false;
    }

    public String getLoggingProperty(String key) {
        return null;
    }

    public Properties getLoggingProperties() {
        return new Properties();
    }

    public boolean isLogAvailable() {
        return category_location;
    }

    public void log(byte level, String message) {
        SecurityResourceAccessor.category.logT(this.severityConverter(level), SecurityResourceAccessor.location, message);
    }

    public void log(byte level, String message, Object[] args) {
        SecurityResourceAccessor.category.logT(this.severityConverter(level), SecurityResourceAccessor.location, message, args);
    }

    public void log(byte level, byte[] message) {
        SecurityResourceAccessor.category.logT(this.severityConverter(level), SecurityResourceAccessor.location, new String(message));
    }

    public void log(byte level, byte[] message, int off, int len) {
        SecurityResourceAccessor.category.logT(this.severityConverter(level), SecurityResourceAccessor.location, new String(message, off, len));
    }

    public void log(byte level, String message, String user, String clientIp) {
        SecurityResourceAccessor.category.logT(this.severityConverter(level), SecurityResourceAccessor.location, message);
    }

    public void log(byte level, byte[] message, String user, String clientIp) {
        SecurityResourceAccessor.category.logT(this.severityConverter(level), SecurityResourceAccessor.location, new String(message));
    }

    public void log(byte level, byte[] message, byte[] user, byte[] clientIp) {
        SecurityResourceAccessor.category.logT(this.severityConverter(level), SecurityResourceAccessor.location, new String(message));
    }

    public void log(byte level, byte[] message, int off, int len, byte[] user, byte[] clientIp) {
        SecurityResourceAccessor.category.logT(this.severityConverter(level), SecurityResourceAccessor.location, new String(message, off, len));
    }

    public void logThrowable(byte level, Throwable t) {
        if (category_location) {
            String message = t.getLocalizedMessage();
            if (message != null) {
                SecurityResourceAccessor.category.logT((int)level, SecurityResourceAccessor.location, message);
            }
            if (SecurityResourceAccessor.location != null) {
                SecurityResourceAccessor.location.catching(t);
            }
        } else if (SystemProperties.getBoolean("debug")) {
            System.err.println(" [security] " + t);
            t.printStackTrace();
        }
    }

    public void logThrowable(byte level, Throwable t, String user, String clientIp) {
        if (category_location) {
            String message = t.getLocalizedMessage();
            if (message != null) {
                SecurityResourceAccessor.category.logT((int)level, SecurityResourceAccessor.location, message);
            }
            if (SecurityResourceAccessor.location != null) {
                SecurityResourceAccessor.location.catching(t);
            }
        } else if (SystemProperties.getBoolean("debug")) {
            System.err.println(" [security] " + t);
            t.printStackTrace();
        }
    }

    public void log(LogRecord record) {
        if (SystemProperties.getBoolean("debug")) {
            System.err.println(" [security] " + record);
        }
    }

    public boolean flush() {
        return true;
    }

    private int severityConverter(byte logLevel) {
        switch (logLevel) {
            case 0: {
                return 100;
            }
            case 1: {
                return 200;
            }
            case 2: {
                return 300;
            }
            case 3: {
                return 300;
            }
            case 4: {
                return 400;
            }
            case 5: {
                return 500;
            }
            case 6: {
                return 600;
            }
            case 7: {
                return 600;
            }
            case 8: {
                return 600;
            }
        }
        return 701;
    }
}

