/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.server.command;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.rmi_p4.Call;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;

public class ListCallsInfo
implements Command {
    private String formatResult() {
        String result = "                    .:: P4 CALLS INFO ::.  \n";
        Enumeration calls = Call.getAllCalls();
        result = result + "On this server has calls : " + calls.hasMoreElements() + "\n\n";
        if (calls != null) {
            try {
                result = result + "=============================================================================\n";
                while (calls.hasMoreElements()) {
                    Call o = (Call)calls.nextElement();
                    result = result + " -> Call instance : <" + o + "> \n";
                    result = result + "      |- Stub ID        : <" + o.stub + ">\n";
                    result = result + "      |- server ID      : " + o.stub.p4_getInfo().server_id + "\n";
                    result = result + "      |- client ID      : " + o.stub.p4_getInfo().client_id + "\n";
                    result = result + "      |- call ID        : " + o.getCall_id() + "\n";
                    result = result + "      |- connectionType : " + o.stub.connectionType + "\n";
                    result = result + "      |- isLocal        : " + o.stub.isLocal + "\n";
                    result = result + "      |- classLoader    : <" + o.stub.p4_getClassLoader() + ">\n";
                    result = result + "-----------------------------------------------------------------------------\n";
                }
            }
            catch (Throwable e) {
                result = result + "there is a exception : " + e + "\n\n";
            }
        }
        return result;
    }

    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        PrintWriter pw = new PrintWriter(output, true);
        if (params.length > 0) {
            pw.println(this.getHelpMessage());
        } else {
            try {
                pw.println(this.formatResult());
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                ByteArrayOutputStream ostr = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(ostr));
                pw.println("ERROR: " + ostr);
                pw.println(this.getHelpMessage());
            }
        }
    }

    public String getName() {
        return "p4_calls";
    }

    public String getGroup() {
        return "p4";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        String nl = SystemProperties.getProperty("line.separator");
        return "Lists all p4 calls with the corresponding infos. " + nl + "Usage: " + this.getName();
    }
}

