/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.session.ApplicationSessionContext;
import com.sap.engine.frame.cluster.session.ApplicationSessionProcessor;
import com.sap.engine.frame.cluster.session.CommunicationConnection;
import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.frame.core.thread.ContextObject;
import com.sap.engine.frame.core.thread.ContextObjectNameIterator;
import com.sap.engine.frame.core.thread.Transferable;
import com.sap.engine.frame.core.thread.TransferableExt;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.ContextObjectClassReceiverImpl;
import com.sap.engine.services.rmi_p4.Message;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import com.sap.engine.services.rmi_p4.Repliable;
import com.sap.engine.services.rmi_p4.StubBaseInfo;
import com.sap.engine.services.rmi_p4.all.ConnectionProfile;
import com.sap.engine.services.rmi_p4.exception.P4BaseIOException;
import com.sap.engine.services.rmi_p4.server.ClusterOrganizer;
import com.sap.engine.services.rmi_p4.server.GarbageCollectorServerImpl;
import com.sap.engine.services.rmi_p4.server.Messenger;
import com.sap.engine.services.rmi_p4.server.ServerDispatchImpl;
import java.rmi.Remote;

public class P4SessionProcessor
implements ApplicationSessionProcessor,
Repliable {
    public static P4SessionProcessor thisProcessor = null;
    public P4ObjectBroker broker;
    public ApplicationServiceContext serviceContext;
    public ApplicationSessionContext sessionContext;
    public CommunicationConnection communicationConnection;
    public ClusterOrganizer organizer;
    protected Messenger mess;
    protected int currentServerId;
    protected byte[] currentId = new byte[4];
    private boolean isReady = false;
    private long requestCount = 0L;
    private long errorRequestCount = 0L;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor;

    protected static P4SessionProcessor getSessionProcessor() {
        try {
            while (thisProcessor == null) {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e) {
            return thisProcessor;
        }
        return thisProcessor;
    }

    public P4SessionProcessor(ApplicationServiceContext _baseContext) {
        thisProcessor = this;
        this.serviceContext = _baseContext;
        this.sessionContext = _baseContext.getClusterContext().getApplicationSessionContext();
        this.communicationConnection = this.sessionContext.getConnection();
        this.currentServerId = _baseContext.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
        Convert.writeIntToByteArr(this.currentId, 0, this.currentServerId);
        this.organizer = new ClusterOrganizer(_baseContext.getClusterContext().getMessageContext(), _baseContext);
        this.mess = new Messenger(this, this.organizer);
        this.isReady = true;
        this.broker = P4ObjectBroker.init();
        try {
            this.broker.setInitialObject("cocr", new ContextObjectClassReceiverImpl());
        }
        catch (Exception ex) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor == null ? (class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor = P4SessionProcessor.class$("com.sap.engine.services.rmi_p4.server.P4SessionProcessor")) : class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor, ex, "CONSTRUCTOR", 100);
        }
        P4SessionProcessor p4SessionProcessor = this;
        synchronized (p4SessionProcessor) {
            this.notifyAll();
        }
    }

    public int getServerId() {
        return this.currentServerId;
    }

    public synchronized void isReady() {
        while (!this.isReady) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public ConnectionProfile[] getConnectionProfiles() {
        return this.organizer.getAllProfiles();
    }

    public void request(int dispatcher_id, int client_id, byte[] request, int offset, int length) {
        Message msg = null;
        byte[] req = new byte[length];
        System.arraycopy(request, offset, req, 0, length);
        msg = new Message(Convert.byteArrToInt(req, 10), dispatcher_id, client_id, req, length);
        ServerDispatchImpl sdisp = new ServerDispatchImpl(msg, P4ObjectBroker.init(), thisProcessor, thisProcessor);
        sdisp._run();
        if (msg.type == 0) {
            if (sdisp.isCallOK()) {
                ++this.requestCount;
            } else {
                ++this.errorRequestCount;
            }
        }
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public long getErrorRequestCount() {
        return this.errorRequestCount;
    }

    public void getRequestPart(int communicationContainerId, int connectionId) {
    }

    public void reply(int server_id, int client_id, byte[] reply) throws P4IOException {
        block8: {
            if (!this.checkConnection(client_id)) {
                throw (P4IOException)this.broker.getException(0, P4BaseIOException.Ilegal_client_ID, null);
            }
            try {
                byte[] tosend = reply;
                if (client_id == -1) {
                    try {
                        this.communicationConnection.send(Math.abs(server_id), client_id, tosend, 0, tosend.length);
                        break block8;
                    }
                    catch (ClusterException e) {
                        this.broker.trace(class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor == null ? (class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor = P4SessionProcessor.class$("com.sap.engine.services.rmi_p4.server.P4SessionProcessor")) : class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor, (Exception)((Object)e), "011168", "reply", 100);
                        throw (P4IOException)this.broker.getException(0, P4BaseIOException.Couldnt_send_message, (Throwable)((Object)e));
                    }
                }
                tosend = new byte[reply.length + 4];
                System.arraycopy(this.currentId, 0, tosend, 0, 4);
                System.arraycopy(reply, 0, tosend, 4, reply.length);
                try {
                    this.communicationConnection.send(Math.abs(server_id), client_id, tosend, 0, tosend.length);
                }
                catch (ClusterException e) {
                    this.broker.trace(class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor == null ? (class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor = P4SessionProcessor.class$("com.sap.engine.services.rmi_p4.server.P4SessionProcessor")) : class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor, (Exception)((Object)e), "011169", "reply", 100);
                    throw (P4IOException)this.broker.getException(0, P4BaseIOException.Couldnt_send_message, (Throwable)((Object)e));
                }
            }
            catch (Exception ex) {
                this.broker.trace(class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor == null ? (class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor = P4SessionProcessor.class$("com.sap.engine.services.rmi_p4.server.P4SessionProcessor")) : class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor, ex, "reply", 100);
                throw (P4IOException)this.broker.getException(0, P4BaseIOException.Could_not_make_reply, ex);
            }
        }
    }

    public void reply(int server_id, int client_id, byte[] reply, int size) throws P4IOException {
        byte[] tosend = new byte[size - 8];
        System.arraycopy(reply, 8, tosend, 0, tosend.length);
        this.reply(server_id, client_id, tosend);
    }

    public void reply(int server_id, int sender_id, int client_id, byte[] reply, int size) throws P4IOException {
        if (!this.checkConnection(client_id)) {
            throw (P4IOException)this.broker.getException(0, P4BaseIOException.Ilegal_client_ID, null);
        }
        if (client_id != -1) {
            Convert.writeIntToByteArr(reply, 6, server_id);
            System.arraycopy(this.currentId, 0, reply, 10, 4);
            try {
                this.communicationConnection.send(Math.abs(sender_id), client_id, reply, 0, size);
            }
            catch (ClusterException e) {
                this.broker.trace(class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor == null ? (class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor = P4SessionProcessor.class$("com.sap.engine.services.rmi_p4.server.P4SessionProcessor")) : class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor, (Exception)((Object)e), "011170", "reply", 100);
                throw (P4IOException)this.broker.getException(0, P4BaseIOException.Couldnt_send_message, (Throwable)((Object)e));
            }
            return;
        }
        try {
            this.communicationConnection.send(Math.abs(sender_id), client_id, reply, 0, size);
        }
        catch (ClusterException e) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor == null ? (class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor = P4SessionProcessor.class$("com.sap.engine.services.rmi_p4.server.P4SessionProcessor")) : class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor, (Exception)((Object)e), "011171", "reply", 100);
            throw (P4IOException)this.broker.getException(0, P4BaseIOException.Couldnt_send_message, (Throwable)((Object)e));
        }
    }

    public void reply(Message msg, byte[] reply) throws P4IOException {
        byte[] tosend = null;
        if (!this.checkConnection(msg.client_id)) {
            throw (P4IOException)this.broker.getException(0, P4BaseIOException.Ilegal_client_ID, null);
        }
        if (msg.client_id != -1) {
            tosend = new byte[reply.length + 14];
            Convert.writeIntToByteArr(tosend, 6, msg.sender_id);
            System.arraycopy(this.currentId, 0, tosend, 10, 4);
            System.arraycopy(reply, 0, tosend, 14, reply.length);
            try {
                this.communicationConnection.send(Math.abs(msg.clusterEl_id), msg.client_id, tosend, 0, tosend.length);
            }
            catch (ClusterException e) {
                this.broker.trace(class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor == null ? (class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor = P4SessionProcessor.class$("com.sap.engine.services.rmi_p4.server.P4SessionProcessor")) : class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor, (Exception)((Object)e), "011172", "reply", 100);
                throw (P4IOException)this.broker.getException(0, P4BaseIOException.Couldnt_send_message, (Throwable)((Object)e));
            }
            return;
        }
        this.reply(msg.clusterEl_id, msg.client_id, reply);
    }

    public boolean checkConnection(int _connId) {
        return _connId != 0;
    }

    public void setInitialObject(String initName, Remote initObject) {
        try {
            P4RemoteObject toSet = this.broker.loadObject(initObject);
            this.broker.setInitialObject(initName, toSet);
        }
        catch (Exception ex) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor == null ? (class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor = P4SessionProcessor.class$("com.sap.engine.services.rmi_p4.server.P4SessionProcessor")) : class$com$sap$engine$services$rmi_p4$server$P4SessionProcessor, ex, "011172", "setInitialObject", 100);
        }
    }

    public void getConnectionFrom(String _connType, String _host, int _port, StubBaseInfo _info) throws P4IOException {
        this.organizer.prepareConnection(_connType, _host, _port, _info);
    }

    public int[] getConnection(String _connType, String _host, int _port) throws P4IOException {
        return this.organizer.getConnection(_connType, _host, _port);
    }

    protected ApplicationServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public int getTCSize() {
        int tcSize = 0;
        int byteArrLen = 0;
        P4ObjectBroker p4 = P4ObjectBroker.getBroker();
        ClientThreadContext ctc = p4.getCTC();
        if (ctc == null) {
            return 0;
        }
        ContextObjectNameIterator coIt = ctc.getTransferableContextObjectNames();
        tcSize += 2;
        while (coIt.hasNext()) {
            String name = coIt.nextName();
            tcSize += 2;
            tcSize += name.length();
            tcSize += 2;
            ContextObject co = ctc.getContextObject(name);
            byteArrLen = ((Transferable)((Object)co)).size();
            tcSize += byteArrLen;
        }
        return tcSize;
    }

    public int getTCSize(int own_broker_id) {
        int tcSize = 0;
        int byteArrLen = 0;
        P4ObjectBroker p4 = P4ObjectBroker.init();
        ClientThreadContext ctc = p4.getCTC();
        try {
            ContextObjectNameIterator coIt = ctc.getTransferableContextObjectNames();
            while (coIt.hasNext()) {
                String n = coIt.nextName();
                ContextObject co = ctc.getContextObject(n);
                byteArrLen = n.equals("security") && co instanceof TransferableExt ? ((TransferableExt)((Object)co)).size(new Integer(own_broker_id)) : ((Transferable)((Object)co)).size();
                tcSize = tcSize + 2 + n.length();
                tcSize = tcSize + 2 + byteArrLen;
            }
        }
        catch (Exception ex) {
            return tcSize;
        }
        return tcSize += 2;
    }

    public String getUnderlyingProfile() {
        return null;
    }

    protected void stop() {
        this.organizer.unregister();
        thisProcessor = null;
        GarbageCollectorServerImpl._this = null;
        this.broker.close();
    }

    public Repliable getMessenger() {
        return this.mess;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

