/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.server;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.interfaces.connector.ComponentExecutionContext;
import com.sap.engine.interfaces.cross.Redirectable;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.InitialCall;
import com.sap.engine.services.rmi_p4.InitializingException;
import com.sap.engine.services.rmi_p4.LocalDispatch;
import com.sap.engine.services.rmi_p4.Message;
import com.sap.engine.services.rmi_p4.NoSuchObjectException;
import com.sap.engine.services.rmi_p4.P4DynamicSkeleton;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import com.sap.engine.services.rmi_p4.P4RemoteObjectInfo;
import com.sap.engine.services.rmi_p4.RemoteObjectInfo;
import com.sap.engine.services.rmi_p4.RemoteRef;
import com.sap.engine.services.rmi_p4.Repliable;
import com.sap.engine.services.rmi_p4.StubBaseInfo;
import com.sap.engine.services.rmi_p4.StubImpl;
import com.sap.engine.services.rmi_p4.all.ConnectionProfile;
import com.sap.engine.services.rmi_p4.exception.P4BaseConnectionException;
import com.sap.engine.services.rmi_p4.exception.P4BaseIOException;
import com.sap.engine.services.rmi_p4.exception.P4BaseMarshalException;
import com.sap.engine.services.rmi_p4.exception.P4BaseParseRequestException;
import com.sap.engine.services.rmi_p4.exception.P4BaseRuntimeException;
import com.sap.engine.services.rmi_p4.log.P4Logger;
import com.sap.engine.services.rmi_p4.monitor.ConnectionObject;
import com.sap.engine.services.rmi_p4.reflect.LocalInvocationHandler;
import com.sap.engine.services.rmi_p4.server.GarbageCollectorServerImpl;
import com.sap.engine.services.rmi_p4.server.P4ReferenceProxy;
import com.sap.engine.services.rmi_p4.server.P4Schema;
import com.sap.engine.services.rmi_p4.server.P4ServerObjectInfo;
import com.sap.engine.services.rmi_p4.server.P4ServiceFrame;
import com.sap.engine.services.rmi_p4.server.P4SessionProcessor;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;

public class P4ObjectBrokerServerImpl
extends P4ObjectBroker {
    public static final String EJBLOADER = "com.sap.engine.services.ejb.deploy.EJBLoader";
    public static final String APPLOADER = "com.sap.engine.services.deploy.server.ApplicationLoader";
    public static final String ALIAS = "@download@";
    public static final String DOWNLOAD_SERVICE_DIRS = "Bin Directory";
    public static final String DOWNLOAD_APPS_DIRS = "Applications Directory";
    public static final String HTTP_PREFIX = "http://";
    public static final String APPDIR = "apps";
    public static final String BINDIR = "bin";
    public static final String APP_DIR_SEP = File.separator + "apps" + File.separator;
    public static final String BIN_DIR_SEP = File.separator + "bin" + File.separator;
    public static final String APP_ALIAS_SEP = "@download@" + File.separator + "apps".toUpperCase() + File.separator;
    public static final String BIN_ALIAS_SEP = "@download@" + File.separator + "bin".toUpperCase() + File.separator;
    public int thisServerId;
    public P4SessionProcessor sessionProcessor;
    private Hashtable portableRemoteObjects = new Hashtable(256);
    private ConfigurationHandler handler = null;
    private ComponentExecutionContext cec = null;
    public static final String SLEEP_FOR_NEW_WRITE_BROKERID = "SLEEP_FOR_WRITE_BROKERID";
    public static final String TRIES_TO_WRITE_BROKERID = "TRIES_TO_WRITE_BROKERID";
    public static String p4_Persistent = "P4_Persistent";
    private static final String p4_Entity = "P4_PersistentObject";
    protected String[] http = null;
    private static final long DEFAULT_SLEEP_FOR_READ = 2000L;
    private static final int DEFALUT_TRIES_FOR_READ = 8;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$RemoteRef;

    public void close() {
        P4ObjectBroker.transportType = "None";
        this.impls.clear();
        this.initObjects.clear();
        P4ObjectBroker.broker = null;
    }

    public P4RemoteObjectInfo getObjectInfo() {
        return new P4ServerObjectInfo();
    }

    public Object resolveInitialReference(String name, String host, int port) throws Exception {
        return this.resolveInitialReference("None", name, host, port, 0);
    }

    public Object resolveInitialReference(String connectionType, String name, String host, int port) throws Exception {
        return this.resolveInitialReference(connectionType, name, host, port, 0);
    }

    public Object resolveInitialReference(String connectionType, String name, String host, int port, int destServerId) throws Exception {
        int headerSize = 14;
        int nameLength = name.length();
        InitialCall call = InitialCall.getInitialCall();
        byte[] message = new byte[headerSize + 8 + 1 + 2 * nameLength];
        Convert.writeIntToByteArr(message, 6, destServerId);
        call.writeId(message, headerSize);
        message[headerSize + 8] = 10;
        Convert.writeUStringToByteArr(message, headerSize + 8 + 1, name);
        if (host.equals("localhost") || host.equals("127.0.0.1")) {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception unknownHost) {
                try {
                    host = InetAddress.getByName("127.0.0.1").getHostAddress();
                }
                catch (Exception unHost) {
                    this.trace(class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, "Error in getting local host address. " + unHost.getMessage(), "resolveInitialReference", 100);
                }
            }
        }
        if (this.sessionProcessor != null) {
            int[] to = this.sessionProcessor.getConnection(connectionType, host, port);
            call.setClientId(to[1]);
            call.setDispId(to[0]);
            if (to[1] == -1) {
                return this.byteArrayToObject(this.getInitialObject(name));
            }
            this.sessionProcessor.reply(destServerId, to[0], to[1], message, message.length);
            byte[] res = call.getResult(null);
            StubBaseInfo stubInfo = this.byteArrayToObject(res);
            if (destServerId != 0 && destServerId != -1 && stubInfo.server_id != destServerId) {
                throw new RemoteException("Server with id " + destServerId + " doesn't exsist !");
            }
            StringBuffer _id = new StringBuffer(String.valueOf(stubInfo.ownerId));
            _id.append(":");
            _id.append(connectionType);
            _id.append(":");
            _id.append(host);
            _id.append(":");
            _id.append(port);
            String ids = _id.toString();
            stubInfo.setIncomingProfile(ids);
            this.initialProfiles = stubInfo.connectionProfiles;
            return stubInfo;
        }
        this.sessionProcessor = P4SessionProcessor.getSessionProcessor();
        this.thisServerId = this.sessionProcessor.getServerId();
        return null;
    }

    public static String getImplName() {
        return "com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl";
    }

    public void setHttp(String[] http) {
        this.http = http;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Repliable getRepliable(String _connectionType, ConnectionProfile[] _profiles, StubBaseInfo _info) throws P4IOException {
        if (this.sessionProcessor != null) {
            this.sessionProcessor.isReady();
            if (_info.ownerId != this.brokerId) {
                try {
                    int p = 0;
                    if (_profiles == null) {
                        _profiles = this.initialProfiles;
                    }
                    int i = 0;
                    while (i < _profiles.length) {
                        if (_profiles[i].supplyType("None")) {
                            p = i;
                            break;
                        }
                        ++i;
                    }
                    if (_info.getIncomingProfile() != null) {
                        StringTokenizer tokenizer = new StringTokenizer(_info.getIncomingProfile(), ":");
                        try {
                            tokenizer.nextToken();
                            this.sessionProcessor.getConnectionFrom(tokenizer.nextToken(), tokenizer.nextToken(), Integer.parseInt(tokenizer.nextToken()), _info);
                            return this.sessionProcessor;
                        }
                        catch (NoSuchElementException nsee) {
                            _info.setIncomingProfile(null);
                        }
                        catch (NumberFormatException nfe) {
                            _info.setIncomingProfile(null);
                        }
                        catch (P4IOException p4ioe) {
                            // empty catch block
                        }
                    }
                    this.sessionProcessor.getConnectionFrom(_profiles[p].getType(), _profiles[p].getHost(), _profiles[p].getPort(), _info);
                    return this.sessionProcessor;
                }
                catch (Exception ex) {
                    this.trace(class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, ex, "getRepliable", 100);
                    throw (P4IOException)P4ObjectBroker.broker.getException(0, P4BaseIOException.Unable_to_Open_Connection, ex);
                }
            }
            _info.local_id = _info.server_id;
            return this.sessionProcessor.getMessenger();
        }
        this.sessionProcessor = P4SessionProcessor.getSessionProcessor();
        this.thisServerId = this.sessionProcessor.getServerId();
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void postInit() {
        this.sessionProcessor = P4SessionProcessor.getSessionProcessor();
        this.thisServerId = this.sessionProcessor.getServerId();
        this.createRedirConfig();
        try {
            this.brokerId = Integer.parseInt(this.sessionProcessor.serviceContext.getServiceState().getProperty("brokerId"));
            return;
        }
        catch (NumberFormatException e) {
            block15: {
                this.trace(P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, "\"brokerId isn't set as local property in this server.\"", "postInit", 200);
                rootConfiguration = null;
                properties = this.sessionProcessor.serviceContext.getServiceState().getProperties();
                propTime = properties.getProperty("SLEEP_FOR_WRITE_BROKERID");
                propTries = properties.getProperty("TRIES_TO_WRITE_BROKERID");
                time = propTime != null ? Long.parseLong(propTime) : 2000L;
                tries = propTries != null ? Integer.parseInt(propTries) : 8;
                try {
                    factory = this.sessionProcessor.getServiceContext().getCoreContext().getConfigurationHandlerFactory();
                    this.handler = factory.getConfigurationHandler();
                    try {
                        rootConfiguration = this.handler.openConfiguration(P4ObjectBrokerServerImpl.p4_Persistent, 0);
                        this.brokerId = (int)((Long)rootConfiguration.getConfigEntry("brokerId")).longValue();
                    }
                    catch (NameNotFoundException ex) {
                        this.brokerId = this.createRootConfiguration(time, tries);
                    }
                    catch (ConfigurationLockedException cl) {
                        this.brokerId = this.readFromConfiguration(time, tries);
                    }
                    var12_13 = null;
                    if (this.handler == null) break block15;
                    ** GOTO lbl47
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new InitializingException("Configuration Exception when try to get ConfigurationFacroty or ConfigurationHandler! : " + ex.toString());
                }
                {
                    catch (Throwable var11_17) {
                        var12_14 = null;
                        if (this.handler == null) throw var11_17;
                        try {
                            this.handler.commit();
                            this.handler.closeAllConfigurations();
                            throw var11_17;
                        }
                        catch (ConfigurationException e) {
                            e.printStackTrace();
                        }
                        throw var11_17;
                    }
lbl47:
                    // 1 sources

                    ** try [egrp 4[TRYBLOCK] [5 : 308->329)] { 
lbl48:
                    // 1 sources

                    this.handler.commit();
                    this.handler.closeAllConfigurations();
lbl51:
                    // 1 sources

                    catch (ConfigurationException e) {}
                    e.printStackTrace();
                }
            }
            try {
                this.sessionProcessor.serviceContext.getContainerContext().getSystemMonitor().getService("p4").setProperty("brokerId", Integer.toString(this.brokerId));
                return;
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createRedirConfig() {
        try {
            try {
                factory = this.sessionProcessor.getServiceContext().getCoreContext().getConfigurationHandlerFactory();
                this.handler = factory.getConfigurationHandler();
                this.handler.openConfiguration("P4_PersistentObject", 0);
                var6_3 = null;
                if (this.handler == null) return;
            }
            catch (NameNotFoundException nn) {
                try {
                    this.handler.createRootConfiguration("P4_PersistentObject");
                }
                catch (NameAlreadyExistsException nae) {
                    P4ObjectBroker.broker.trace(P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, "P4_PersistentObject was created and this try is redundant ", "createRedirConfig", 200);
                }
                catch (ConfigurationLockedException cle) {
                    P4ObjectBroker.broker.trace(P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, (Exception)cle, "createRedirConfig", 100);
                }
                catch (ConfigurationException ce) {
                    P4ObjectBroker.broker.trace(P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, (Exception)ce, "createRedirConfig", 100);
                }
                var6_4 = null;
                if (this.handler == null) return;
                try {
                    this.handler.commit();
                    this.handler.closeAllConfigurations();
                    return;
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                    return;
                }
            }
            catch (Exception e) {
                P4ObjectBroker.broker.trace(P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : P4ObjectBrokerServerImpl.class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, e, "createRedirConfig", 100);
                var6_5 = null;
                if (this.handler == null) return;
                try {}
                catch (ConfigurationException e) {
                    e.printStackTrace();
                    return;
                }
                this.handler.commit();
                this.handler.closeAllConfigurations();
                return;
            }
        }
        catch (Throwable var5_15) {
            var6_6 = null;
            if (this.handler == null) throw var5_15;
            ** try [egrp 3[TRYBLOCK] [6 : 232->253)] { 
lbl52:
            // 1 sources

            this.handler.commit();
            this.handler.closeAllConfigurations();
            throw var5_15;
lbl55:
            // 1 sources

            catch (ConfigurationException e) {
                e.printStackTrace();
            }
            throw var5_15;
        }
        ** try [egrp 3[TRYBLOCK] [6 : 232->253)] { 
lbl60:
        // 1 sources

        this.handler.commit();
        this.handler.closeAllConfigurations();
        return;
lbl63:
        // 1 sources

        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    private int createRootConfiguration(long waitTime, int tries) {
        Configuration rootConfiguration = null;
        try {
            rootConfiguration = this.handler.createRootConfiguration(p4_Persistent);
            rootConfiguration.addConfigEntry("brokerId", new Long(this.brokerId));
            return this.brokerId;
        }
        catch (NameAlreadyExistsException not) {
            return this.readFromConfiguration(waitTime, tries);
        }
        catch (ConfigurationLockedException cl) {
            return this.readFromConfiguration(waitTime, tries);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            throw new InitializingException("Cannot read/write brokerId from/to DB. General ConfigurationException : " + ((Throwable)((Object)e)).toString());
        }
    }

    private int readFromConfiguration(long waitTime, int tries) {
        Configuration rootConfiguration = null;
        int i = 0;
        while (i < tries) {
            try {
                rootConfiguration = this.handler.openConfiguration(p4_Persistent, 0);
                return (int)((Long)rootConfiguration.getConfigEntry("brokerId")).longValue();
            }
            catch (ConfigurationLockedException e) {
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException interupt) {
                    this.log(class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl") : class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, "interrupted the current thread when wato for another try to read from db brokerId", "readFromConfiguration", 200);
                }
                if (i == tries - 1) {
                    this.log(class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, "Cannot read brokerId from DB. Increase time for waiting to read brokerId from DB!", "readFromConfiguration", 200);
                    throw new InitializingException("Cannot read brokerId from DB. Increase time for waiting to read brokerId from DB!");
                }
            }
            catch (NameNotFoundException nf) {
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException interupt) {
                    this.log(class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl") : class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, "interrupted the current thread when wato for another try to read from db brokerId", "readFromConfiguration", 200);
                }
                if (i == tries - 1) {
                    this.log(class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, "Cannot read brokerId from DB. Increase time for waiting to read brokerId from DB! (name not found)", "readFromConfiguration", 200);
                    throw new InitializingException("Cannot read brokerId from DB. Increase time for waiting to read brokerId from DB! (name not found)");
                }
            }
            catch (ConfigurationException ex) {
                ex.printStackTrace();
                throw new InitializingException("Cannot read  brokerId from DB. General ConfigurationException : " + ((Throwable)((Object)ex)).toString());
            }
            ++i;
        }
        throw new InitializingException("The attempts that try to read brokerId are failed. Increase the time for waiting to read brokerId from DB!. Now they are : " + tries);
    }

    public void postInit(int sPort) {
    }

    private String getLastUrl(String name, String alias, String dirs) {
        int ii;
        if (dirs == null || dirs.indexOf(".") != -1) {
            String string = name.indexOf(APPDIR) != -1 ? APP_DIR_SEP : (dirs = name.indexOf(BINDIR) != -1 ? BIN_DIR_SEP : null);
        }
        if ((ii = name.lastIndexOf(dirs)) != -1) {
            return "/" + alias + new String(name.substring(ii + dirs.length()));
        }
        return null;
    }

    private void configureHosts(P4RemoteObjectInfo info) {
        info.hosts = new String[this.http.length];
        int n = 0;
        while (n < this.http.length) {
            info.hosts[n] = HTTP_PREFIX + this.http[n];
            ++n;
        }
    }

    public void setURLList(P4RemoteObject obj) {
        if (this.http == null || this.http.length == 0) {
            return;
        }
        P4RemoteObjectInfo info = obj.getInfo();
        if (info.urls != null) {
            return;
        }
        ClassLoader cLoader = obj.getClass().getClassLoader();
        String[] listName = null;
        HashSet<String> allRes = new HashSet<String>();
        String alias = "";
        String currentDir = "";
        if (cLoader.getClass().getName().equals(EJBLOADER)) {
            listName = ((ReferencedLoader)cLoader.getParent()).getResourceNames();
            alias = APP_ALIAS_SEP;
            currentDir = SystemProperties.getProperty(DOWNLOAD_APPS_DIRS);
        } else if (cLoader.getClass().getName().equals(APPLOADER)) {
            listName = ((ReferencedLoader)cLoader).getResourceNames();
            alias = APP_ALIAS_SEP;
            currentDir = SystemProperties.getProperty(DOWNLOAD_APPS_DIRS);
        } else {
            listName = ((ReferencedLoader)cLoader).getResourceNames();
            alias = BIN_ALIAS_SEP;
            currentDir = SystemProperties.getProperty(DOWNLOAD_SERVICE_DIRS);
        }
        if (listName != null && listName.length > 0 && currentDir != null) {
            String s = null;
            int i = 0;
            while (i < listName.length) {
                s = this.getLastUrl(listName[i], alias, currentDir);
                if (s != null) {
                    allRes.add(this.getLastUrl(listName[i], alias, currentDir));
                }
                ++i;
            }
            info.urls = ((AbstractCollection)allRes).toArray(new String[0]);
            this.configureHosts(info);
        } else if (currentDir == null) {
            this.trace(class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, "The remote classloading will not work. Maybe the application with name \"download\" didn't start. Please, start this application", "setURLList", 100);
        }
    }

    public void connect(P4RemoteObject obj) {
        super.connect(obj);
    }

    public Object narrow(Object info, Class stubClass, String _connectionType) {
        return this.narrow(info, stubClass, _connectionType, stubClass.getClassLoader());
    }

    public Object narrow(Object info, Class stubClass, String _connectionType, ClassLoader cLoader) {
        StubBaseInfo _info = null;
        if (info == null) {
            return null;
        }
        if (info instanceof RemoteRef) {
            RemoteObjectInfo remInfo = ((RemoteRef)info).getObjectInfo();
            _info = remInfo instanceof StubBaseInfo ? (StubBaseInfo)remInfo : StubBaseInfo.makeStubBaseInfo(remInfo);
        } else if (info instanceof StubBaseInfo) {
            _info = (StubBaseInfo)info;
        } else if (info instanceof P4ServerObjectInfo) {
            _info = StubBaseInfo.makeStubBaseInfo((RemoteObjectInfo)info);
        } else {
            if (stubClass.isAssignableFrom(info.getClass())) {
                return info;
            }
            throw new ClassCastException(stubClass.getName());
        }
        if (stubClass.isAssignableFrom(info.getClass())) {
            if (_info.ownerId == this.brokerId && _info.server_id == this.thisServerId) {
                if (!Proxy.isProxyClass(info.getClass())) {
                    ((StubImpl)info).isLocal = true;
                    _info.local_id = this.id;
                    ((StubImpl)info).p4remote = this.getObject(_info.key);
                    _info.connected = true;
                }
                return info;
            }
            if (_info != null && !_info.connected) {
                try {
                    this.makeConnection(_connectionType, (StubImpl)info);
                }
                catch (Exception ex) {
                    this.trace(class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, "Error making connection. Stub instance <" + info + "> is not connected.", "narrow", 500);
                }
            }
            return info;
        }
        if (_info.ownerId == this.brokerId && _info.server_id == this.thisServerId) {
            if (!P4ServiceFrame.instantiateLocalStubs) {
                return this.getObject(_info.key).getDelegate();
            }
            return this.loadLocalStub(_info, stubClass);
        }
        return super.narrow(info, stubClass, _connectionType, cLoader);
    }

    public ConnectionObject[] listConnections() {
        return this.sessionProcessor.organizer.listConnections();
    }

    public boolean pingConnection(Object obj) {
        return false;
    }

    public boolean pingObject(Object obj) {
        return false;
    }

    public String getHost() throws IOException {
        return "remotehost";
    }

    public int getPort() throws IOException {
        return 0;
    }

    public Object loadLocalStub(StubBaseInfo info, Class stubClass) {
        StubImpl ret = null;
        Class<?> _class = null;
        if (stubClass.isInterface()) {
            Tie tie;
            String name = stubClass.getName();
            ClassLoader loader = stubClass.getClassLoader();
            try {
                _class = loader == null ? Class.forName(name + "_Stub") : loader.loadClass(name + "_Stub");
            }
            catch (ClassNotFoundException cnfex) {
                try {
                    _class = Thread.currentThread().getContextClassLoader().loadClass(name + "_Stub");
                }
                catch (ClassNotFoundException cnfex_) {
                    this.trace(class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, "A problem with loading stub class: " + name + " in P4ObjectBrokerServerImpl.loadLocalStub().\n ClassNotFoundException. The Proxy will try to raise", "loadLocalStub", 200);
                    LocalInvocationHandler invocationHandler = new LocalInvocationHandler(this.getObject(info.key));
                    Class[] cl = new Class[]{stubClass, class$com$sap$engine$services$rmi_p4$RemoteRef == null ? (class$com$sap$engine$services$rmi_p4$RemoteRef = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.RemoteRef")) : class$com$sap$engine$services$rmi_p4$RemoteRef};
                    loader = stubClass.getClassLoader();
                    Object proxy = null;
                    try {
                        proxy = Proxy.newProxyInstance(loader, cl, (InvocationHandler)invocationHandler);
                    }
                    catch (Exception e) {
                        proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), cl, (InvocationHandler)invocationHandler);
                    }
                    return proxy;
                }
            }
            try {
                ret = (StubImpl)_class.newInstance();
            }
            catch (Exception ex) {
                this.trace(class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, "Error instantiating local stub: " + _class + " in P4ObjectBrokerServerImpl.loadLocalStub().\n Stub instance is not accessible.", "narrow", 500);
            }
            ret.isLocal = true;
            if (info.stubs == null) {
                info.stubs = new String[]{stubClass.getName()};
            }
            info.local_id = this.id;
            ret.p4_setInfo(info);
            ret.p4_setClassLoader(loader);
            ret.p4remote = this.getObject(info.key);
            if (ret.p4remote != null && ret.p4remote.getDelegate() != null && (tie = Util.getTie((Remote)ret.p4remote.getDelegate())) != null) {
                try {
                    Util.registerTarget((Tie)((Tie)tie.thisObject()), (Remote)((Remote)((Object)ret)));
                    tie.setTarget(ret.p4remote.getDelegate());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    public void setInitialObject(String name, P4RemoteObject initObject) throws Exception {
        try {
            super.setInitialObject(name, initObject);
        }
        catch (Exception ex) {
            this.trace(class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, "Error setting Initial Object: " + name + ":" + initObject + " in P4ObjectBrokerServerImpl.setItialObject().\n This object is not accessible.", "setInitialObject", 500);
        }
    }

    public int getId() {
        if (this.sessionProcessor != null) {
            this.id = this.sessionProcessor.getServerId();
            return this.id;
        }
        this.sessionProcessor = P4SessionProcessor.getSessionProcessor();
        this.thisServerId = this.sessionProcessor.getServerId();
        return 0;
    }

    public ConnectionProfile[] getConnectionProfiles() {
        if (this.sessionProcessor != null) {
            return this.sessionProcessor.getConnectionProfiles();
        }
        this.sessionProcessor = P4SessionProcessor.getSessionProcessor();
        this.thisServerId = this.sessionProcessor.getServerId();
        return null;
    }

    public void inform(Object _identifer, Message _message) {
        if (_identifer instanceof LocalDispatch) {
            String identifer = "LocalDispatc@" + _identifer.hashCode();
            this.objManager.inform(identifer, _message.getUnmarshaledRequest());
        } else {
            String identifer = _message.clusterEl_id + ":" + _message.client_id;
            this.objManager.inform(identifer, _message.getUnmarshaledRequest());
        }
    }

    public void disposeConnection(Object _connection) {
        this.objManager.disposeConnection(_connection);
    }

    public void runGarbageCollector() {
        new GarbageCollectorServerImpl(this.objManager);
    }

    public P4RemoteObject loadObject(Remote remote) throws ClassNotFoundException {
        byte[] key;
        if (remote instanceof P4RemoteObject) {
            return (P4RemoteObject)((Object)remote);
        }
        P4RemoteObject obj = null;
        WeakReference weakRef = (WeakReference)this.portableRemoteObjects.get(remote);
        if (weakRef != null && (obj = (P4RemoteObject)weakRef.get()) != null && (obj = this.getObject(key = obj.getObjectInfo().key)) != null) {
            return obj;
        }
        Class<?> remoteClass = remote.getClass();
        String remoteClassName = remoteClass.getName();
        remoteClassName = remoteClassName + "p4_Skel";
        Class skeletonClass = null;
        try {
            skeletonClass = Class.forName(remoteClassName, true, remoteClass.getClassLoader());
            obj = (P4RemoteObject)skeletonClass.newInstance();
        }
        catch (Exception e) {
            try {
                skeletonClass = this.getParentSkel(remoteClass, "p4_Skel");
                obj = (P4RemoteObject)skeletonClass.newInstance();
            }
            catch (Exception ex) {
                obj = new P4DynamicSkeleton(remote);
            }
        }
        if (remote instanceof Redirectable) {
            obj.info.isRedirectable = true;
            obj.info.redirIdent = ((Redirectable)((Object)remote)).getIdentifier();
        }
        obj.setDelegate(remote);
        if (this.useReiterationOfGC) {
            P4ReferenceProxy remoteRef = new P4ReferenceProxy(remote);
            this.portableRemoteObjects.put(remoteRef, new WeakReference<P4RemoteObject>(obj));
        } else {
            this.portableRemoteObjects.put(remote, new WeakReference<P4RemoteObject>(obj));
        }
        return obj;
    }

    public Enumeration getPRO_Keys() {
        return this.portableRemoteObjects.keys();
    }

    public void clear(Object key) {
        this.portableRemoteObjects.remove(key);
    }

    public void disconnect(P4RemoteObject _object) {
        if (_object.delegate != null && !(_object.delegate instanceof P4RemoteObject)) {
            this.clear(_object.delegate);
        }
        super.disconnect(_object);
    }

    public void log(String message, boolean d) {
        this.log(message);
    }

    public void log(Exception ex, boolean d, String id) {
        this.log(ex, id);
    }

    public void log(Exception ex, boolean d) {
        this.log(ex);
    }

    public void log(Class cl, String message, boolean d, String methodName, int idSev) {
        this.log(cl, message, methodName, idSev);
    }

    public void log(Class cl, Exception ex, boolean d, String id, String methodName, int idSev) {
        this.log(cl, ex, id, methodName, idSev);
    }

    public void log(Class cl, Exception ex, boolean d, String methodName, int idSev) {
        this.log(cl, ex, methodName, idSev);
    }

    public void trace(Class cl, String message, String methodName, int IdSer) {
        switch (IdSer) {
            case 500: {
                P4Logger.traceErr(cl.getName() + " " + methodName + " MSG:" + message);
                break;
            }
            case 100: {
                P4Logger.traceDebug(cl.getName() + " " + methodName + " MSG:" + message);
                break;
            }
            case 300: {
                P4Logger.traceInfo(cl.getName() + "." + methodName + " MSG: " + message);
                break;
            }
            case 200: {
                P4Logger.traceOther((byte)IdSer, cl.getName() + "." + methodName + " MSG: " + message);
                break;
            }
            case 400: {
                P4Logger.traceOther((byte)IdSer, cl.getName() + "." + methodName + " MSG: " + message);
                break;
            }
            default: {
                P4Logger.traceInfo(cl.getName() + "." + methodName + " MSG:" + message);
            }
        }
    }

    public void trace(Class cl, Exception ex, String id, String methodName, int IdSer) {
        switch (IdSer) {
            case 500: {
                P4Logger.traceThrowable(cl, methodName + " ID:" + id + "  MSG:" + ex.getMessage(), ex);
                break;
            }
            case 100: {
                P4Logger.traceDebug(cl, methodName + " ID:" + id + " MSG:" + ex.getMessage(), ex);
                break;
            }
            case 300: {
                P4Logger.traceInfoThrowable(cl, methodName + " ID:" + id + "  MSG:" + ex.getMessage(), ex);
                break;
            }
            case 200: {
                P4Logger.traceOther((byte)IdSer, cl.getName() + "." + methodName + " ID:" + id + "  MSG:" + ex.getMessage() + "\n" + P4Logger.exceptionTrace(ex));
                break;
            }
            case 400: {
                P4Logger.traceWarning(cl.getName() + "." + methodName + " ID:" + id + "  MSG:" + ex.getMessage() + "\n" + P4Logger.exceptionTrace(ex));
                break;
            }
            default: {
                P4Logger.traceInfoThrowable(cl, methodName + " ID:" + id + "  MSG:" + ex.getMessage(), ex);
            }
        }
    }

    public void trace(Class cl, Throwable er, String methodName, int IdSer) {
        switch (IdSer) {
            case 500: {
                P4Logger.traceThrowable(cl, methodName + " MSG:" + er.getMessage(), er);
                break;
            }
            case 100: {
                P4Logger.traceDebug(cl, methodName + " MSG:" + er.getMessage(), er);
                break;
            }
            case 300: {
                P4Logger.traceInfoThrowable(cl, methodName + "  MSG:" + er.getMessage(), er);
                break;
            }
            case 200: {
                P4Logger.traceOther((byte)IdSer, cl.getName() + "." + methodName + "  MSG:" + er.getMessage() + "\n" + P4Logger.exceptionTrace(er));
                break;
            }
            case 400: {
                P4Logger.traceWarning(cl.getName() + "." + methodName + "  MSG:" + er.getMessage() + "\n" + P4Logger.exceptionTrace(er));
                break;
            }
            default: {
                P4Logger.traceInfoThrowable(cl, methodName + "  MSG:" + er.getMessage(), er);
            }
        }
    }

    public void trace(Class cl, Exception ex, String methodName, int IdSer) {
        switch (IdSer) {
            case 500: {
                P4Logger.traceThrowable(cl, methodName + " MSG:" + ex.getMessage(), ex);
                break;
            }
            case 100: {
                P4Logger.traceDebug(cl, methodName + " MSG:" + ex.getMessage(), ex);
                break;
            }
            case 300: {
                P4Logger.traceInfoThrowable(cl, methodName + "  MSG:" + ex.getMessage(), ex);
                break;
            }
            case 200: {
                P4Logger.traceOther((byte)IdSer, cl.getName() + "." + methodName + "  MSG:" + ex.getMessage() + "\n" + P4Logger.exceptionTrace(ex));
                break;
            }
            case 400: {
                P4Logger.traceWarning(cl.getName() + "." + methodName + "  MSG:" + ex.getMessage() + "\n" + P4Logger.exceptionTrace(ex));
                break;
            }
            default: {
                P4Logger.traceInfoThrowable(cl, methodName + "  MSG:" + ex.getMessage(), ex);
            }
        }
    }

    public void log(String message) {
        P4Logger.logInfo("P4:" + Thread.currentThread() + ": " + message);
    }

    public void log(Exception ex, String id) {
        P4Logger.logInfo("ID:" + id + ": " + ex.getMessage());
    }

    public void log(Exception ex) {
        P4Logger.logInfo(ex.getMessage());
    }

    public void log(Class cl, String message, String methodName, int idSev) {
        switch (idSev) {
            case 500: {
                P4Logger.logErr("> " + cl.getName() + "->" + methodName + "  MSG:" + message);
                break;
            }
            case 100: {
                P4Logger.logDebug("> " + cl.getName() + "->" + methodName + "  MSG:" + message);
                break;
            }
            case 300: {
                P4Logger.logInfo("> " + cl.getName() + "->" + methodName + "  MSG:" + message);
                break;
            }
            case 200: {
                P4Logger.logPath("> " + cl.getName() + "->" + methodName + "  MSG:" + message);
                break;
            }
            case 400: {
                P4Logger.logWarning("> " + cl.getName() + "->" + methodName + "  MSG:" + message);
                break;
            }
            default: {
                P4Logger.logOther((byte)idSev, "> " + cl.getName() + "->" + methodName + "  MSG:" + message);
            }
        }
    }

    public void log(Class cl, Exception ex, String id, String methodName, int idSev) {
        switch (idSev) {
            case 500: {
                P4Logger.logErr("> " + cl.getName() + "->" + methodName + " ID:" + id + "\n\n" + P4Logger.exceptionTrace(ex));
                break;
            }
            case 100: {
                P4Logger.logDebug("> " + cl.getName() + "->" + methodName + " ID:" + id + "\n\n" + P4Logger.exceptionTrace(ex));
                break;
            }
            case 300: {
                P4Logger.logInfo("> " + cl.getName() + "->" + methodName + " ID:" + id + "\n\n" + P4Logger.exceptionTrace(ex));
                break;
            }
            case 200: {
                P4Logger.logPath("> " + cl.getName() + "->" + methodName + " ID:" + id + "\n\n" + P4Logger.exceptionTrace(ex));
                break;
            }
            case 400: {
                P4Logger.logWarning("> " + cl.getName() + "->" + methodName + " ID:" + id + "\n\n" + P4Logger.exceptionTrace(ex));
                break;
            }
            default: {
                P4Logger.logOther((byte)idSev, "> " + cl.getName() + "->" + methodName + " ID:" + id + "\n\n" + P4Logger.exceptionTrace(ex));
            }
        }
    }

    public void log(Class cl, Exception ex, String methodName, int idSev) {
        switch (idSev) {
            case 500: {
                P4Logger.logErr("> " + cl.getName() + "->" + methodName + "\n\n" + P4Logger.exceptionTrace(ex));
                break;
            }
            case 100: {
                P4Logger.logDebug("> " + cl.getName() + "->" + methodName + "\n\n" + P4Logger.exceptionTrace(ex));
                break;
            }
            case 300: {
                P4Logger.logInfo("> " + cl.getName() + "->" + methodName + "\n\n" + P4Logger.exceptionTrace(ex));
                break;
            }
            case 200: {
                P4Logger.logPath("> " + cl.getName() + "->" + methodName + "\n\n" + P4Logger.exceptionTrace(ex));
                break;
            }
            case 400: {
                P4Logger.logWarning("> " + cl.getName() + "->" + methodName + "\n\n" + P4Logger.exceptionTrace(ex));
                break;
            }
            default: {
                P4Logger.logOther((byte)idSev, "> " + cl.getName() + "->" + methodName + "\n\n" + P4Logger.exceptionTrace(ex));
            }
        }
    }

    public Object getCrossInterface() {
        return P4ServiceFrame.crossInterface;
    }

    public ClientThreadContext getCTC() {
        if (this.sessionProcessor != null) {
            return this.sessionProcessor.getServiceContext().getCoreContext().getThreadSystem().getThreadContext();
        }
        this.sessionProcessor = P4SessionProcessor.getSessionProcessor();
        this.thisServerId = this.sessionProcessor.getServerId();
        return this.sessionProcessor.getServiceContext().getCoreContext().getThreadSystem().getThreadContext();
    }

    public StubBaseInfo stringToObject(String objectRef) {
        if (!objectRef.startsWith("clusteraloc")) {
            return super.stringToObject(objectRef);
        }
        P4Schema schema = new P4Schema(objectRef);
        MessageAnswer answer = null;
        if (this.sessionProcessor != null) {
            try {
                answer = this.sessionProcessor.organizer.messageContext.sendAndWaitForAnswer(schema.getClusterId(), 14, schema.getObjKey().getBytes(), 0, schema.getObjKey().length(), 10000L);
            }
            catch (ClusterException _ex) {
                _ex.printStackTrace();
            }
            if (answer == null) {
                return null;
            }
            byte[] buf = new byte[answer.getLength()];
            System.arraycopy(answer.getMessage(), answer.getOffset(), buf, 0, buf.length);
            return this.byteArrayToObject(buf);
        }
        this.sessionProcessor = P4SessionProcessor.getSessionProcessor();
        this.thisServerId = this.sessionProcessor.getServerId();
        return null;
    }

    public void postInit(Properties prop) {
    }

    public void setExecContextState(Object o) {
        if (this.cec != null) {
            this.cec.setCurrentState(o);
        }
    }

    public Object applyExecContextState(Object pro) {
        if (this.cec != null) {
            return this.cec.applyState(pro);
        }
        return null;
    }

    public void setExecContext(Object o) {
        if (o != null) {
            this.cec = (ComponentExecutionContext)o;
        }
    }

    public String[] getHttp() {
        return this.http;
    }

    public Exception getException(int type, String msgText, Throwable th) {
        return this.getException(type, msgText, th, null);
    }

    public Exception getException(int type, String msgText, Throwable th, Object[] args) {
        switch (type) {
            case 0: {
                return new P4BaseIOException(msgText, args, th);
            }
            case 2: {
                return new P4BaseConnectionException(msgText, args, th);
            }
            case 3: {
                return new InitializingException(msgText, th);
            }
            case 4: {
                return new P4BaseMarshalException(msgText, args, th);
            }
            case 5: {
                return new P4BaseParseRequestException(msgText, args, th);
            }
        }
        return new P4BaseRuntimeException(msgText, args, th);
    }

    public byte[] getInitialObject(String name) throws RemoteException {
        if (this.initObjects.containsKey(name)) {
            P4RemoteObject initObject = (P4RemoteObject)this.initObjects.get(name);
            RemoteObjectInfo info = initObject.getObjectInfo();
            info.connectionProfiles = this.getConnectionProfiles();
            byte[] r = this.makeObjectRef(info.connectionProfiles, info.server_id, info.key);
            return r;
        }
        ClusterElement[] ce = this.sessionProcessor.organizer.clusterContext.getClusterMonitor().getParticipants();
        int i = 0;
        while (i < ce.length) {
            if (ce[i].getType() == 2) {
                int id = ce[i].getClusterId();
                MessageAnswer answer = null;
                if (this.sessionProcessor != null) {
                    try {
                        answer = this.sessionProcessor.organizer.messageContext.sendAndWaitForAnswer(id, 14, name.getBytes(), 0, name.length(), 10000L);
                    }
                    catch (ClusterException _ex) {
                        this.log(class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? P4ObjectBrokerServerImpl.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl") : class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl, (Exception)((Object)_ex), "getInitialObject", 100);
                    }
                    if (answer.getLength() > 0) {
                        byte[] buf = new byte[answer.getLength()];
                        System.arraycopy(answer.getMessage(), answer.getOffset(), buf, 0, answer.getLength());
                        return buf;
                    }
                }
            }
            ++i;
        }
        throw new NoSuchObjectException("ID:011781: Object:<" + name + ">");
    }

    public boolean isServerBroker() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

