/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.monitor;

import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.Connection;
import com.sap.engine.services.rmi_p4.Message;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.exception.P4BaseIOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class PingCall {
    private static Hashtable calls = new Hashtable();
    private static long callId = 0L;
    private long id;
    private byte[] result;
    private Connection con;
    private int dispId;
    private int clientId;
    private static int pingTimeout = 10000;

    PingCall(long id) {
        this.id = id;
    }

    public int getDispId() {
        return this.dispId;
    }

    public void setDispId(int dispId) {
        this.dispId = dispId;
    }

    public int getClientId() {
        return this.clientId;
    }

    public void setClientId(int clientId) {
        this.clientId = clientId;
    }

    public synchronized byte[] getResult(Connection con) throws InterruptedException, P4IOException {
        this.con = con;
        if (this.result == null) {
            this.wait(pingTimeout);
        }
        if (this.result == null) {
            throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Connection_lost, null);
        }
        return this.result;
    }

    public synchronized void set(Message result) {
        this.result = result.request;
        this.notify();
    }

    public void writeId(byte[] where, int off) {
        Convert.writeLongToByteArr(where, 14, this.id);
    }

    public void remove() {
        Long ID = new Long(this.id);
        calls.remove(ID);
    }

    protected static void clear() {
        calls.clear();
        callId = 0L;
    }

    protected static void freeConnection(Connection con) {
    }

    public static synchronized PingCall getPingCall() {
        PingCall call = new PingCall(callId);
        calls.put(new Long(callId++), call);
        return call;
    }

    public static PingCall getCall(long id) {
        Long ID = new Long(id);
        PingCall call = (PingCall)calls.get(ID);
        calls.remove(ID);
        return call;
    }

    public static Enumeration getAllCalls() {
        return calls.elements();
    }
}

