/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.log;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class P4Logger {
    private static Category category = null;
    private static Location location = null;

    public static void setCategory(Category category) {
        P4Logger.category = category;
    }

    public static void setLocation(Location location) {
        P4Logger.location = location;
    }

    public static synchronized void traceErr(String msg) {
        if (location != null) {
            location.logT(500, msg);
        }
    }

    public static synchronized void traceInfo(String msg) {
        if (location != null) {
            location.logT(300, msg);
        }
    }

    public static synchronized void traceOther(byte i, String msg) {
        if (location != null) {
            location.infoT(msg);
        }
    }

    public static synchronized void traceWarning(String message) {
        if (location != null) {
            location.warningT(message);
        }
    }

    public static synchronized void traceDebug(String message) {
        if (location != null) {
            location.debugT(message);
        }
    }

    public static synchronized void traceDebug(Class c, String methodName, Throwable thr) {
        if (location != null) {
            location.debugT(">>>" + c.getName() + " " + methodName, P4Logger.exceptionTrace(thr));
        }
    }

    public static synchronized void traceThrowable(Class c, String methodName, Throwable throwable) {
        if (location != null) {
            location.errorT(">>>" + c.getName() + " " + methodName, P4Logger.exceptionTrace(throwable));
        }
    }

    public static synchronized void traceInfoThrowable(Class c, String methodName, Throwable throwable) {
        if (location != null) {
            location.logT(300, c.getName() + "." + methodName + " <> " + P4Logger.exceptionTrace(throwable));
        }
    }

    public static synchronized void logErr(String msg) {
        if (category != null) {
            category.log(500, location, (Object)msg);
        }
    }

    public static synchronized void logInfo(String msg) {
        if (category != null) {
            category.logT(300, location, msg);
        }
    }

    public static synchronized void logOther(byte i, String msg) {
        if (category != null) {
            category.infoT(location, msg);
        }
    }

    public static synchronized void logWarning(String message) {
        if (category != null) {
            category.warningT(location, message);
        }
    }

    public static synchronized void logDebug(String msg) {
        if (category != null) {
            category.logT(100, location, msg);
        }
    }

    public static synchronized void logPath(String msg) {
        if (category != null) {
            category.logT(200, location, msg);
        }
    }

    public static synchronized void logThrowable(Throwable throwable) {
        if (category != null) {
            category.logT(500, location, throwable.getMessage());
        }
    }

    public static String exceptionTrace(Throwable thr) {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        thr.printStackTrace(new PrintStream(ostr));
        return "\r\n" + ostr.toString();
    }
}

