/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.dispatcher;

import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.CommunicationClusterContext;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.cluster.session.CommunicationSessionContext;
import com.sap.engine.frame.cluster.transport.TransportContext;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.interfaces.log.LogInterface;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.all.MessageConstants;
import com.sap.engine.services.rmi_p4.dispatcher.P4EventListener;
import com.sap.engine.services.rmi_p4.dispatcher.P4SessionProcessor;
import com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor;
import com.sap.engine.services.rmi_p4.exception.P4ResourceAccessor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;

public class P4ServiceFrame
implements CommunicationServiceFrame,
MessageListener,
MessageConstants,
ContainerEventListener {
    public static P4ServiceFrame frame = null;
    protected static boolean hasLogger = false;
    private static final String port_key = "Port";
    private static final String type_key = "Type";
    private static final String type_ssl = "ssl";
    public static Location location = null;
    private MessageContext messageContext;
    private CommunicationClusterContext clusterContext;
    private TransportContext transportContext;
    protected CommunicationServiceContext serviceContext;
    private CommunicationSessionContext sessionContext;
    private P4SessionProcessor sessionProcessor;
    private TransportMonitor transportMonitor;
    protected P4EventListener eventListener;

    public void P4ServiceFrame() {
    }

    public void start(CommunicationServiceContext baseContext) throws ServiceException {
        this.messageContext = baseContext.getClusterContext().getMessageContext();
        frame = this;
        Properties sp = baseContext.getServiceState().getProperties();
        this.serviceContext = baseContext;
        this.clusterContext = baseContext.getClusterContext();
        this.transportContext = this.clusterContext.getTransportContext();
        this.sessionContext = this.serviceContext.getClusterContext().getCommunicationSessionContext();
        this.sessionProcessor = new P4SessionProcessor(baseContext);
        Location location = Location.getLocation((String)"com.sap.engine.services.rmi_p4");
        Category category = Category.getCategory((String)P4ResourceAccessor.CATEGORY);
        new P4ResourceAccessor().init(category, location);
        P4SessionProcessor p4SessionProcessor = this.sessionProcessor;
        synchronized (p4SessionProcessor) {
            try {
                this.sessionContext.registerProcessor(this.sessionProcessor);
            }
            catch (ListenerAlreadyRegisteredException e) {
                P4ServiceFrame.logErr("ID 011066: Can't register p4 sessionProcessor :" + ((Throwable)((Object)e)).toString());
            }
            this.transportMonitor = new TransportMonitor(this, sp);
            this.sessionProcessor.postInit(this.transportMonitor.getHost(), this.transportMonitor.getRefereceToAvailableTransports());
            this.sessionProcessor.setMaxRequestSize(this.transportMonitor.getMaxRequestSize());
            this.sessionProcessor.setInitializationTimeout(this.transportMonitor.getInitializationTimeout());
            this.sessionProcessor.sendInQueueTimeout = this.transportMonitor.getSendInQueueTimeout();
        }
        int mask = 192;
        HashSet<String> names = new HashSet<String>(1);
        names.add("log");
        baseContext.getServiceState().registerContainerEventListener(mask, names, this);
        try {
            this.messageContext.registerListener(this);
        }
        catch (Exception e) {
            P4ServiceFrame.logErr("ID 011003: Can't register p4 messageListener :" + e.toString());
        }
        this.transportContext.getEventMonitor().registerListener(this.transportMonitor);
        this.eventListener = new P4EventListener(this.transportMonitor, this.clusterContext, this.sessionProcessor);
        this.serviceContext.getServiceState().registerClusterEventListener(this.eventListener);
        this.serviceContext.getServiceState().registerServiceEventListener(this.eventListener);
        try {
            P4ServiceFrame.logInfo("p4 service started.");
            hasLogger = true;
        }
        catch (Exception e) {
            P4ServiceFrame.logErr("ID 011004: Error getting LogInterface : " + e.toString());
        }
    }

    public void stop() {
        LogInterface logInterface;
        this.serviceContext.getServiceState().unregisterClusterEventListener();
        this.serviceContext.getServiceState().unregisterServiceEventListener();
        this.sessionContext.unregisterProcessor();
        this.sessionProcessor.stopProcessor();
        this.messageContext.unregisterListener();
        this.transportContext.getEventMonitor().unregisterListener(this.transportMonitor);
        this.messageContext.unregisterListener();
        if (hasLogger && (logInterface = (LogInterface)this.serviceContext.getContainerContext().getObjectRegistry().getProvidedInterface("log")) != null) {
            P4ServiceFrame.logInfo("p4 service stopped.");
            logInterface.destroyLogger("p4");
        }
        this.putLogonInfo(this.transportMonitor.listenerPort, false);
        this.transportMonitor = null;
        this.sessionProcessor = null;
        frame = null;
    }

    public void receive(int serverID, int _id, byte[] msg, int i1, int i2) {
    }

    public MessageAnswer receiveWait(int _serverId, int _id, byte[] _msg, int off, int length) {
        switch (_id) {
            case 1: {
                try {
                    String profiles = this.transportMonitor.getAllProfiles();
                    int len = 2 * profiles.length();
                    byte[] arr = new byte[len];
                    Convert.writeUStringToByteArr(arr, 0, profiles);
                    return new MessageAnswer(arr, 0, len);
                }
                catch (Exception ex) {
                    P4ServiceFrame.logErr("ID 011005 : Error in receiveWait Message : " + ex.toString());
                    return new MessageAnswer(new byte[0], 0, 0);
                }
            }
            case 2: {
                String toHost = "";
                String type = "None";
                int toPort = 0;
                try {
                    toPort = Convert.byteArrToInt(_msg, off);
                    int hostLength = Convert.byteArrToInt(_msg, off + 4);
                    int pos = 8 + off + hostLength;
                    toHost = Convert.byteArrToUString(_msg, 8 + off, hostLength / 2);
                    type = Convert.byteArrToUString(_msg, pos, (length - pos) / 2);
                    if (type.equals("")) {
                        type = "None";
                    }
                    int conId = this.transportMonitor.checkForLockal(type, toHost, toPort) ? -1 : this.sessionProcessor.getConnection(type, toHost, toPort);
                    byte[] arr = new byte[4];
                    Convert.writeIntToByteArr(arr, 0, conId);
                    return new MessageAnswer(arr, 0, 4);
                }
                catch (Exception ex) {
                    String infoMssg = ex.toString() + "\nID 011006:Rmi_P4 Dispatcher: Can't open socket to: " + toHost + ":" + toPort;
                    P4ServiceFrame.logWarning(infoMssg);
                    byte[] arr = infoMssg.getBytes();
                    return new MessageAnswer(arr, 0, arr.length);
                }
            }
            case 17: {
                String httpHost = "";
                Properties p = this.serviceContext.getContainerContext().getSystemMonitor().getService("http").getProperties();
                httpHost = this.clusterContext.getClusterMonitor().getCurrentParticipant().getAddress().getHostAddress() + ":" + P4ServiceFrame.getHttpPort(p.getProperty("Ports"));
                return new MessageAnswer(httpHost.getBytes(), 0, httpHost.getBytes().length);
            }
            case 4: {
                String result = "";
                Enumeration keys = this.sessionProcessor.connections.keys();
                Enumeration values = this.sessionProcessor.connections.elements();
                while (keys.hasMoreElements()) {
                    result = result + "~" + (String)keys.nextElement() + ":" + values.nextElement().toString();
                }
                return new MessageAnswer(result.substring(1).getBytes());
            }
        }
        return new MessageAnswer(new byte[0], 0, 0);
    }

    public void containerStarted() {
    }

    public void beginContainerStop() {
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
    }

    public void interfaceNotAvailable(String interfaceName) {
    }

    public void markForShutdown(long timeout) {
    }

    public boolean setServiceProperty(String key, String value) {
        return false;
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        return false;
    }

    public static synchronized void logErr(String msg) {
        if (location == null) {
            location = P4ResourceAccessor.location;
        }
        location.logT(500, msg);
    }

    public static synchronized void logInfo(String msg) {
        if (location == null) {
            location = P4ResourceAccessor.location;
        }
        location.logT(300, msg);
    }

    public static synchronized void logOther(int severity, String msg) {
        if (location == null) {
            location = P4ResourceAccessor.location;
        }
        location.logT(severity, msg);
    }

    public static synchronized void logWarning(String message) {
        if (location == null) {
            location = P4ResourceAccessor.location;
        }
        location.warningT(message);
    }

    public static synchronized void logThrowable(Throwable throwable) {
        if (location == null) {
            location = P4ResourceAccessor.location;
        }
        location.throwing(throwable);
    }

    public static int getHttpPort(String value) {
        int b = -1;
        int e = -1;
        String s = null;
        String v = null;
        while ((b = value.indexOf(40, e + 1)) > -1 && (e = value.indexOf(41, b + 1)) > -1) {
            s = value.substring(b + 1, e);
            v = P4ServiceFrame.getValue(s, type_key);
            if (v != null && v.trim().equals(type_ssl)) continue;
            v = P4ServiceFrame.getValue(s, port_key);
            if (v == null) break;
            return Integer.parseInt(v.trim());
        }
        return -1;
    }

    protected void putLogonInfo(int port, boolean open) {
        try {
            if (open) {
                int curGroupId = this.clusterContext.getClusterMonitor().getCurrentParticipant().getGroupId();
                int servers = 0;
                ClusterElement[] all = this.clusterContext.getClusterMonitor().getParticipants();
                if (all != null && all.length > 0) {
                    int i = 0;
                    while (i < all.length) {
                        if (all[i].getType() == 2 && all[i].getGroupId() == curGroupId && (all[i].getModifiers() & 1) == 0) {
                            ++servers;
                        }
                        ++i;
                    }
                }
                this.clusterContext.getCommunicationSessionContext().putLogonInfo(3, port, servers);
            } else {
                this.clusterContext.getCommunicationSessionContext().putLogonInfo(3, port, 0);
            }
        }
        catch (ClusterException e) {
            P4ServiceFrame.logErr("Cannot update p4 logon information for the message server !\n" + (Object)((Object)e));
        }
    }

    private static String getValue(String data, String key) {
        int i = 0;
        int j = 0;
        while ((i = data.indexOf(key + ":", j)) > -1) {
            if (i == 0 || Character.isWhitespace(data.charAt(i - 1)) || data.charAt(i - 1) == ',') break;
            j += key.length() + 1;
        }
        if (i > -1) {
            j = data.indexOf(44, i += key.length() + 1);
            if (j == -1) {
                j = data.length();
            }
            return data.substring(i, j);
        }
        return null;
    }
}

