/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.services.rmi_p4.ByteArrayInput;
import com.sap.engine.services.rmi_p4.ByteArrayOutput;
import com.sap.engine.services.rmi_p4.Call;
import com.sap.engine.services.rmi_p4.P4ConnectionException;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4ObjectInput;
import com.sap.engine.services.rmi_p4.P4ObjectOutput;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import com.sap.engine.services.rmi_p4.P4RuntimeException;
import com.sap.engine.services.rmi_p4.RemoteObjectInfo;
import com.sap.engine.services.rmi_p4.RemoteRef;
import com.sap.engine.services.rmi_p4.Repliable;
import com.sap.engine.services.rmi_p4.ReplicateInputStream;
import com.sap.engine.services.rmi_p4.ReplicateOutputStream;
import com.sap.engine.services.rmi_p4.StubBaseInfo;
import com.sap.engine.services.rmi_p4.exception.P4BaseConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public abstract class StubImpl
implements RemoteRef,
Serializable {
    static final long serialVersionUID = -7269201963209714255L;
    public static final String GET_CLASS_DATA = "p4_getClassData";
    public static final String GET_RESOURCE_DATA = "p4_getResourceData";
    public StubBaseInfo info;
    public Repliable repliable;
    public String connectionType;
    public P4ObjectBroker broker = P4ObjectBroker.init();
    public boolean isLocal = false;
    public P4RemoteObject p4remote = null;
    protected ClassLoader clLoader = this.getClass().getClassLoader();
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$StubImpl;

    public StubBaseInfo p4_getInfo() {
        return this.info;
    }

    public RemoteObjectInfo getObjectInfo() {
        return this.info;
    }

    public RemoteObjectInfo p4_getObjectInfo() {
        return this.getObjectInfo();
    }

    public String p4_getConnectionType() {
        return this.connectionType;
    }

    public void p4_setConnectionType(String _connectionType) {
        this.connectionType = _connectionType;
    }

    public String[] p4_getOperations() {
        return null;
    }

    public Call p4_newCall(int opnum) throws Exception {
        return Call.newCall(this, opnum);
    }

    public Call p4_newCall(String opname) throws Exception {
        return Call.newCall(this, opname);
    }

    public void p4_invoke(Call call) throws Exception {
        try {
            if (this.isLocal) {
                call.sendLocalRequest();
            } else {
                call.sendRequest();
            }
        }
        catch (P4IOException ioe) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl, ioe, "p4_invoke", 100);
            if (ioe.getMessage().endsWith("Ilegal client ID.")) {
                this.broker.trace(class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl, "Ilegal client ID.", "p4_invoke", 100);
                Call.removeCall(call.call_id);
                throw (P4ConnectionException)this.broker.getException(2, P4BaseConnectionException.Ilegal_client_ID, ioe);
            }
            try {
                if (this.info.checkConnectionType(this.connectionType) < 2) {
                    this.broker.log(this.getClass(), "The Stub could not establish connection.", "p4_invoke", 300);
                    Call.removeCall(call.call_id);
                    throw this.broker.getException(2, P4BaseConnectionException.Stub_couldnot_Establish_connection, null);
                }
                this.broker.makeConnection(this.connectionType, this);
                call.sendRequest();
            }
            catch (Exception ex) {
                this.broker.trace(class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl, ex, "p4_invoke", 100);
                Call.removeCall(call.call_id);
                throw (P4ConnectionException)this.broker.getException(2, P4BaseConnectionException.Ilegal_client_ID, ex);
            }
        }
        catch (Exception ex) {
            Call.removeCall(call.call_id);
            throw ex;
        }
    }

    public void p4_done(Call call) {
        if (call != null) {
            Call.removeCall(call.call_id);
        }
    }

    public void p4_setRepliaror(Repliable repliable) {
        this.repliable = repliable;
        if (!this.info.connected) {
            try {
                byte[] inf = this.p4_makeInformMessage((byte)0);
                repliable.reply(this.info.server_id, this.info.local_id, this.info.client_id, inf, inf.length);
                this.info.connected = true;
            }
            catch (Exception ioex) {
                this.broker.log(class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl, ioex, "Can't send inform message.", "p4_setRepliaror", 100);
                this.broker.trace(class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl, ioex, "p4_setRepliaror", 100);
            }
        }
    }

    public ClassLoader p4_getClassLoader() {
        return this.clLoader;
    }

    public void p4_setClassLoader(ClassLoader clLoader) {
        if (clLoader != null) {
            this.clLoader = clLoader;
        }
    }

    public void p4_setInfo(StubBaseInfo info) {
        this.info = info;
    }

    protected byte[] p4_makeInformMessage(byte finalize) {
        int keyLength = this.info.key.length;
        byte[] informMessage = new byte[24 + keyLength];
        informMessage[14] = -2;
        informMessage[15] = 0;
        informMessage[16] = 0;
        informMessage[17] = 0;
        informMessage[18] = 0;
        informMessage[19] = 0;
        informMessage[20] = 0;
        informMessage[21] = 0;
        informMessage[22] = 20;
        informMessage[23] = finalize;
        System.arraycopy(this.info.key, 0, informMessage, 24, keyLength);
        return informMessage;
    }

    public void p4_finalize() {
        if (this.info.connected && !this.isLocal) {
            try {
                byte[] inf = this.p4_makeInformMessage((byte)1);
                this.repliable.reply(this.info.server_id, this.info.local_id, this.info.client_id, inf, inf.length);
            }
            catch (P4IOException ioex) {
                this.broker.trace(class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl, ioex, "Can't send inform message.", "p4_finalize", 200);
            }
        }
    }

    public Object p4_replicate(Object obj) {
        return this.p4_initializeStreams(obj);
    }

    protected Object p4_initializeStreams(Object obj) {
        try {
            ByteArrayOutput bao = new ByteArrayOutput(0);
            ReplicateOutputStream out = new ReplicateOutputStream(bao);
            out.writeObject(obj);
            ReplicateInputStream in = new ReplicateInputStream(new ByteArrayInput(bao.getBuffer()), out);
            in.setClassLoader(this.getClass().getClassLoader());
            return in.readObject();
        }
        catch (Exception e) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl, e, "p4_initializeStreams", 100);
            throw (P4RuntimeException)this.broker.getException(1, "p4_0009", e, new Object[]{e.toString()});
        }
    }

    protected Object p4_replicateParameters(Object obj) {
        try {
            ByteArrayOutput bao = new ByteArrayOutput(0);
            ReplicateOutputStream out = new ReplicateOutputStream(bao);
            out.writeObject(obj);
            ReplicateInputStream in = new ReplicateInputStream(new ByteArrayInput(bao.getBuffer()), out);
            in.setClassLoader(this.p4remote.getDelegate().getClass().getClassLoader());
            return in.readObject();
        }
        catch (Exception e) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl, e, "p4_replicateParameters", 100);
            throw (P4RuntimeException)this.broker.getException(1, "p4_0009", e, new Object[]{e.toString()});
        }
    }

    protected Object p4_replicateWithStreams(ReplicateInputStream inn, ReplicateOutputStream outt, Object obj) {
        try {
            outt.writeObject(obj);
            outt.flush();
            inn.setClassLoader(this.p4remote.getDelegate().getClass().getClassLoader());
            inn.setArrayBuffer(outt.getBuffer());
            return inn.readObject();
        }
        catch (Exception e) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl, e, "p4_replicateWithStreams", 100);
            throw (P4RuntimeException)this.broker.getException(1, "p4_0009", e, new Object[]{e.toString()});
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StubImpl)) {
            return false;
        }
        StubImpl stub = (StubImpl)obj;
        if (this.isLocal && stub.isLocal) {
            return this.p4remote.getDelegate().equals(stub.p4remote.getDelegate());
        }
        if (!this.isLocal && !stub.isLocal) {
            if (!this.repliable.equals(stub.repliable)) {
                return false;
            }
            if (Arrays.equals(this.info.connectionProfiles, stub.info.connectionProfiles)) {
                return Arrays.equals(this.info.key, stub.info.key);
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.isLocal) {
            this.info.connectionProfiles = this.broker.getConnectionProfiles();
        }
        out.writeObject(this.connectionType);
        out.writeObject(this.info);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (this.broker == null) {
            this.broker = P4ObjectBroker.init();
        }
        this.connectionType = (String)in.readObject();
        if (this.connectionType == null) {
            this.connectionType = P4ObjectBroker.transportType;
        }
        this.info = (StubBaseInfo)in.readObject();
        this.info.connected = false;
        this.clLoader = this.getClass().getClassLoader();
        Class<?> stubClass = (class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl).getInterfaces()[0];
        this.broker.narrow(this, stubClass, this.connectionType);
    }

    public Object p4_invokeReflect(Object o, String name, Object[] params, Class[] p) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m = o.getClass().getMethod(name, p);
        return m.invoke(o, params);
    }

    public Object p4_invokeReflect(Object o, String name, Object[] params) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] p = new Class[]{};
        Method m = o.getClass().getMethod(name, p);
        return m.invoke(o, params);
    }

    public ReplicateInputStream p4_getReplicateInput(ReplicateOutputStream outt) {
        try {
            ReplicateInputStream inn = new ReplicateInputStream(new ByteArrayInput(outt.getBuffer()), outt);
            return inn;
        }
        catch (IOException ioe) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl, ioe, "p4_getReplicateInput", 100);
            throw (P4RuntimeException)this.broker.getException(1, "p4_0009", ioe, new Object[]{ioe.toString()});
        }
    }

    public ReplicateOutputStream p4_getReplicateOutput() {
        try {
            ByteArrayOutput baoo = new ByteArrayOutput(0);
            ReplicateOutputStream outt = new ReplicateOutputStream(baoo);
            return outt;
        }
        catch (IOException ioe) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl, ioe, "p4_getReplicateOutput", 100);
            throw (P4RuntimeException)this.broker.getException(1, "p4_0009", ioe, new Object[]{ioe.toString()});
        }
    }

    public void p4_setNewServerInfo(byte[] oKey, int cluster_id) {
        this.info.key = oKey;
        this.info.server_id = cluster_id;
    }

    public byte[] p4_getResourceData(String resourceName) throws FileNotFoundException, ClassNotFoundException {
        return this.p4_getData(resourceName, GET_RESOURCE_DATA);
    }

    public byte[] p4_getClassData(String className) throws FileNotFoundException, ClassNotFoundException {
        return this.p4_getData(className, GET_CLASS_DATA);
    }

    public byte[] p4_getData(String name, String operation) throws FileNotFoundException, ClassNotFoundException {
        try {
            byte[] data;
            Call call = this.p4_newCall(operation);
            P4ObjectOutput out = call.getOutputStream();
            out.writeObject(name);
            this.p4_invoke(call);
            P4ObjectInput in = call.getResultStream();
            byte[] allData = null;
            do {
                data = new byte[in.available()];
                int offset = 0;
                int readed = 0;
                while (offset < data.length) {
                    readed = in.read(data, offset, data.length - offset);
                    if (readed == -1) {
                        byte[] result = new byte[offset];
                        System.arraycopy(data, 0, result, 0, offset);
                        return result;
                    }
                    offset = data.length;
                }
                byte[] old = null;
                if (allData == null) {
                    allData = data;
                    continue;
                }
                old = allData;
                allData = new byte[old.length + data.length];
                System.arraycopy(old, 0, allData, 0, old.length);
                System.arraycopy(data, 0, allData, old.length, data.length);
            } while (in.available() > 0);
            data = allData;
            return data;
        }
        catch (ClassNotFoundException cnf) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl, cnf, "p4_getData", 100);
            throw cnf;
        }
        catch (FileNotFoundException fnf) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl, fnf, "p4_getData", 100);
            throw fnf;
        }
        catch (Exception e) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$StubImpl == null ? (class$com$sap$engine$services$rmi_p4$StubImpl = StubImpl.class$("com.sap.engine.services.rmi_p4.StubImpl")) : class$com$sap$engine$services$rmi_p4$StubImpl, e, "p4_getData", 100);
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)stringWriter, true));
            throw new ClassNotFoundException(name + ".\n" + stringWriter.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

