/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.ByteArrayInput;
import com.sap.engine.services.rmi_p4.Call;
import com.sap.engine.services.rmi_p4.Connection;
import com.sap.engine.services.rmi_p4.DispatchImpl;
import com.sap.engine.services.rmi_p4.DispatchPool;
import com.sap.engine.services.rmi_p4.InitialCall;
import com.sap.engine.services.rmi_p4.MarshalInputStream;
import com.sap.engine.services.rmi_p4.Message;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4ParseRequestException;
import com.sap.engine.services.rmi_p4.ProtocolHeader;
import com.sap.engine.services.rmi_p4.StubImpl;
import com.sap.engine.services.rmi_p4.monitor.PingCall;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.Enumeration;

public class Parser {
    private byte[] ping_reply = new byte[]{0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0};
    public static Parser parser;
    public P4ObjectBroker broker = P4ObjectBroker.init();
    private DispatchPool pool = new DispatchPool();
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$Parser;

    public static Parser getParser() {
        if (parser == null) {
            parser = new Parser();
        }
        return parser;
    }

    private Parser() {
    }

    public static void close() {
        if (parser != null) {
            Parser.parser.pool.stopWork();
        }
        InitialCall.clear();
        parser = null;
    }

    public void disposeConnection(Connection con, Exception ex) {
        Enumeration enumeration = Call.getAllCalls();
        while (enumeration.hasMoreElements()) {
            Call call = (Call)enumeration.nextElement();
            StubImpl stubImpl = call.stub;
            synchronized (stubImpl) {
                if (call.stub.repliable.equals(con)) {
                    call.setException(ex);
                }
            }
        }
        InitialCall.freeConnection(con, ex);
        this.broker.disposeConnection(con);
    }

    public byte[] getHeader(int server_id, byte[] reply) {
        ProtocolHeader header = new ProtocolHeader();
        header.server_id = server_id;
        header.size = reply != null ? reply.length : 0;
        return header.toByteArray();
    }

    public void init(Connection con) {
        con.request = con.headerBuffer;
    }

    public byte[] getCloseRequest() {
        ProtocolHeader header = new ProtocolHeader();
        header.size = 0;
        return header.toByteArray();
    }

    public void newRequest(Connection con) throws P4ParseRequestException {
        if (con.newSession) {
            ProtocolHeader header = new ProtocolHeader();
            header.loadFromByteArray(con.request);
            if (header.size <= 0) {
                this.broker.trace(class$com$sap$engine$services$rmi_p4$Parser == null ? (class$com$sap$engine$services$rmi_p4$Parser = Parser.class$("com.sap.engine.services.rmi_p4.Parser")) : class$com$sap$engine$services$rmi_p4$Parser, "Invalid message - header size is :" + header.size, "newRequest", 500);
                throw (P4ParseRequestException)this.broker.getException(5, "p4_0023", null, new Object[]{new Integer(header.size)});
            }
            con.request = new byte[header.size];
            con.newSession = false;
            con.clusterElementId = header.server_id;
        } else {
            Message msg = new Message(con.clusterElementId, -1, con.request, con);
            if (msg.type == 1) {
                Call call = Call.getCall(msg.getCallId());
                if (call != null) {
                    call.setReply(msg);
                }
            } else if (msg.type == 2) {
                InitialCall initCall;
                Call call = Call.getCall(msg.getCallId());
                if (call != null) {
                    call.setException(msg);
                }
                if ((initCall = InitialCall.getCall(msg.getCallId())) != null) {
                    Exception ex = null;
                    if (msg.request != null) {
                        try {
                            MarshalInputStream in = new MarshalInputStream(new ByteArrayInput(msg.request, 13, msg.request.length - 13));
                            ex = (Exception)in.readObject();
                        }
                        catch (ClassNotFoundException cnf) {
                            this.broker.trace(class$com$sap$engine$services$rmi_p4$Parser == null ? (class$com$sap$engine$services$rmi_p4$Parser = Parser.class$("com.sap.engine.services.rmi_p4.Parser")) : class$com$sap$engine$services$rmi_p4$Parser, cnf, "newRequest()", 100);
                            this.broker.trace(class$com$sap$engine$services$rmi_p4$Parser == null ? (class$com$sap$engine$services$rmi_p4$Parser = Parser.class$("com.sap.engine.services.rmi_p4.Parser")) : class$com$sap$engine$services$rmi_p4$Parser, "a problem with reading the original exception : " + cnf.getMessage(), "newRequest", 500);
                        }
                        catch (StreamCorruptedException e) {
                            this.broker.trace(class$com$sap$engine$services$rmi_p4$Parser == null ? (class$com$sap$engine$services$rmi_p4$Parser = Parser.class$("com.sap.engine.services.rmi_p4.Parser")) : class$com$sap$engine$services$rmi_p4$Parser, e, "newRequest()", 100);
                            this.broker.trace(class$com$sap$engine$services$rmi_p4$Parser == null ? (class$com$sap$engine$services$rmi_p4$Parser = Parser.class$("com.sap.engine.services.rmi_p4.Parser")) : class$com$sap$engine$services$rmi_p4$Parser, "a problem with reading the original exception : " + e.getMessage(), "newRequest", 500);
                        }
                        catch (IOException e) {
                            this.broker.trace(class$com$sap$engine$services$rmi_p4$Parser == null ? (class$com$sap$engine$services$rmi_p4$Parser = Parser.class$("com.sap.engine.services.rmi_p4.Parser")) : class$com$sap$engine$services$rmi_p4$Parser, e, "newRequest()", 100);
                            this.broker.trace(class$com$sap$engine$services$rmi_p4$Parser == null ? (class$com$sap$engine$services$rmi_p4$Parser = Parser.class$("com.sap.engine.services.rmi_p4.Parser")) : class$com$sap$engine$services$rmi_p4$Parser, "a problem with reading the original exception : " + e.getMessage(), "newRequest", 500);
                        }
                    }
                    initCall.setException(this.broker.getException(4, "p4_0011", ex));
                }
            } else if (msg.type == 3) {
                InitialCall initCall;
                Call call = Call.getCall(msg.getCallId());
                if (call != null) {
                    this.broker.trace(class$com$sap$engine$services$rmi_p4$Parser == null ? (class$com$sap$engine$services$rmi_p4$Parser = Parser.class$("com.sap.engine.services.rmi_p4.Parser")) : class$com$sap$engine$services$rmi_p4$Parser, "The possible problem is that there is no available working correctly server node. Check your working servers", "newRequest", 500);
                    call.setException(this.broker.getException(2, "p4_0028", null));
                }
                if ((initCall = InitialCall.getCall(msg.getCallId())) != null) {
                    this.broker.trace(class$com$sap$engine$services$rmi_p4$Parser == null ? (class$com$sap$engine$services$rmi_p4$Parser = Parser.class$("com.sap.engine.services.rmi_p4.Parser")) : class$com$sap$engine$services$rmi_p4$Parser, "The possible problem is that there is no available working correctly server node. Check your working servers", "newRequest", 500);
                    initCall.setException(this.broker.getException(2, "p4_0028", null));
                }
            } else if (msg.type == 4) {
                PingCall call = PingCall.getCall(msg.getCallId());
                if (call != null) {
                    call.set(msg);
                }
            } else if (msg.type == 5) {
                Convert.writeLongToByteArr(this.ping_reply, 6, msg.clusterEl_id);
                Convert.writeLongToByteArr(this.ping_reply, 14, msg.getCallId());
                try {
                    con.reply(msg.clusterEl_id, 0, this.ping_reply, this.ping_reply.length);
                }
                catch (Exception e) {
                    this.broker.trace(class$com$sap$engine$services$rmi_p4$Parser == null ? (class$com$sap$engine$services$rmi_p4$Parser = Parser.class$("com.sap.engine.services.rmi_p4.Parser")) : class$com$sap$engine$services$rmi_p4$Parser, e, "newRequest", 200);
                    e.printStackTrace();
                }
            } else if (msg.type == 11) {
                InitialCall call = InitialCall.getCall(msg.getCallId());
                if (call != null) {
                    call.set(msg);
                }
            } else {
                DispatchImpl disp = this.pool.getDispatch();
                if (disp != null) {
                    disp.setData(msg, this.broker, con);
                } else {
                    disp = new DispatchImpl(msg, this.broker, con);
                    disp.setPool(this.pool);
                    new Thread(disp).start();
                }
            }
            con.request = con.headerBuffer;
            con.newSession = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

