/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;

public class P4RuntimeException
extends RuntimeException {
    private Throwable ex = null;
    private Object[] args = null;
    private String msg = null;

    public P4RuntimeException() {
    }

    public P4RuntimeException(String str) {
        super(str);
        this.msg = str;
    }

    public P4RuntimeException(String str, Throwable t) {
        super(str);
        this.msg = str;
        this.ex = t;
    }

    public P4RuntimeException(String str, Throwable thr, Object[] args) {
        super(P4RuntimeException.getMessage(str, args));
        this.msg = str;
        this.ex = thr;
        this.args = args;
    }

    public String getMessage() {
        if (this.ex == null) {
            return super.getMessage();
        }
        return super.getMessage() + "Nested exception is: \n\t" + this.ex.toString();
    }

    public static String getMessage(String msg, Object[] args) {
        String message = msg;
        if (args != null && args.length > 0 && msg != null) {
            MessageFormat mf = new MessageFormat("");
            mf.applyPattern(msg);
            message = mf.format(args);
        }
        return message;
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.ex == null) {
            super.printStackTrace(pw);
        } else {
            PrintWriter printWriter = pw;
            synchronized (printWriter) {
                pw.println(this);
                this.ex.printStackTrace(pw);
            }
        }
    }

    public void printStackTrace(PrintStream ps) {
        if (this.ex == null) {
            super.printStackTrace(ps);
        } else {
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println(this);
                this.ex.printStackTrace(ps);
            }
        }
    }
}

