/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.lib.lang.ConvertTools;
import com.sap.engine.services.rmi_p4.ObjectEntry;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import java.lang.ref.WeakReference;

public class ObjectManager {
    public static final ConvertTools ct = new ConvertTools(false);
    private ObjectEntry[] entries;
    private ObjectEntry freeEntry;
    private int size;
    private int objectCount = 0;

    protected ObjectManager(int _initialSize) {
        this.size = _initialSize;
        this.entries = new ObjectEntry[_initialSize];
        this.entries[_initialSize - 1] = new ObjectEntry(_initialSize - 1, null);
        int i = _initialSize - 2;
        while (i >= 0) {
            this.entries[i] = new ObjectEntry(i, this.entries[i + 1]);
            --i;
        }
        this.freeEntry = this.entries[0];
    }

    public byte[] storeObject(P4RemoteObject _obj) {
        ++this.objectCount;
        ObjectEntry entry = null;
        ObjectManager objectManager = this;
        synchronized (objectManager) {
            if (this.freeEntry == null) {
                this.resizeUp();
            }
            entry = this.freeEntry;
            this.freeEntry = (ObjectEntry)this.freeEntry.reference;
        }
        return entry.setReference(new WeakReference<P4RemoteObject>(_obj));
    }

    public synchronized void deleteObject(P4RemoteObject _obj) {
        --this.objectCount;
        int position = ct.arrToInt(_obj.getInfo().key, 0);
        int counter = ct.arrToInt(_obj.getInfo().key, 4);
        if (counter == this.entries[position].counter && this.entries[position].valid) {
            this.freeEntry = this.entries[position].delete(this.freeEntry);
        }
    }

    public P4RemoteObject getObject(byte[] _key) {
        int position = ct.arrToInt(_key, 0);
        int counter = ct.arrToInt(_key, 4);
        if (position < this.entries.length && counter == this.entries[position].counter && this.entries[position].valid) {
            return (P4RemoteObject)((WeakReference)this.entries[position].reference).get();
        }
        return null;
    }

    public void addLink(byte[] _key) {
        int position = ct.arrToInt(_key, 0);
        int counter = ct.arrToInt(_key, 4);
        ObjectEntry objectEntry = this.entries[position];
        synchronized (objectEntry) {
            if (counter == this.entries[position].counter && this.entries[position].valid) {
                ++this.entries[position].links;
                this.entries[position].referent = ((WeakReference)this.entries[position].reference).get();
            }
        }
    }

    public void inform(Object _identifer, byte[] _array) {
        try {
            int position = ct.arrToInt(_array, 1);
            int counter = ct.arrToInt(_array, 5);
            ObjectEntry objectEntry = this.entries[position];
            synchronized (objectEntry) {
                if (counter == this.entries[position].counter && this.entries[position].valid) {
                    if (_array[0] == 0) {
                        this.entries[position].increaseLinksInStatistics(_identifer, 1);
                    } else if (_array[0] == 1) {
                        this.entries[position].decreaseLinksInStatistics(_identifer, 1);
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
    }

    public void disposeConnection(Object _connection) {
        int i = -1;
        while (true) {
            ObjectManager objectManager = this;
            synchronized (objectManager) {
                if (++i >= this.size) {
                    break;
                }
            }
            this.entries[i].disposeConnection(_connection);
        }
    }

    private void resizeUp() {
        int i = this.size;
        this.size *= 2;
        ObjectEntry[] temp = this.entries;
        this.entries = new ObjectEntry[this.size];
        System.arraycopy(temp, 0, this.entries, 0, i);
        this.entries[this.size - 1] = new ObjectEntry(this.size - 1, null);
        int j = this.size - 2;
        while (j >= i) {
            this.entries[j] = new ObjectEntry(j, this.entries[j + 1]);
            --j;
        }
        this.freeEntry = this.entries[i];
    }

    public void collect() {
        ObjectManager objectManager = this;
        synchronized (objectManager) {
            long time = System.currentTimeMillis() - 1000L;
            int i = 0;
            while (i < this.entries.length) {
                ObjectEntry objectEntry = this.entries[i];
                synchronized (objectEntry) {
                    if (!this.entries[i].valid) {
                    } else if (this.entries[i].initialTime < time && this.entries[i].links <= 0 && this.entries[i].referent != null) {
                        this.entries[i].referent = null;
                    }
                }
                ++i;
            }
        }
        System.gc();
        ObjectManager objectManager2 = this;
        synchronized (objectManager2) {
            int i = 0;
            while (i < this.entries.length) {
                ObjectEntry objectEntry = this.entries[i];
                synchronized (objectEntry) {
                    if (!this.entries[i].valid) {
                    } else if (((WeakReference)this.entries[i].reference).get() == null) {
                        this.freeEntry = this.entries[i].delete(this.freeEntry);
                    }
                }
                ++i;
            }
        }
    }

    public ObjectEntry[] getEntries() {
        return this.entries;
    }

    public int getObjectCount() {
        return this.objectCount;
    }
}

