/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.lib.lang.ConvertTools;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import java.util.Hashtable;

public class ObjectEntry {
    public static final ConvertTools ct = new ConvertTools(false);
    public Object reference;
    protected Object referent;
    private int index;
    protected int counter = 0;
    protected boolean valid = false;
    private int currentLinks;
    public int links = 0;
    protected long initialTime = 0L;
    public Hashtable connectionStatistics = new Hashtable();

    protected ObjectEntry(int _index, Object _ref) {
        this.index = _index;
        this.reference = _ref;
    }

    public boolean isValid() {
        return this.valid;
    }

    protected synchronized void increaseLinksInStatistics(Object _obj, int _count) {
        Integer i;
        if (this.connectionStatistics.containsKey(_obj)) {
            i = (Integer)this.connectionStatistics.get(_obj);
            i = new Integer(i + _count);
        } else {
            i = new Integer(_count);
        }
        this.currentLinks += _count;
        this.connectionStatistics.put(_obj, i);
        if (this.currentLinks > this.links) {
            this.links += this.currentLinks - this.links;
        }
    }

    protected synchronized void decreaseLinksInStatistics(Object _obj, int _count) {
        if (this.connectionStatistics.containsKey(_obj)) {
            Integer i = (Integer)this.connectionStatistics.get(_obj);
            i = new Integer(i - _count);
            this.connectionStatistics.put(_obj, i);
            this.currentLinks -= _count;
            this.links -= _count;
        }
        if (this.links <= 0 && !P4ObjectBroker.getBroker().useReiterationOfGC) {
            this.referent = null;
        }
    }

    protected synchronized void disposeConnection(Object _key) {
        if (this.valid && this.connectionStatistics.containsKey(_key)) {
            Integer i = (Integer)this.connectionStatistics.get(_key);
            this.links -= i.intValue();
            this.connectionStatistics.remove(_key);
            if (this.connectionStatistics.isEmpty()) {
                this.links = 0;
            }
        }
        if (P4ObjectBroker.getBroker() != null && this.links <= 0 && !P4ObjectBroker.getBroker().useReiterationOfGC) {
            this.referent = null;
        }
    }

    protected synchronized byte[] setReference(Object _reference) {
        this.reference = _reference;
        this.valid = true;
        return this.getKey();
    }

    protected void setReferent(Object _referent) {
        this.referent = _referent;
        this.initialTime = System.currentTimeMillis();
        this.links = 0;
    }

    protected synchronized ObjectEntry delete(ObjectEntry _entry) {
        if (!this.valid) {
            return _entry;
        }
        this.valid = false;
        ++this.counter;
        this.connectionStatistics.clear();
        this.referent = null;
        this.reference = _entry;
        return this;
    }

    private byte[] getKey() {
        byte[] key = new byte[12];
        ct.intToArr(this.index, key, 0);
        ct.intToArr(this.counter, key, 4);
        return key;
    }
}

