/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.Call;
import com.sap.engine.services.rmi_p4.Connection;
import com.sap.engine.services.rmi_p4.Message;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.exception.P4BaseIOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class InitialCall {
    private static Hashtable calls = new Hashtable(33);
    private static long callId = 0L;
    private long id;
    private Message result;
    private Connection con;
    private Exception ex;
    private int dispId;
    private int clientId;

    InitialCall(long id) {
        this.id = id;
    }

    public int getDispId() {
        return this.dispId;
    }

    public void setDispId(int dispId) {
        this.dispId = dispId;
    }

    public int getClientId() {
        return this.clientId;
    }

    public void setClientId(int clientId) {
        this.clientId = clientId;
    }

    public synchronized void setException(Exception ex) {
        this.ex = ex;
        this.notify();
    }

    public synchronized byte[] getResult(Connection con) throws InterruptedException, P4IOException, Exception {
        this.con = con;
        if (this.result == null && (con == null || con.isAlive())) {
            try {
                this.wait(Call.TIMEOUT);
            }
            catch (InterruptedException iex) {
                throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Interrupted_While_Wait_Message, iex);
            }
        }
        if (this.ex != null) {
            throw this.ex;
        }
        if (this.result == null) {
            if (this.con != null && this.con.request != null && this.con.request.length == 4) {
                throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Object_Doesnot_Exist, this.ex);
            }
            throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Connection_lost, this.ex);
        }
        return this.result.getUnmarshaledRequest();
    }

    public synchronized void set(Message result) {
        this.result = result;
        this.notify();
    }

    public void writeId(byte[] where, int off) {
        Convert.writeLongToByteArr(where, 14, this.id);
    }

    public void remove() {
        Long ID = new Long(this.id);
        calls.remove(ID);
    }

    protected static void clear() {
        calls.clear();
        callId = 0L;
    }

    protected static void freeConnection(Connection con, Exception ex) {
        InitialCall call = null;
        Enumeration enumeration = calls.elements();
        while (enumeration.hasMoreElements()) {
            call = (InitialCall)enumeration.nextElement();
            if (call.con == null || !call.con.equals(con)) continue;
            call.setException(ex);
            call.remove();
        }
    }

    public static synchronized InitialCall getInitialCall() {
        InitialCall call = new InitialCall(callId);
        calls.put(new Long(callId++), call);
        return call;
    }

    public static InitialCall getCall(long id) {
        Long ID = new Long(id);
        InitialCall call = (InitialCall)calls.get(ID);
        calls.remove(ID);
        return call;
    }

    public static Enumeration getAllCalls() {
        return calls.elements();
    }
}

