/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.services.rmi_p4.DispatchImpl;

public class DispatchPool {
    public static final int NORMAL_SIZE = 5;
    public static final int MAX_SIZE = 50;
    public static final int INCREASE_CAPACITY = 5;
    private DispatchImpl[] pool = new DispatchImpl[5];
    private int current = 0;

    public DispatchPool() {
        while (this.current < 5) {
            this.pool[this.current] = new DispatchImpl(this);
            Thread th = new Thread(this.pool[this.current]);
            th.setDaemon(true);
            th.start();
            ++this.current;
        }
    }

    public synchronized DispatchImpl getDispatch() {
        if (this.current <= 0) {
            return null;
        }
        return this.pool[--this.current];
    }

    protected synchronized boolean returnInPool(DispatchImpl cc) {
        if (this.current >= this.pool.length) {
            if (this.pool.length < 50) {
                DispatchImpl[] newPool = new DispatchImpl[50 <= 5 + this.pool.length ? 50 : 5 + this.pool.length];
                System.arraycopy(this.pool, 0, newPool, 0, this.pool.length);
                this.pool = newPool;
                Object var2_2 = null;
            } else {
                return false;
            }
        }
        this.pool[this.current++] = cc;
        return true;
    }

    public void stopWork() {
        int i = 0;
        while (i < this.pool.length) {
            DispatchImpl dispatchImpl = this.pool[i];
            synchronized (dispatchImpl) {
                this.pool[i].running = false;
                this.pool[i].notifyAll();
            }
            ++i;
        }
    }
}

