/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.Connection;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.exception.P4BaseIOException;
import com.sap.engine.transport.ClientPortsManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;

public class ConnectionManager
implements Runnable {
    public static ConnectionManager manager;
    public boolean isRunning = true;
    public P4ObjectBroker broker;
    public Hashtable connections = new Hashtable(101);
    public ServerSocket ss;
    public int port = 0;
    public byte[] host = null;
    public String hostName;
    public String hostNameIP;
    public String hosts;
    public static ClientPortsManager portsManager;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$ConnectionManager;

    public ConnectionManager(P4ObjectBroker broker) throws IOException {
        this(broker, 0);
    }

    public ConnectionManager(P4ObjectBroker broker, int serPort) throws IOException {
        this.broker = broker;
        this.ss = !P4ObjectBroker.transportType.equals("None") ? portsManager.getRealServerSocket(serPort == 0 ? this.port : serPort, P4ObjectBroker.transportType) : new ServerSocket(serPort == 0 ? this.port : serPort);
        this.port = this.ss.getLocalPort();
        try {
            this.hostNameIP = InetAddress.getLocalHost().getHostAddress();
            this.hostName = InetAddress.getLocalHost().getHostName();
            this.hosts = new String();
            InetAddress[] multi = InetAddress.getAllByName(this.hostName);
            int i = 0;
            while (i < multi.length) {
                this.hosts = this.hosts + multi[i].getHostAddress() + "@";
                ++i;
            }
            this.host = new byte[2 * this.hosts.length()];
            Convert.writeUStringToByteArr(this.host, 0, this.hosts);
        }
        catch (UnknownHostException unknownHost) {
            try {
                this.hostNameIP = InetAddress.getByName("127.0.0.1").getHostAddress();
                this.hostName = InetAddress.getByName(this.hostNameIP).getHostName();
                this.hosts = new String();
                InetAddress[] multi = InetAddress.getAllByName(this.hostName);
                int i = 0;
                while (i < multi.length) {
                    this.hosts = this.hosts + multi[i].getHostAddress() + "@";
                    ++i;
                }
                this.host = new byte[2 * this.hosts.length()];
                Convert.writeUStringToByteArr(this.host, 0, this.hosts);
            }
            catch (UnknownHostException unHost) {
                broker.trace(class$com$sap$engine$services$rmi_p4$ConnectionManager == null ? (class$com$sap$engine$services$rmi_p4$ConnectionManager = ConnectionManager.class$("com.sap.engine.services.rmi_p4.ConnectionManager")) : class$com$sap$engine$services$rmi_p4$ConnectionManager, "P4ObjectBrokerClient Impl: Error in getting local host address.", "ConnectionManager", 100);
                broker.trace(class$com$sap$engine$services$rmi_p4$ConnectionManager == null ? (class$com$sap$engine$services$rmi_p4$ConnectionManager = ConnectionManager.class$("com.sap.engine.services.rmi_p4.ConnectionManager")) : class$com$sap$engine$services$rmi_p4$ConnectionManager, unHost, "ConnectionManager", 100);
                throw new IOException("P4ObjectBrokerClient Impl: Error in getting local host address.");
            }
        }
    }

    public static synchronized ConnectionManager getManager(P4ObjectBroker broker) {
        return ConnectionManager.getManager(broker, 0);
    }

    public static synchronized ConnectionManager getManager(P4ObjectBroker broker, int port) {
        if (manager != null) {
            return manager;
        }
        try {
            manager = port == 0 ? new ConnectionManager(broker) : new ConnectionManager(broker, port);
            Thread thr = new Thread(manager);
            thr.setDaemon(true);
            thr.start();
        }
        catch (Exception ex) {
            broker.trace(class$com$sap$engine$services$rmi_p4$ConnectionManager == null ? (class$com$sap$engine$services$rmi_p4$ConnectionManager = ConnectionManager.class$("com.sap.engine.services.rmi_p4.ConnectionManager")) : class$com$sap$engine$services$rmi_p4$ConnectionManager, ex, "getManager", 100);
            return null;
        }
        return manager;
    }

    public Connection getConnection(String type, String host, int port) throws P4IOException {
        Connection con = null;
        try {
            StringBuffer _id = new StringBuffer(type);
            _id.append(":");
            _id.append(host);
            _id.append(":");
            _id.append(port);
            String id1 = _id.toString();
            String id = "";
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                con = (Connection)this.connections.get(id1);
                if (con == null || !con.isAlive()) {
                    Socket s = this.getSocket(type, host, port);
                    _id = new StringBuffer(type);
                    _id.append(":");
                    _id.append(this.hostNameIP);
                    _id.append(":");
                    _id.append(this.port);
                    id = _id.toString();
                    con = new Connection(s, id.getBytes(), type);
                    Thread thr = new Thread(con);
                    thr.setDaemon(true);
                    thr.start();
                    this.connections.put(id1, con);
                }
            }
        }
        catch (Exception ex) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$ConnectionManager == null ? (class$com$sap$engine$services$rmi_p4$ConnectionManager = ConnectionManager.class$("com.sap.engine.services.rmi_p4.ConnectionManager")) : class$com$sap$engine$services$rmi_p4$ConnectionManager, ex, "getConnection", 100);
            throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Unable_to_Open_Connection, ex, new Object[]{host, new Integer(port).toString()});
        }
        return con;
    }

    public Connection takeConnection(String type, String host, int port) throws P4IOException {
        StringBuffer _id = new StringBuffer(type);
        _id.append(":");
        _id.append(host);
        _id.append(":");
        _id.append(port);
        String id = _id.toString();
        return (Connection)this.connections.get(id);
    }

    public void closeConnections() {
        Collection c = this.connections.values();
        Object[] connections_ = c.toArray();
        int i = 0;
        while (i < connections_.length) {
            ((Connection)connections_[i]).close();
            ++i;
        }
        this.connections.clear();
    }

    public void close() {
        this.isRunning = false;
        try {
            this.ss.close();
        }
        catch (Exception e) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$ConnectionManager == null ? (class$com$sap$engine$services$rmi_p4$ConnectionManager = ConnectionManager.class$("com.sap.engine.services.rmi_p4.ConnectionManager")) : class$com$sap$engine$services$rmi_p4$ConnectionManager, e, "close", 100);
        }
        this.closeConnections();
        manager = null;
    }

    public String getTransportProtokol() {
        return P4ObjectBroker.transportType;
    }

    public Socket getSocket(String _type, String host, int port) throws IOException {
        Socket s = !_type.equals("") && !_type.equalsIgnoreCase("None") ? portsManager.getRealSocket(host, port, _type, P4ObjectBroker.props) : new Socket(host, port);
        return s;
    }

    protected synchronized void removeConnection(Connection c) {
        Enumeration enumeration = this.connections.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!c.equals(this.connections.get(key))) continue;
            this.connections.remove(key);
        }
    }

    public void run() {
        while (this.isRunning) {
            try {
                Socket socket = this.ss.accept();
                if (!this.isRunning) {
                    socket.close();
                }
                StringBuffer _id = new StringBuffer(P4ObjectBroker.transportType);
                _id.append(":");
                _id.append(this.hostNameIP);
                _id.append(":");
                _id.append(this.port);
                String id = _id.toString();
                Connection con = new Connection(socket, id.getBytes(), P4ObjectBroker.transportType);
                this.connections.put(con.connectionId, con);
                Thread thr = new Thread(con);
                thr.setDaemon(true);
                thr.start();
            }
            catch (IOException ioex) {
                this.broker.trace(class$com$sap$engine$services$rmi_p4$ConnectionManager == null ? ConnectionManager.class$("com.sap.engine.services.rmi_p4.ConnectionManager") : class$com$sap$engine$services$rmi_p4$ConnectionManager, ioex, "run", 200);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        portsManager = new ClientPortsManager();
    }
}

