/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.frame.core.thread.ContextObject;
import com.sap.engine.frame.core.thread.ContextObjectNameIterator;
import com.sap.engine.frame.core.thread.Transferable;
import com.sap.engine.frame.core.thread.TransferableExt;
import com.sap.engine.services.rmi_p4.Message;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.Parser;
import com.sap.engine.services.rmi_p4.ProtocolHeader;
import com.sap.engine.services.rmi_p4.Repliable;
import com.sap.engine.services.rmi_p4.exception.P4BaseIOException;
import com.sap.engine.services.rmi_p4.monitor.PingCall;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;

public class Connection
implements Runnable,
Repliable {
    private boolean isAlive = false;
    public Socket socket;
    public InputStream in;
    public OutputStream out;
    public byte[] request;
    protected byte[] headerBuffer = new byte[14];
    public Parser parser;
    protected static byte[] MAGIC = new byte[]{35, 112, 35, 52};
    public String connectionId;
    public String destinationId;
    public String underlyingProfile;
    public boolean newSession = true;
    public int clusterElementId = -1;
    public String host = null;
    public int port;
    public String type;
    static int INITIALIZE_CONNECTION_TIMEOUT = 30000;
    static int RUNTIME_CONNECTION_TIMEOUT = 180000;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$Connection;

    protected Connection() {
    }

    public Connection(Socket socket, byte[] connId, String type) throws IOException {
        if (type == null || type.equals("")) {
            type = "None";
        }
        this.isAlive = true;
        this.socket = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.connectionId = new String(connId);
        this.type = type;
        this.port = socket.getPort();
        this.host = socket.getInetAddress().getHostAddress();
        this.initialize(connId);
        this.parser = Parser.getParser();
        this.parser.init(this);
    }

    protected void initialize() throws IOException {
        this.initialize(this.connectionId.getBytes());
    }

    protected void initialize(byte[] connId) throws IOException {
        this.out.write(P4ObjectBroker.PROTOCOL_VERSION);
        this.out.write((byte)connId.length + 4);
        this.out.write(MAGIC);
        this.out.write(connId);
        int b = 2;
        byte[] body = null;
        this.socket.setSoTimeout(INITIALIZE_CONNECTION_TIMEOUT);
        int i = 0;
        while (i < 2) {
            int count = 0;
            body = new byte[b];
            int read = 0;
            while (count != b) {
                try {
                    read = this.in.read(body, count, b - count);
                }
                catch (InterruptedIOException stex) {
                    this.in.close();
                    this.socket.close();
                    throw new IOException("Connection timeout! Probably connection port is wrong or server is hanged down!");
                }
                if (read == -1) {
                    this.in.close();
                    this.socket.close();
                    P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$Connection == null ? (class$com$sap$engine$services$rmi_p4$Connection = Connection.class$("com.sap.engine.services.rmi_p4.Connection")) : class$com$sap$engine$services$rmi_p4$Connection, "Cannot make connection. The stream is closed 1", "initialize", 200);
                    throw (IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Cannot_Make_Connection, null);
                }
                count += read;
            }
            switch (i) {
                case 0: {
                    if (body[0] != P4ObjectBroker.PROTOCOL_VERSION[0] || body[1] != P4ObjectBroker.PROTOCOL_VERSION[1]) {
                        this.in.close();
                        this.socket.close();
                        P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$Connection == null ? (class$com$sap$engine$services$rmi_p4$Connection = Connection.class$("com.sap.engine.services.rmi_p4.Connection")) : class$com$sap$engine$services$rmi_p4$Connection, "Cannot make connection. The stream is closed. The protocol version is not correct", "initialize", 200);
                        throw (IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Cannot_Make_Connection, null);
                    }
                    b = (byte)this.in.read();
                    if (b != -1) break;
                    this.in.close();
                    this.socket.close();
                    P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$Connection == null ? (class$com$sap$engine$services$rmi_p4$Connection = Connection.class$("com.sap.engine.services.rmi_p4.Connection")) : class$com$sap$engine$services$rmi_p4$Connection, "Cannot make connection. The stream is closed. Read from the socket msg for closing.", "initialize", 200);
                    throw (IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Cannot_Make_Connection, null);
                }
                case 1: {
                    if (body[0] == 35 && body[1] == 112 && body[2] == 35 && body[3] == 52) break;
                    this.in.close();
                    this.socket.close();
                    P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$Connection == null ? (class$com$sap$engine$services$rmi_p4$Connection = Connection.class$("com.sap.engine.services.rmi_p4.Connection")) : class$com$sap$engine$services$rmi_p4$Connection, "Cannot make connection. The stream is closed. The header which indicate p4 communication isn't correct.", "initialize", 200);
                    throw (IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Cannot_Make_Connection, null);
                }
            }
            ++i;
        }
        this.socket.setSoTimeout(RUNTIME_CONNECTION_TIMEOUT);
        this.destinationId = new String(body, 4, body.length - 4);
        this.connectionId = this.getConnectionId(this.host, this.port, this.type);
        if (!(P4ObjectBroker.init().NATEnabled() && !this.type.equals("SAPRouter") || this.connectionId.substring(this.connectionId.indexOf(58)).equalsIgnoreCase(this.destinationId.substring(this.destinationId.indexOf(58))))) {
            P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$Connection == null ? (class$com$sap$engine$services$rmi_p4$Connection = Connection.class$("com.sap.engine.services.rmi_p4.Connection")) : class$com$sap$engine$services$rmi_p4$Connection, "The connectionId does not match the destinationId but NAT support is disabled. Trace: connectionId=" + this.connectionId + ", destinationId=" + this.destinationId + "}", "initialize", 100);
            throw new IOException("The connectionId does not match the destinationId but NAT support is disabled.");
        }
    }

    public synchronized boolean isAlive() {
        return this.isAlive;
    }

    public synchronized void reply(int server_id, int client_id, byte[] reply) throws P4IOException {
        if (!this.isAlive) {
            throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Not_alive_connection, null);
        }
        int headerSize = 14;
        byte[] all = new byte[headerSize + reply.length];
        ProtocolHeader.writeHeader(all, 0, reply.length, server_id);
        System.arraycopy(reply, 0, all, headerSize, reply.length);
        try {
            this.out.write(all);
            this.out.flush();
        }
        catch (IOException ex) {
            P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$Connection == null ? (class$com$sap$engine$services$rmi_p4$Connection = Connection.class$("com.sap.engine.services.rmi_p4.Connection")) : class$com$sap$engine$services$rmi_p4$Connection, ex, "reply", 100);
            this.close(ex);
            throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.IO_error_occurs, ex);
        }
    }

    public synchronized void reply(int server_id, int sender_id, int client_id, byte[] reply, int size) throws P4IOException {
        this.reply(server_id, client_id, reply, size);
    }

    public synchronized void reply(int server_id, int client_id, byte[] reply, int size) throws P4IOException {
        if (!this.isAlive) {
            throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Not_alive_connection, null);
        }
        int headerSize = 14;
        ProtocolHeader.writeHeader(reply, 0, size - headerSize, server_id);
        try {
            this.out.write(reply, 0, size);
            this.out.flush();
        }
        catch (IOException ex) {
            P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$Connection == null ? (class$com$sap$engine$services$rmi_p4$Connection = Connection.class$("com.sap.engine.services.rmi_p4.Connection")) : class$com$sap$engine$services$rmi_p4$Connection, ex, "reply", 100);
            this.close(ex);
            throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.IO_error_occurs, ex);
        }
    }

    public synchronized void reply(Message msg, byte[] reply) throws P4IOException {
        if (!this.isAlive) {
            throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Not_alive_connection, null);
        }
        int headerSize = 14;
        byte[] all = new byte[headerSize + reply.length];
        ProtocolHeader.writeHeader(all, 0, reply.length, msg.clusterEl_id);
        System.arraycopy(reply, 0, all, headerSize, reply.length);
        try {
            this.out.write(all);
            this.out.flush();
        }
        catch (IOException ex) {
            P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$Connection == null ? (class$com$sap$engine$services$rmi_p4$Connection = Connection.class$("com.sap.engine.services.rmi_p4.Connection")) : class$com$sap$engine$services$rmi_p4$Connection, ex, "reply", 100);
            this.close(ex);
            throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.IO_error_occurs, ex);
        }
    }

    public synchronized void close() {
        try {
            this.socket.shutdownInput();
            this.socket.close();
            this.isAlive = false;
        }
        catch (Exception ex) {
            P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$Connection == null ? (class$com$sap$engine$services$rmi_p4$Connection = Connection.class$("com.sap.engine.services.rmi_p4.Connection")) : class$com$sap$engine$services$rmi_p4$Connection, ex, "close", 100);
            this.isAlive = false;
        }
    }

    public void close(Exception ex) {
        this.close();
        this.parser.disposeConnection(this, ex);
    }

    public void run() {
        boolean pingTimeout = false;
        while (this.isAlive) {
            try {
                int size = this.request.length;
                int readed = 0;
                for (int sum = 0; sum != size && readed >= 0; sum += readed) {
                    try {
                        readed = this.in.read(this.request, sum, size - sum);
                    }
                    catch (InterruptedIOException ste) {
                        if (ste.getClass().getName().indexOf("SocketTimeoutException") == -1) {
                            throw ste;
                        }
                        if (pingTimeout) {
                            P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$Connection == null ? (class$com$sap$engine$services$rmi_p4$Connection = Connection.class$("com.sap.engine.services.rmi_p4.Connection")) : class$com$sap$engine$services$rmi_p4$Connection, "Ping timeout exceeded while waiting for input from " + this.socket.toString(), "run", 300);
                            throw new IOException("Ping timeout exceeded while waiting for input from " + this.socket.toString());
                        }
                        pingTimeout = true;
                        PingCall pingCall = PingCall.getPingCall();
                        byte[] message = new byte[25];
                        pingCall.writeId(message, 14);
                        message[22] = 4;
                        this.reply(1111, 1111, message, message.length);
                    }
                    pingTimeout = false;
                    if (readed != -1) {
                        continue;
                    }
                    P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$Connection == null ? (class$com$sap$engine$services$rmi_p4$Connection = Connection.class$("com.sap.engine.services.rmi_p4.Connection")) : class$com$sap$engine$services$rmi_p4$Connection, "End of stream is reached unexpectedly during input from " + this.socket.toString(), "run", 300);
                    throw new EOFException("End of stream is reached unexpectedly during input from " + this.socket.toString());
                }
                this.parser.newRequest(this);
            }
            catch (Exception ex) {
                P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$Connection == null ? (class$com$sap$engine$services$rmi_p4$Connection = Connection.class$("com.sap.engine.services.rmi_p4.Connection")) : class$com$sap$engine$services$rmi_p4$Connection, ex, "run", 100);
                this.close(ex);
                break;
            }
        }
    }

    public int getTCSize() {
        int tcSize = 0;
        int byteArrLen = 0;
        P4ObjectBroker p4 = P4ObjectBroker.init();
        ClientThreadContext ctc = p4.getCTC();
        try {
            ContextObjectNameIterator coIt = ctc.getTransferableContextObjectNames();
            tcSize += 2;
            while (coIt.hasNext()) {
                String n = coIt.nextName();
                tcSize += 2;
                tcSize += n.length();
                tcSize += 2;
                ContextObject co = ctc.getContextObject(n);
                byteArrLen = ((Transferable)((Object)co)).size();
                tcSize += byteArrLen;
            }
        }
        catch (Exception ex) {
            P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$Connection == null ? (class$com$sap$engine$services$rmi_p4$Connection = Connection.class$("com.sap.engine.services.rmi_p4.Connection")) : class$com$sap$engine$services$rmi_p4$Connection, ex, "getTCSize", 100);
            return tcSize;
        }
        return tcSize;
    }

    public int getTCSize(int owner_broker_id) {
        int tcSize = 0;
        int byteArrLen = 0;
        P4ObjectBroker p4 = P4ObjectBroker.init();
        ClientThreadContext ctc = p4.getCTC();
        try {
            ContextObjectNameIterator coIt = ctc.getTransferableContextObjectNames();
            while (coIt.hasNext()) {
                String n = coIt.nextName();
                ContextObject co = ctc.getContextObject(n);
                byteArrLen = n.equals("security") && co instanceof TransferableExt ? ((TransferableExt)((Object)co)).size(new Integer(owner_broker_id)) : ((Transferable)((Object)co)).size();
                tcSize = tcSize + 2 + n.length();
                tcSize = tcSize + 2 + byteArrLen;
            }
        }
        catch (Exception ex) {
            return tcSize;
        }
        return tcSize += 2;
    }

    public String getUnderlyingProfile() {
        return this.underlyingProfile;
    }

    private String getConnectionId(String host, int port, String type) {
        StringBuffer _id = new StringBuffer(type);
        _id.append(":");
        _id.append(host);
        _id.append(":");
        _id.append(port);
        return _id.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

