/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import com.sap.engine.services.log_configurator.admin.gui.ListRenderer;
import com.sap.engine.services.log_configurator.admin.gui.ListValues;
import com.sap.engine.services.log_configurator.admin.gui.LogFormatterPanel;
import com.sap.engine.services.log_configurator.admin.gui.SortedListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LogFormatterPanelLogical
extends JPanel
implements ActionListener,
ListSelectionListener {
    private LogFormatterPanel logFormatter = new LogFormatterPanel();
    private static final String NEW = "NEW";
    private static final String REMOVE = "REMOVE";
    private static final String CHANGE_TYPE = "CHANGE_TYPE";
    private JButton newButton;
    private JButton removeButton;
    private JList logList;
    private SortedListModel logModel = new SortedListModel();
    private LogConfiguration logConfig = null;
    private LogConfiguration addEditElements = null;
    private LogConfiguration removedElements = null;
    private int lastSelected = -1;

    public LogFormatterPanelLogical(boolean hasIcons) {
        try {
            this.init(hasIcons);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init(boolean hasIcons) throws Exception {
        this.newButton = new JButton("New");
        this.newButton.addActionListener(this);
        this.newButton.setActionCommand(NEW);
        this.logFormatter.buttonsPanel.add(this.newButton);
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(this);
        this.removeButton.setActionCommand(REMOVE);
        this.logFormatter.buttonsPanel.add(this.removeButton);
        this.logFormatter.typeComboBox.setActionCommand(CHANGE_TYPE);
        this.logFormatter.typeComboBox.addActionListener(this);
        JPanel logPanel = new JPanel();
        logPanel.setLayout(new BorderLayout());
        logPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Log Formatters"));
        this.logList = new JList(this.logModel);
        if (hasIcons) {
            this.logList.setCellRenderer(new ListRenderer());
        }
        this.logList.addListSelectionListener(this);
        this.logList.setSelectionMode(0);
        logPanel.add((Component)new JScrollPane(this.logList), "Center");
        JSplitPane splitter = new JSplitPane();
        splitter.setDividerLocation(200);
        splitter.setLeftComponent(logPanel);
        splitter.setRightComponent(this.logFormatter);
        this.setLayout(new BorderLayout());
        this.add((Component)splitter, "Center");
        this.removeButton.setEnabled(false);
        this.checkEnable();
    }

    public void init(int madeFromConstant) {
    }

    public void clear() {
        this.logFormatter.clear();
        this.logList.clearSelection();
        this.removeButton.setEnabled(false);
        this.checkEnable();
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        this.valueChanged(null);
        this.logConfig.setLogFormatters(null);
        if (this.logModel.size() != 0) {
            int i = 0;
            while (i < this.logModel.size()) {
                if (((ListValues)this.logModel.getElementAt(i)).getLogFormatter() != null) {
                    this.logConfig.addLogFormatter(((ListValues)this.logModel.getElementAt(i)).getLogFormatter());
                }
                ++i;
            }
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(NEW)) {
            this.addAction();
        } else if (cmd.equals(REMOVE)) {
            this.removeAction();
            this.clear();
        } else if (cmd.equals(CHANGE_TYPE)) {
            this.checkTraceFormatter();
        }
    }

    private void addAction() {
        this.logList.clearSelection();
        String newName = JOptionPane.showInputDialog(this.logFormatter, "New formatter name:", "New formatter", 3);
        if (newName != null) {
            if (newName.trim().equals("")) {
                JOptionPane.showMessageDialog(this.logFormatter, "Can not create formatter without name!", "Error", 0);
            } else {
                this.logFormatter.nameTextField.setText(newName);
                if (this.containsInModel(newName) == -1) {
                    LogFormatterDescriptor formatter = this.logFormatter.getDescriptor(null);
                    this.addEditElements.addLogFormatter(formatter);
                    this.removedElements.removeLogFormatter(formatter.toString());
                    this.logModel.add(new ListValues(formatter, 1));
                }
                this.logList.setSelectedIndex(this.containsInModel(newName));
            }
        }
    }

    private void checkTraceFormatter() {
        String type = (String)this.logFormatter.typeComboBox.getSelectedItem();
        boolean enabled = false;
        if (type != null && type.equalsIgnoreCase("TraceFormatter")) {
            enabled = true;
        }
        this.logFormatter.patternTextField.setEnabled(enabled);
    }

    private void removeAction() {
        if (!this.logList.isSelectionEmpty()) {
            LogFormatterDescriptor removedFormatter = ((ListValues)this.logModel.getElementAt(this.lastSelected)).getLogFormatter();
            if (!this.checkUsage(removedFormatter.toString())) {
                return;
            }
            this.addEditElements.removeLogFormatter(removedFormatter.toString());
            this.removedElements.addLogFormatter(removedFormatter);
            LogDestinationDescriptor[] destinations = this.logConfig.getLogDestinations();
            int i = 0;
            while (i < destinations.length) {
                String name;
                LogFormatterDescriptor formatter = destinations[i].getFormatter();
                if (formatter != null && (name = formatter.toString()) != null && name.equals(removedFormatter.toString())) {
                    destinations[i].setFormatter(null);
                    this.addEditElements.removeLogDestination(destinations[i].toString());
                    this.addEditElements.addLogDestination(destinations[i]);
                }
                ++i;
            }
            this.lastSelected = -1;
            this.logModel.remove(this.logList.getSelectedIndex());
        }
    }

    private boolean checkUsage(String removedName) {
        LogDestinationDescriptor[] destinations = this.logConfig.getLogDestinations();
        int i = 0;
        while (i < destinations.length) {
            String name;
            LogFormatterDescriptor formatter = destinations[i].getFormatter();
            if (formatter != null && (name = formatter.toString()) != null && name.equals(removedName)) {
                return JOptionPane.showConfirmDialog(this.logFormatter, "The Log Formatter '" + removedName + "' is used by the Log Destination '" + destinations[i].toString() + "'.\nAre you sure you want to remove '" + removedName + "'?", "Warning", 0, 2) == 0;
            }
            ++i;
        }
        return true;
    }

    private int containsInModel(String logName) {
        int i = 0;
        while (i < this.logModel.size()) {
            if (((ListValues)this.logModel.getElementAt(i)).getLogFormatter().toString().equalsIgnoreCase(logName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void valueChanged(ListSelectionEvent e) {
        this.checkEnable();
        this.removeButton.setEnabled(true);
        LogFormatterDescriptor oldLogFormatter = null;
        if (this.lastSelected >= 0 && this.lastSelected < this.logModel.size()) {
            oldLogFormatter = ((ListValues)this.logModel.getElementAt(this.lastSelected)).getLogFormatter();
        }
        LogFormatterDescriptor newLogFormatter = this.logFormatter.getDescriptor(oldLogFormatter);
        if (oldLogFormatter != null && newLogFormatter != null && newLogFormatter.getName() != null && !newLogFormatter.getName().trim().equals("") && !oldLogFormatter.equals(newLogFormatter)) {
            ((ListValues)this.logModel.getElementAt(this.lastSelected)).setLogFormatter(newLogFormatter);
            this.addEditElements.removeLogFormatter(newLogFormatter.toString());
            this.addEditElements.addLogFormatter(newLogFormatter);
        }
        if (!this.logList.isSelectionEmpty()) {
            this.logFormatter.setDescriptor(((ListValues)this.logList.getSelectedValue()).getLogFormatter());
        } else {
            this.clear();
        }
        this.lastSelected = this.logList.getSelectedIndex();
    }

    public void setDescriptor(LogConfiguration descr, LogConfiguration addEditElements, LogConfiguration removedElements) {
        this.logConfig = descr;
        this.addEditElements = addEditElements;
        this.removedElements = removedElements;
        LogFormatterDescriptor[] logs = null;
        this.clear();
        this.logModel.clear();
        logs = this.logConfig.getLogFormatters();
        int i = 0;
        while (i < logs.length) {
            if (logs[i] != null) {
                this.logModel.add(new ListValues(logs[i], 1));
            }
            ++i;
        }
    }

    private void checkEnable() {
        boolean flag = !this.logFormatter.nameTextField.getText().trim().equals("");
        this.logFormatter.typeComboBox.setEnabled(flag);
        if (flag) {
            this.checkTraceFormatter();
        } else {
            this.logFormatter.patternTextField.setEnabled(false);
        }
    }

    public void setSelectedFormatter(ListValues lv) {
        String name = lv.getLogFormatter().toString();
        Iterator elements = ((AbstractList)((SortedListModel)this.logList.getModel()).getData()).iterator();
        while (elements.hasNext()) {
            ListValues element = (ListValues)elements.next();
            if (!element.getLogFormatter().toString().equals(name)) continue;
            this.logList.setSelectedValue(element, true);
        }
        this.checkEnable();
    }
}

