/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LogFormatterPanel
extends JPanel {
    public JPanel buttonsPanel = new JPanel();
    public JTextField patternTextField = new JTextField();
    public JTextField nameTextField = new JTextField();
    public JComboBox typeComboBox = new JComboBox<Object>(new Object[]{"ListFormatter", "TraceFormatter", "XMLFormatter"});
    public boolean selectWithMouse = true;
    public boolean setText = false;

    public LogFormatterPanel() {
        try {
            this.initPanel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initPanel() throws Exception {
        JLabel patternLabel = new JLabel("Pattern:");
        JLabel nameLabel = new JLabel("Name:");
        JLabel typeLabel = new JLabel("Type:");
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ""));
        this.buttonsPanel.setLayout(new FlowLayout());
        this.nameTextField.setEditable(false);
        this.typeComboBox.setEditable(true);
        int y = 1;
        this.add((Component)nameLabel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)patternLabel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)typeLabel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
        int i = 0;
        this.add((Component)this.nameTextField, new GridBagConstraints(2, i++, 1, 2, 0.1, 0.0, 10, 2, new Insets(10, 5, 5, 5), 0, 0));
        int n = ++i;
        this.add((Component)this.patternTextField, new GridBagConstraints(2, n, 2, 1, 0.1, 0.0, 10, 2, new Insets(10, 5, 5, 5), 0, 0));
        int n2 = ++i;
        this.add((Component)this.typeComboBox, new GridBagConstraints(2, n2, 2, 1, 0.1, 0.0, 10, 2, new Insets(10, 5, 5, 5), 0, 0));
        int n3 = ++i;
        ++i;
        this.add((Component)this.buttonsPanel, new GridBagConstraints(1, n3, 3, 1, 0.0, 0.0, 10, 0, new Insets(50, 0, 0, 0), 0, 0));
        this.setDescriptor(new LogFormatterDescriptor());
    }

    public void clear() {
        this.setDescriptor(null);
    }

    public void setDescriptor(LogFormatterDescriptor descr) {
        if (descr == null) {
            descr = new LogFormatterDescriptor();
        }
        if (this.selectWithMouse) {
            this.setText = true;
            this.nameTextField.setText(descr.toString());
            this.setText = false;
        }
        this.patternTextField.setText(descr.getPattern());
        this.typeComboBox.getModel().setSelectedItem(descr.getType());
    }

    public LogFormatterDescriptor getDescriptor(LogFormatterDescriptor oldDescriptor) {
        LogFormatterDescriptor descr = new LogFormatterDescriptor();
        if (this.nameTextField.getText().equals("")) {
            return descr;
        }
        if (oldDescriptor != null) {
            descr.setName(oldDescriptor.getName());
            descr.setPrefix(oldDescriptor.getPrefix());
            descr.setPersistenceAdapter(oldDescriptor.getPersistenceAdapter());
        } else {
            descr.setName(this.nameTextField.getText().trim().equals("") ? null : this.nameTextField.getText().trim());
        }
        descr.setPattern(this.patternTextField.getText().trim().equals("") ? null : this.patternTextField.getText().trim());
        String type = (String)this.typeComboBox.getSelectedItem();
        if (type != null) {
            descr.setType((type = type.trim()).equals("") ? null : type);
        }
        return descr;
    }
}

