/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.services.log_configurator.admin.gui.GeneralLogControllerPanel;
import com.sap.engine.services.log_configurator.admin.gui.ListRenderer;
import com.sap.engine.services.log_configurator.admin.gui.ListValues;
import com.sap.engine.services.log_configurator.admin.gui.LogDestinationNewPanel;
import com.sap.engine.services.log_configurator.admin.gui.LogDestinationPanel;
import com.sap.engine.services.log_configurator.admin.gui.SortedListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LogDestinationPanelLogical
extends JPanel
implements ActionListener,
ListSelectionListener {
    private LogDestinationPanel logDestination = null;
    private static final String NEW = "NEW";
    private static final String REMOVE = "REMOVE";
    private static final String CHANGE_TYPE = "CHANGE_TYPE";
    private JButton newButton;
    private JButton removeButton;
    private JList logList;
    private SortedListModel logModel = new SortedListModel();
    private LogConfiguration logConfig = null;
    private LogConfiguration addEditElements = null;
    private LogConfiguration removedElements = null;
    private int lastSelected = -1;

    public LogDestinationPanelLogical(Frame frame, boolean hasIcons, GeneralLogControllerPanel mainPanel) {
        this.logDestination = new LogDestinationPanel(frame, hasIcons, mainPanel);
        try {
            this.init(hasIcons);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void init(boolean hasIcons) throws Exception {
        this.newButton = new JButton("New");
        this.newButton.addActionListener(this);
        this.newButton.setActionCommand(NEW);
        this.logDestination.buttonsPanel.add(this.newButton);
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(this);
        this.removeButton.setActionCommand(REMOVE);
        this.logDestination.buttonsPanel.add(this.removeButton);
        this.logDestination.typeComboBox.setActionCommand(CHANGE_TYPE);
        this.logDestination.typeComboBox.addActionListener(this);
        JPanel logPanel = new JPanel();
        logPanel.setLayout(new BorderLayout());
        logPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Log Destinations"));
        this.logList = new JList(this.logModel);
        if (hasIcons) {
            this.logList.setCellRenderer(new ListRenderer());
        }
        this.logList.addListSelectionListener(this);
        this.logList.setSelectionMode(0);
        logPanel.add((Component)new JScrollPane(this.logList), "Center");
        JSplitPane splitter = new JSplitPane();
        splitter.setDividerLocation(200);
        splitter.setLeftComponent(logPanel);
        splitter.setRightComponent(new JScrollPane(this.logDestination));
        this.setLayout(new BorderLayout());
        this.add((Component)splitter, "Center");
        this.removeButton.setEnabled(false);
        this.checkEnable();
        this.setAdvancedMode(true);
    }

    public void init(int madeFromConstant) {
    }

    public void clear() {
        this.logDestination.clear();
        this.logList.clearSelection();
        this.removeButton.setEnabled(false);
        this.checkEnable();
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        this.valueChanged(null);
        this.logConfig.setLogDestinations(null);
        if (this.logModel.size() != 0) {
            int i = 0;
            while (i < this.logModel.size()) {
                if (((ListValues)this.logModel.getElementAt(i)).getLogDestination() != null) {
                    this.logConfig.addLogDestination(((ListValues)this.logModel.getElementAt(i)).getLogDestination());
                }
                ++i;
            }
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(NEW)) {
            this.addAction();
        } else if (cmd.equals(REMOVE)) {
            this.removeAction();
            this.clear();
        } else if (cmd.equals(CHANGE_TYPE)) {
            this.checkFileLog();
        }
    }

    private void addAction() {
        this.logList.clearSelection();
        LogDestinationNewPanel destPanel = new LogDestinationNewPanel(false);
        while (JOptionPane.showConfirmDialog(this.logDestination, destPanel, "New destination", 2, 3) == 0) {
            String newName = destPanel.getName();
            if (newName == null || newName.trim().equals("")) {
                JOptionPane.showMessageDialog(this.logDestination, "Can not create destination without name!", "Error", 0);
                continue;
            }
            String newType = destPanel.getType();
            if (newType == null || newType.trim().equals("")) {
                JOptionPane.showMessageDialog(this.logDestination, "Can not create destination without type!", "Error", 0);
                continue;
            }
            String newPattern = destPanel.getPattern();
            if (newType.equalsIgnoreCase("FileLog") && (newPattern == null || newPattern.trim().equals(""))) {
                JOptionPane.showMessageDialog(this.logDestination, "Can not create File Log without pattern!", "Error", 0);
                continue;
            }
            this.logDestination.nameTextField.setText(newName);
            if (this.containsInModel(newName) == -1) {
                this.logDestination.typeComboBox.setSelectedItem(newType);
                this.logDestination.patternTextField.setText(newPattern);
                this.logDestination.limitScrollField.setValue(destPanel.getLimit());
                this.logDestination.countScrollField.setValue(destPanel.getCount());
                LogDestinationDescriptor destination = this.logDestination.getDescriptor(null);
                this.addEditElements.addLogDestination(destination);
                this.logModel.add(new ListValues(destination, 0));
            }
            this.logList.setSelectedIndex(this.containsInModel(newName));
            return;
        }
    }

    private void removeAction() {
        if (!this.logList.isSelectionEmpty()) {
            LogDestinationDescriptor removedDestination = ((ListValues)this.logModel.getElementAt(this.lastSelected)).getLogDestination();
            if (!this.checkUsage(removedDestination.toString())) {
                return;
            }
            this.addEditElements.removeLogDestination(removedDestination.toString());
            this.removedElements.addLogDestination(removedDestination);
            LogControllerDescriptor[] controllers = this.logConfig.getLogControllers();
            int i = 0;
            while (i < controllers.length) {
                Object[] destinations = controllers[i].getAssociatedDestinations().getAllKeys();
                int j = 0;
                while (j < destinations.length) {
                    LogDestinationDescriptor destination;
                    String name;
                    if (destinations[j] != null && (name = (destination = (LogDestinationDescriptor)destinations[j]).toString()) != null && name.equals(removedDestination.toString())) {
                        controllers[i].removeDestination(destination);
                        this.addEditElements.removeLogController(controllers[i].getName());
                        this.addEditElements.addLogController(controllers[i]);
                    }
                    ++j;
                }
                ++i;
            }
            this.lastSelected = -1;
            this.logModel.remove(this.logList.getSelectedIndex());
        }
    }

    private boolean checkUsage(String removedName) {
        LogControllerDescriptor[] controllers = this.logConfig.getLogControllers();
        int i = 0;
        while (i < controllers.length) {
            Object[] destinations = controllers[i].getAssociatedDestinations().getAllKeys();
            int j = 0;
            while (j < destinations.length) {
                LogDestinationDescriptor destination;
                String name;
                if (destinations[j] != null && (name = (destination = (LogDestinationDescriptor)destinations[j]).toString()) != null && name.equals(removedName)) {
                    return JOptionPane.showConfirmDialog(this.logDestination, "The Log Destination '" + removedName + "' is used by the Log Controller '" + controllers[i].getName() + "'.\nAre you sure you want to remove '" + removedName + "'?", "Warning", 0, 2) == 0;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private int containsInModel(String logName) {
        int i = 0;
        while (i < this.logModel.size()) {
            if (((ListValues)this.logModel.getElementAt(i)).getLogDestination().toString().equalsIgnoreCase(logName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setDescriptor(LogConfiguration descr, LogConfiguration addEditElements, LogConfiguration removedElements) {
        this.logConfig = descr;
        this.addEditElements = addEditElements;
        this.removedElements = removedElements;
        this.logDestination.setDescriptor(descr);
        LogDestinationDescriptor[] logs = null;
        this.clear();
        this.logModel.clear();
        logs = this.logConfig.getLogDestinations();
        int i = 0;
        while (i < logs.length) {
            if (logs[i] != null) {
                this.logModel.add(new ListValues(logs[i], 0));
            }
            ++i;
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.removeButton.setEnabled(true);
        LogDestinationDescriptor oldLogDestination = null;
        if (this.lastSelected >= 0 && this.lastSelected < this.logModel.size()) {
            oldLogDestination = ((ListValues)this.logModel.getElementAt(this.lastSelected)).getLogDestination();
        }
        LogDestinationDescriptor newLogDestination = this.logDestination.getDescriptor(oldLogDestination);
        if (oldLogDestination != null && newLogDestination != null && newLogDestination.getName() != null && !newLogDestination.getName().trim().equals("") && !oldLogDestination.equals(newLogDestination)) {
            ((ListValues)this.logModel.getElementAt(this.lastSelected)).setLogDestination(newLogDestination);
            if (newLogDestination.getType().equalsIgnoreCase("FileLog")) {
                if (newLogDestination.getPattern() == null || newLogDestination.getPattern().trim().equals("")) {
                    JOptionPane.showMessageDialog(this.logDestination, "Some of the changes in log destination '" + newLogDestination.toString() + "' will be ignored and will not be saved.\nYou must specify a pattern.", "Warning", 2);
                } else {
                    if (newLogDestination.getLimit() != 0 && newLogDestination.getCount() == 0) {
                        JOptionPane.showMessageDialog(this.logDestination, "Limit of log destination '" + newLogDestination.toString() + "' will be ignored and will not be saved.\nYou must specify a count.", "Warning", 2);
                    }
                    if (newLogDestination.getLimit() == 0 && newLogDestination.getCount() != 0) {
                        JOptionPane.showMessageDialog(this.logDestination, "Count of log destination '" + newLogDestination.toString() + "' will be ignored and will not be saved.\nYou must specify a count.", "Warning", 2);
                    }
                }
            }
            this.addToRemoved(oldLogDestination, newLogDestination);
            this.addEditElements.removeLogDestination(newLogDestination.toString());
            this.addEditElements.addLogDestination(newLogDestination);
        }
        if (!this.logList.isSelectionEmpty()) {
            this.logDestination.setDescriptor(((ListValues)this.logList.getSelectedValue()).getLogDestination());
        } else {
            this.clear();
        }
        this.lastSelected = this.logList.getSelectedIndex();
        this.checkEnable();
    }

    private void addToRemoved(LogDestinationDescriptor oldLDD, LogDestinationDescriptor newLDD) {
        if (!this.removedElements.containsLogDetination(newLDD.toString())) {
            String[] filters = oldLDD.getFilters();
            int i = 0;
            while (i < filters.length) {
                if (!newLDD.containsFilter(filters[i])) {
                    this.removedElements.addLogDestination(newLDD);
                    return;
                }
                ++i;
            }
        }
    }

    private void checkFileLog() {
        String type = (String)this.logDestination.typeComboBox.getSelectedItem();
        boolean enabled = false;
        if (type != null && type.equalsIgnoreCase("FileLog")) {
            enabled = true;
        }
        this.logDestination.patternTextField.setEnabled(enabled);
        this.logDestination.limitScrollField.setEnabled(enabled);
        this.logDestination.countScrollField.setEnabled(enabled);
    }

    private void checkEnable() {
        boolean flag = !this.logDestination.nameTextField.getText().trim().equals("");
        this.logDestination.typeComboBox.setEnabled(flag);
        this.logDestination.encodingTextField.setEnabled(flag);
        this.logDestination.effectiveSeverityComboBox.setEnabled(flag);
        this.logDestination.filters.setEnabled(flag);
        this.logDestination.formatterPanel.setEnabled(flag);
        if (flag) {
            this.checkFileLog();
        } else {
            this.logDestination.patternTextField.setEnabled(false);
            this.logDestination.limitScrollField.setEnabled(false);
            this.logDestination.countScrollField.setEnabled(false);
        }
    }

    public void setFrame(Frame frame) {
        this.logDestination.setFrame(frame);
    }

    public void setSelectedDestination(ListValues lv) {
        String name = lv.getLogDestination().toString();
        Iterator elements = ((AbstractList)((SortedListModel)this.logList.getModel()).getData()).iterator();
        while (elements.hasNext()) {
            ListValues element = (ListValues)elements.next();
            if (!element.getLogDestination().toString().equals(name)) continue;
            this.logList.setSelectedValue(element, true);
        }
        this.checkEnable();
    }

    public void setAdvancedMode(boolean mode) {
        this.logDestination.formatterPanel.setAdvancetMode(mode);
    }
}

