/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.gui.CStringScrollField;
import com.sap.engine.gui.SimpleListPanel;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import com.sap.engine.services.log_configurator.admin.gui.AdvanceListPanel;
import com.sap.engine.services.log_configurator.admin.gui.GeneralLogControllerPanel;
import com.sap.engine.services.log_configurator.admin.gui.LogControllerPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LogDestinationPanel
extends JPanel {
    protected Frame mainFrame = null;
    protected GeneralLogControllerPanel mainPanel;
    public JPanel buttonsPanel = new JPanel();
    public JTextField nameTextField = new JTextField();
    public JComboBox typeComboBox = new JComboBox<Object>(new Object[]{"FileLog", "ConsoleLog"});
    public JTextField patternTextField = new JTextField();
    public JComboBox effectiveSeverityComboBox = new JComboBox<String>(LogControllerPanel.severityArr);
    public CStringScrollField limitScrollField = new CStringScrollField(1, Integer.MAX_VALUE);
    public CStringScrollField countScrollField = new CStringScrollField(1, Integer.MAX_VALUE);
    public JTextField encodingTextField = new JTextField();
    public SimpleListPanel filters = new SimpleListPanel("Filters");
    public AdvanceListPanel formatterPanel = null;
    public LogConfiguration logConfig = null;
    public boolean selectWithMouse = true;
    public boolean setText = false;

    public LogDestinationPanel(Frame frame, boolean hasIcons, GeneralLogControllerPanel mainPanel) {
        this.mainFrame = frame;
        this.mainPanel = mainPanel;
        try {
            this.initPanel(hasIcons);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void initPanel(boolean hasIcons) throws Exception {
        JLabel nameLabel = new JLabel("Name:");
        JLabel typeLabel = new JLabel("Type:");
        JLabel patternLabel = new JLabel("Pattern:");
        JLabel encodingLabel = new JLabel("Encoding:");
        JLabel effectiveSeverityLabel = new JLabel("Severity:");
        JLabel limitLabel = new JLabel("Limit:");
        JLabel countLabel = new JLabel("Count:");
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ""));
        this.buttonsPanel.setLayout(new FlowLayout());
        this.formatterPanel = new AdvanceListPanel("Formatter", this.mainFrame, 1, hasIcons, this.mainPanel);
        this.formatterPanel.setPreferredSize(new Dimension(200, 150));
        this.filters.setPreferredSize(new Dimension(200, 115));
        this.nameTextField.setEditable(false);
        this.typeComboBox.setEditable(true);
        int y = 1;
        this.add((Component)nameLabel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)typeLabel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)patternLabel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)limitLabel, new GridBagConstraints(3, y, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)encodingLabel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)effectiveSeverityLabel, new GridBagConstraints(0, y, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)countLabel, new GridBagConstraints(3, y++, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        int i = 0;
        this.add((Component)this.nameTextField, new GridBagConstraints(2, i++, 9, 2, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        int n = ++i;
        this.add((Component)this.typeComboBox, new GridBagConstraints(2, n, 9, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        int n2 = ++i;
        this.add((Component)this.patternTextField, new GridBagConstraints(2, n2, 9, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.limitScrollField, new GridBagConstraints(5, ++i, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.encodingTextField, new GridBagConstraints(2, i++, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.effectiveSeverityComboBox, new GridBagConstraints(2, i, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.countScrollField, new GridBagConstraints(5, i++, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.formatterPanel, new GridBagConstraints(1, i++, 9, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.buttonsPanel, new GridBagConstraints(1, i++, 9, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setDescriptor(new LogDestinationDescriptor());
    }

    public void clear() {
        this.setDescriptor((LogDestinationDescriptor)null);
    }

    public void setDescriptor(LogDestinationDescriptor descr) {
        if (descr == null) {
            descr = new LogDestinationDescriptor();
        }
        if (this.selectWithMouse) {
            this.setText = true;
            this.nameTextField.setText(descr.toString());
            this.setText = false;
        }
        this.typeComboBox.getModel().setSelectedItem(descr.getType());
        this.patternTextField.setText(descr.getPattern());
        this.encodingTextField.setText(descr.getEncoding());
        this.effectiveSeverityComboBox.setSelectedItem(descr.getEffectiveSeverity());
        this.limitScrollField.setValue(descr.getLimit());
        this.countScrollField.setValue(descr.getCount());
        this.filters.initList(descr.getFilters());
        this.formatterPanel.initList(new LogFormatterDescriptor[]{descr.getFormatter()});
        this.initAdvancePanel();
    }

    public void initAdvancePanel() {
        this.formatterPanel.setDescriptor(this.logConfig);
    }

    public LogDestinationDescriptor getDescriptor(LogDestinationDescriptor oldDescriptor) {
        LogDestinationDescriptor descr = new LogDestinationDescriptor();
        if (this.nameTextField.getText().equals("")) {
            return descr;
        }
        if (oldDescriptor != null) {
            descr.setName(oldDescriptor.getName());
            descr.setPrefix(oldDescriptor.getPrefix());
            descr.setPersistenceAdapter(oldDescriptor.getPersistenceAdapter());
        } else {
            descr.setName(this.nameTextField.getText().trim().equals("") ? null : this.nameTextField.getText().trim());
        }
        String type = (String)this.typeComboBox.getSelectedItem();
        if (type != null) {
            descr.setType((type = type.trim()).equals("") ? null : type);
        }
        descr.setPattern(this.patternTextField.getText().trim().equals("") ? null : this.patternTextField.getText().trim());
        descr.setEncoding(this.encodingTextField.getText().trim().equals("") ? null : this.encodingTextField.getText().trim());
        descr.setEffectiveSeverity((String)this.effectiveSeverityComboBox.getSelectedItem());
        descr.setLimit(this.limitScrollField.getValue());
        descr.setCount(this.countScrollField.getValue());
        descr.setFilters(this.filters.getListDataArray());
        descr.setFormatter((LogFormatterDescriptor)this.formatterPanel.getDescriptor());
        return descr;
    }

    public void setDescriptor(LogConfiguration descr) {
        this.logConfig = descr;
        this.formatterPanel.setDescriptor(this.logConfig);
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
        this.filters.setParentComponent(frame);
        this.formatterPanel.setParentComponent(frame);
    }
}

