/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.services.log_configurator.admin.gui.ImageHolder;
import com.sap.engine.services.log_configurator.admin.gui.LogControllersTreeModel;
import com.sap.tc.logging.Severity;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class LogControllersTreeRenderer
extends DefaultTreeCellRenderer {
    private LogConfiguration config;
    private LogControllersTreeModel model;

    public LogControllersTreeRenderer(LogControllersTreeModel model) {
        this.model = model;
    }

    public void setDescriptor(LogConfiguration config) {
        this.config = config;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        String name = this.model.pathToName(((DefaultMutableTreeNode)value).getPath());
        if (this.config != null && name != null && this.config.containsLogController(name)) {
            LogControllerDescriptor controller = this.config.getLogController(name);
            switch (controller.getState()) {
                case -1: {
                    this.setIcon(ImageHolder.logControllerDisabled);
                    break;
                }
                case 1: {
                    this.setIcon(ImageHolder.logControllerEnableAll);
                    break;
                }
                default: {
                    this.setIcon(ImageHolder.logController);
                }
            }
            int effectiveSeverity = this.config.calculateEffectiveSeverity(name);
            super.setText(value + " (Severity=" + Severity.toString((int)effectiveSeverity) + ")");
        } else {
            this.setIcon(ImageHolder.emptyLogController);
        }
        return this;
    }
}

