/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.visual_administration.AdminEvent;
import com.sap.engine.interfaces.visual_administration.AdminEventListener;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.services.log_configurator.admin.LogConfiguratorListener;
import com.sap.engine.services.log_configurator.admin.LogConfiguratorManagementInterface;
import com.sap.engine.services.log_configurator.admin.gui.ArchiveDialog;
import com.sap.engine.services.log_configurator.admin.gui.GeneralLogControllerPanel;
import com.sap.engine.services.log_configurator.admin.gui.ImageHolder;
import com.sap.engine.services.log_configurator.admin.gui.LogConfiguratorListenerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionListener;

public class GeneralLogControllerRuntime
extends GeneralLogControllerPanel
implements VisualRuntimeControl,
ActionListener,
AdminEventListener {
    private LogConfiguratorManagementInterface logManagement;
    private JButton applyButton = new JButton(ImageHolder.apply);
    private JButton refreshButton = new JButton(ImageHolder.reset);
    private JButton undoButton = new JButton(ImageHolder.undo);
    private JButton redoButton = new JButton(ImageHolder.redo);
    private JButton sqlButton = new JButton(ImageHolder.sql_trace);
    private JButton archiveButton = new JButton("Archive", ImageHolder.archive);
    private JButton advancedButton = new JButton("To advanced mode", ImageHolder.mode);
    private JButton resetToInstallationDefaultsButton = new JButton("Installation defaults");
    private JPopupMenu installationDefaultsPopupMenu;
    private JPopupMenu applyPopupMenu;
    private JMenuItem applyInClusterMenuItem;
    private boolean advancedMode = false;
    private int listenerID = -1;
    private boolean isRefreshable = false;
    private long version;
    private LogConfiguration undoConfiguration = null;
    private LogConfiguration redoConfiguration = null;
    public static final String APPLY_CMD = "APPLY";
    public static final String REFRESH_CMD = "REFRESH";
    public static final String UNDO_CMD = "UNDO";
    public static final String REDO_CMD = "REDO";
    public static final String SQL_CMD = "SQL";
    public static final String ARCHIVE_CMD = "ARCHIVE";
    public static final String ADVANCED_CMD = "ADVANCED";
    public static final String RESET_TO_INSTALLATION_DEFAULTS_CMD = "RESET_TO_INSTALLATION_DEFAULTS_CMD";
    private static String CLUSTER_NODE_TYPE = "server";
    private static final String APPLY_TO_CURRENT = "Apply to current node only";
    private static String APPLY_IN_CLUSTER = "Apply changes cluster-wide";
    private static final String LEAVE_CLUSTER_WIDE_CHANGES = "Leave cluster-wide changes";
    private static final String REMOVE_CLUSTER_WIDE_CHANGES = "Remove cluster-wide changes";
    private static String LEAVE_CLUSTER_WIDE_CHANGES_WARNING = "WARNING: This operation will reset the entire log configuration \non a number of cluster nodes to its installation default settings.\nAny node-local changes will be lost, as well as all uncommitted\nadjustments you have made in the current log configurator view.\n\nThe defaults will be applied immediately and you will not be able\nto revert this operation.\n\nAre you sure you want to proceed?";
    private static String REMOVE_CLUSTER_WIDE_CHANGES_WARNING = "WARNING: This operation will reset the entire log configuration \non a number of cluster nodes to its installation default settings.\nAny custom changes will be lost, as well as all uncommitted \nadjustments you have made in the current log configurator view.\n\nThe defaults will be applied immediately and you will not be able\nto revert this operation.\n\nAre you sure you want to proceed?";
    private LogConfiguratorListenerImpl listener;

    public GeneralLogControllerRuntime() {
        super(true, false);
        this.init();
    }

    private void init() {
        this.applyButton.setPreferredSize(new Dimension(24, 24));
        this.applyButton.setToolTipText("Apply");
        this.applyButton.setActionCommand(APPLY_CMD);
        this.applyButton.addActionListener(this);
        this.refreshButton.setPreferredSize(new Dimension(24, 24));
        this.refreshButton.setToolTipText("Refresh");
        this.refreshButton.setActionCommand(REFRESH_CMD);
        this.refreshButton.addActionListener(this);
        this.refreshButton.setEnabled(this.isRefreshable);
        this.undoButton.setPreferredSize(new Dimension(24, 24));
        this.undoButton.setToolTipText("Undo");
        this.undoButton.setActionCommand(UNDO_CMD);
        this.undoButton.addActionListener(this);
        this.undoButton.setVisible(false);
        this.redoButton.setPreferredSize(new Dimension(24, 24));
        this.redoButton.setToolTipText("Redo");
        this.redoButton.setActionCommand(REDO_CMD);
        this.redoButton.addActionListener(this);
        this.redoButton.setVisible(false);
        this.sqlButton.setPreferredSize(new Dimension(150, 24));
        this.sqlButton.setActionCommand(SQL_CMD);
        this.sqlButton.addActionListener(this);
        this.sqlButton.setVisible(false);
        this.archiveButton.setPreferredSize(new Dimension(150, 24));
        this.archiveButton.setActionCommand(ARCHIVE_CMD);
        this.archiveButton.addActionListener(this);
        this.advancedButton.setPreferredSize(new Dimension(150, 24));
        this.advancedButton.setActionCommand(ADVANCED_CMD);
        this.advancedButton.addActionListener(this);
        this.resetToInstallationDefaultsButton.setActionCommand(RESET_TO_INSTALLATION_DEFAULTS_CMD);
        this.resetToInstallationDefaultsButton.addActionListener(this);
        this.installationDefaultsPopupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(REMOVE_CLUSTER_WIDE_CHANGES);
        menuItem.setActionCommand(REMOVE_CLUSTER_WIDE_CHANGES);
        menuItem.addActionListener(this);
        this.installationDefaultsPopupMenu.add(menuItem);
        menuItem = new JMenuItem(LEAVE_CLUSTER_WIDE_CHANGES);
        menuItem.setActionCommand(LEAVE_CLUSTER_WIDE_CHANGES);
        menuItem.addActionListener(this);
        this.installationDefaultsPopupMenu.add(menuItem);
        this.applyPopupMenu = new JPopupMenu();
        menuItem = new JMenuItem(APPLY_TO_CURRENT);
        menuItem.setActionCommand(APPLY_TO_CURRENT);
        menuItem.addActionListener(this);
        this.applyPopupMenu.add(menuItem);
        menuItem = new JMenuItem(APPLY_IN_CLUSTER);
        menuItem.setActionCommand(APPLY_IN_CLUSTER);
        menuItem.addActionListener(this);
        this.applyPopupMenu.add(menuItem);
        this.applyInClusterMenuItem = menuItem;
    }

    public JComponent getRuntimeControlComponent() {
        return this;
    }

    public JMenu getRuntimeMenu() {
        return null;
    }

    public JButton[] getRuntimeButtons() {
        JButton[] runtimeButtons = new JButton[]{this.applyButton, this.refreshButton, this.undoButton, this.redoButton, this.sqlButton, this.archiveButton, this.advancedButton, this.resetToInstallationDefaultsButton};
        return runtimeButtons;
    }

    public void freeResources() {
        if (this.listenerID != -1) {
            this.logManagement.unregisterListener(this.listenerID);
            this.listener.freeResourses();
        }
    }

    public void setTaskManager(EditorViewManager manager) {
    }

    public void setEnvironment(String editorToolName, Object environment) throws UnsupportedEditorException {
        EditorViewManager manager = (EditorViewManager)environment;
        manager.registerAdminEventListener(this, "Log Configurator");
    }

    public void setDescriptor(LogConfiguration descr, LogConfiguration addEditElements, LogConfiguration removedElements) {
        this.archiveButton.setEnabled(descr != null);
        super.setDescriptor(descr, addEditElements, removedElements);
    }

    public void show(ManagementInterface serviceRuntimeInterface) {
        try {
            this.logManagement = (LogConfiguratorManagementInterface)serviceRuntimeInterface;
            CLUSTER_NODE_TYPE = 2 == this.logManagement.getClusterNodeType() ? "server" : "dispatcher";
            APPLY_IN_CLUSTER = "Apply to all \"" + CLUSTER_NODE_TYPE + " nodes\"";
            LEAVE_CLUSTER_WIDE_CHANGES_WARNING = "WARNING: This operation will reset the entire log configuration\non all \"" + CLUSTER_NODE_TYPE + " nodes\" to its installation default settings.\n" + "Any node-local changes will be lost, as well as all uncommitted\n" + "adjustments you have made in the current log configurator view.\n\n" + "The defaults will be applied immediately and you will not be able\n" + "to revert this operation.\n\n" + "Are you sure you want to proceed?";
            REMOVE_CLUSTER_WIDE_CHANGES_WARNING = "WARNING: This operation will reset the entire log configuration\non all \"" + CLUSTER_NODE_TYPE + " nodes\" to its installation default settings.\n" + "Any custom changes will be lost, as well as all uncommitted\n" + "adjustments you have made in the current log configurator view.\n\n" + "The defaults will be applied immediately and you will not be able\n" + "to revert this operation.\n\n" + "Are you sure you want to proceed?";
            this.applyInClusterMenuItem.setText(APPLY_IN_CLUSTER);
            this.applyInClusterMenuItem.setActionCommand(APPLY_IN_CLUSTER);
            this.locations.setManagementInterface(this.logManagement);
            this.categories.setManagementInterface(this.logManagement);
            this.setDescriptor(this.logManagement.getCurrentConfiguration(), null, null);
            if (this.logManagement.isSQLTrace()) {
                this.sqlButton.setText("Disable SQL trace");
            } else {
                this.sqlButton.setText("Enable SQL trace");
            }
            this.sqlButton.setVisible(true);
            try {
                this.listener = new LogConfiguratorListenerImpl(this);
                this.listenerID = this.logManagement.registerListener((LogConfiguratorListener)this.listener);
            }
            catch (Exception e) {
                this.refreshButton.setVisible(false);
            }
            this.version = this.getVersion();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(APPLY_CMD)) {
            this.applyAction();
        } else if (command.equals(APPLY_TO_CURRENT)) {
            this.applyAction(false);
        } else if (command.equals(APPLY_IN_CLUSTER)) {
            this.applyAction(true);
        } else if (command.equals(REFRESH_CMD)) {
            GeneralLogControllerRuntime generalLogControllerRuntime = this;
            synchronized (generalLogControllerRuntime) {
                this.undoConfiguration = this.getDescriptor();
                this.redoConfiguration = this.logManagement.getCurrentConfiguration();
                this.setDescriptor(this.redoConfiguration, null, null);
                this.refreshButton.setEnabled(false);
                this.version = this.getVersion();
                this.undoButton.setVisible(true);
                this.redoButton.setVisible(false);
            }
        } else if (command.equals(UNDO_CMD)) {
            this.undoButton.setVisible(false);
            this.setDescriptor(this.undoConfiguration, null, null);
            this.redoButton.setVisible(true);
        } else if (command.equals(REDO_CMD)) {
            this.redoButton.setVisible(false);
            this.undoConfiguration = this.getDescriptor();
            this.setDescriptor(this.redoConfiguration, null, null);
            this.undoButton.setVisible(true);
        } else if (command.equals(SQL_CMD)) {
            if (this.logManagement.isSQLTrace()) {
                this.logManagement.setSQLTrace(false);
                this.sqlButton.setText("Enable SQL trace");
            } else {
                this.logManagement.setSQLTrace(true);
                this.sqlButton.setText("Disable SQL trace");
            }
        } else if (command.equals(ARCHIVE_CMD)) {
            this.executeArchiveDialog();
        } else if (command.equals(ADVANCED_CMD)) {
            this.changeAdvancedMode();
        } else if (command.equals(RESET_TO_INSTALLATION_DEFAULTS_CMD)) {
            this.installationDefaultsAction(false);
        }
    }

    private void applyAction() {
        this.applyPopupMenu.show(this.applyButton, 0, this.applyButton.getHeight());
    }

    private void applyAction(boolean clusterWide) {
        GeneralLogControllerRuntime generalLogControllerRuntime = this;
        synchronized (generalLogControllerRuntime) {
            if (this.refreshButton.isEnabled() && JOptionPane.showConfirmDialog(this, "Configuration was changed by another user. Do you want to override it?", "Warninig", 0) != 0) {
                return;
            }
            this.refreshButton.setEnabled(false);
            if (this.lastSelected instanceof ListSelectionListener) {
                ((ListSelectionListener)((Object)this.lastSelected)).valueChanged(null);
            } else {
                ((TreeSelectionListener)((Object)this.lastSelected)).valueChanged(null);
            }
            this.version = clusterWide ? this.logManagement.applyAndStoreConfiguration(this.addEditElements, this.removedElements, clusterWide) : this.logManagement.applyAndStoreConfiguration(this.addEditElements, this.removedElements);
            this.addEditElements.clear();
            this.removedElements.clear();
            this.undoButton.setVisible(false);
            this.redoButton.setVisible(false);
        }
    }

    private void installationDefaultsAction() {
        this.installationDefaultsPopupMenu.show(this.resetToInstallationDefaultsButton, 0, this.resetToInstallationDefaultsButton.getHeight());
    }

    private void installationDefaultsAction(boolean leaveClusterWideChanges) {
        String warningMessage;
        String string = warningMessage = leaveClusterWideChanges ? LEAVE_CLUSTER_WIDE_CHANGES_WARNING : REMOVE_CLUSTER_WIDE_CHANGES_WARNING;
        if (JOptionPane.showConfirmDialog(this, warningMessage, "Installation defaults", 0, 2) != 0) {
            return;
        }
        GeneralLogControllerRuntime generalLogControllerRuntime = this;
        synchronized (generalLogControllerRuntime) {
            this.undoConfiguration = this.getDescriptor();
            this.redoConfiguration = this.logManagement.resetToDefaultConfiguration();
            this.setDescriptor(this.redoConfiguration, null, null);
            this.refreshButton.setEnabled(false);
            this.version = this.getVersion();
            this.undoButton.setVisible(false);
            this.redoButton.setVisible(false);
        }
    }

    public boolean getAdvancedMode() {
        return this.advancedMode;
    }

    public void changeAdvancedMode() {
        boolean bl = this.advancedMode = !this.advancedMode;
        if (this.advancedMode) {
            this.advancedButton.setText("To simple mode");
        } else {
            this.advancedButton.setText("To advanced mode");
        }
        this.setAdvancedMode(this.advancedMode);
    }

    private void executeArchiveDialog() {
        String[] names;
        ArchiveDialog dlg = new ArchiveDialog(this.mainFrame, this.descr);
        ((Component)dlg).setVisible(true);
        if (dlg.getModalResult() && (names = dlg.getSelectedDestinationNames()).length > 0) {
            JTextArea resultText = new JTextArea(this.logManagement.archive(names, dlg.isDefaultTracesSelected(), dlg.getArchiveDirectory()));
            resultText.setEditable(false);
            JScrollPane resultScroll = new JScrollPane(resultText);
            resultScroll.setPreferredSize(new Dimension(400, 200));
            JOptionPane.showMessageDialog(this, resultScroll);
        }
    }

    public synchronized void setRefreshable(long version, boolean isRefreshable) {
        if (version != this.version) {
            this.isRefreshable = isRefreshable;
            this.refreshButton.setEnabled(isRefreshable);
        }
    }

    public void adminEventOccured(AdminEvent event) {
        if (event.getType() == 1) {
            if (this.lastSelected instanceof ListSelectionListener) {
                ((ListSelectionListener)((Object)this.lastSelected)).valueChanged(null);
            } else {
                ((TreeSelectionListener)((Object)this.lastSelected)).valueChanged(null);
            }
            if (this.isChanged()) {
                int x = JOptionPane.showConfirmDialog(this, "You have made changes in the log configuration.\nDo you want to save them?", "Save changes", 0, 2);
                if (x != 0) {
                    return;
                }
                x = JOptionPane.showConfirmDialog(this, "Do you want to distribute your changes to all \"" + CLUSTER_NODE_TYPE + " nodes\"?", "Scope of changes", 1, 3);
                switch (x) {
                    case 1: {
                        this.applyAction(false);
                        return;
                    }
                    case 0: {
                        this.applyAction(true);
                        return;
                    }
                }
                return;
            }
        }
    }
}

