/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import com.sap.engine.services.log_configurator.admin.gui.ListRenderer;
import com.sap.engine.services.log_configurator.admin.gui.ListValues;
import com.sap.engine.services.log_configurator.admin.gui.LogControllerPanel;
import com.sap.engine.services.log_configurator.admin.gui.SortedListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AdvanceDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final String SELECT = "SELECT";
    private static final String CANCEL = "CANCEL";
    private static final String ANONYMOUS = "ANONYMOUS";
    private Frame mainFrame = null;
    private JButton selectButton;
    private JButton cancelButton;
    private JButton anonymousButton;
    private JComboBox associationComboBox = new JComboBox<String>(LogControllerPanel.ASSOCIATION_VALUES);
    private byte associationType;
    private Object[] value = null;
    private SortedListModel listModel = new SortedListModel();
    private JList theList = new JList(this.listModel);
    private int type;
    private LogConfiguration logConfig;

    public AdvanceDialog(Frame mainFrame, int type, boolean hasIcons) {
        super(mainFrame, true);
        this.mainFrame = mainFrame;
        this.type = type;
        this.setLocationRelativeTo(this.mainFrame);
        this.getContentPane().setLayout(new BorderLayout());
        this.setResizable(true);
        try {
            this.init(hasIcons);
        }
        catch (Exception exc) {
            // empty catch block
        }
    }

    private void init(boolean hasIcons) throws Exception {
        String title = null;
        JPanel buttonsPanel = new JPanel();
        JPanel mainPanel = new JPanel();
        JLabel associationLabel = new JLabel("Association :");
        if (this.type == 0) {
            title = "Add Destination";
            this.theList.setSelectionMode(2);
        } else if (this.type == 1) {
            title = "Add Formatter";
            this.theList.setSelectionMode(0);
        }
        if (hasIcons) {
            this.theList.setCellRenderer(new ListRenderer());
        }
        this.theList.addListSelectionListener(this);
        JScrollPane listScrollPane = new JScrollPane();
        listScrollPane.getViewport().add((Component)this.theList, null);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new GridBagLayout());
        listPanel.add((Component)listScrollPane, new GridBagConstraints(0, 0, 2, 1, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        listPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), ""));
        this.associationComboBox.setEnabled(false);
        if (this.type == 0) {
            listPanel.add((Component)associationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            listPanel.add((Component)this.associationComboBox, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.setTitle(title);
        ((Component)this).setSize(350, 250);
        buttonsPanel.setLayout(new FlowLayout());
        this.selectButton = new JButton("Select");
        this.selectButton.addActionListener(this);
        this.selectButton.setActionCommand(SELECT);
        this.selectButton.setEnabled(false);
        buttonsPanel.add((Component)this.selectButton, null);
        this.anonymousButton = new JButton("Anonymous");
        this.anonymousButton.addActionListener(this);
        this.anonymousButton.setActionCommand(ANONYMOUS);
        this.anonymousButton.setEnabled(true);
        buttonsPanel.add((Component)this.anonymousButton, null);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand(CANCEL);
        this.cancelButton.setEnabled(true);
        buttonsPanel.add((Component)this.cancelButton, null);
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)listPanel, "Center");
        mainPanel.add((Component)buttonsPanel, "South");
        this.getContentPane().add((Component)mainPanel, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(SELECT)) {
            this.okAction();
            this.setVisible(false);
            this.clear();
        } else if (cmd.equals(CANCEL)) {
            this.setVisible(false);
            this.clear();
        } else if (cmd.equals(ANONYMOUS)) {
            if (this.type == 0) {
                JComboBox<Object> types = new JComboBox<Object>(new Object[]{"ConsoleLog"});
                types.setEditable(true);
                if (JOptionPane.showConfirmDialog(this, types, "New anonymous destination", 2, 3) == 0) {
                    String newType = (String)types.getSelectedItem();
                    if (newType == null || newType.trim().equals("")) {
                        JOptionPane.showMessageDialog(this, "Can not create destination without type!", "Error", 0);
                    } else {
                        LogDestinationDescriptor destination = new LogDestinationDescriptor();
                        destination.setType(newType);
                        ListValues tmp = new ListValues(destination, this.type);
                        this.listModel.add(tmp);
                        this.theList.clearSelection();
                        this.theList.setSelectedValue(tmp, true);
                    }
                }
            } else if (this.type == 1) {
                String newType;
                JComboBox<Object> types = new JComboBox<Object>(new Object[]{"ListFormatter", "TraceFormatter", "XMLFormatter"});
                types.setEditable(true);
                if (JOptionPane.showConfirmDialog(this, types, "Formatter type", 2, 3) == 0 && (newType = (String)types.getSelectedItem()) != null && !newType.trim().equals("")) {
                    LogFormatterDescriptor formatter = new LogFormatterDescriptor();
                    formatter.setType(newType);
                    if (newType.equalsIgnoreCase("TraceFormatter")) {
                        formatter.setPattern("%24d %-40l [%t] %s: %m");
                    }
                    ListValues tmp = new ListValues(formatter, this.type);
                    this.listModel.add(tmp);
                    this.theList.clearSelection();
                    this.theList.setSelectedValue(tmp, true);
                }
            }
        }
    }

    private void okAction() {
        if (this.theList.getSelectedValues() != null && this.theList.getSelectedValues().length != 0) {
            this.value = this.theList.getSelectedValues();
            this.associationType = (byte)this.associationComboBox.getSelectedIndex();
        } else {
            this.value = null;
        }
    }

    public void clear() {
        this.setDescriptor(this.logConfig);
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
        this.setLocationRelativeTo(this.mainFrame);
    }

    public void setDescriptor(LogConfiguration logConfig) {
        this.logConfig = logConfig;
        this.listModel.clear();
        if (logConfig == null) {
            return;
        }
        Comparable[] descr = null;
        if (this.type == 0) {
            descr = logConfig.getLogDestinations();
        } else if (this.type == 1) {
            descr = logConfig.getLogFormatters();
        }
        if (descr != null) {
            ListValues listValue = null;
            int i = 0;
            while (i < descr.length) {
                if (descr[i] != null) {
                    if (this.type == 0) {
                        listValue = new ListValues((LogDestinationDescriptor)descr[i], this.type);
                    } else if (this.type == 1) {
                        listValue = new ListValues((LogFormatterDescriptor)descr[i], this.type);
                    }
                }
                if (listValue != null) {
                    this.listModel.add(listValue);
                }
                ++i;
            }
        }
    }

    public Object[] getDescriptors() {
        return this.value;
    }

    public static void main(String[] args) {
        AdvanceDialog dialog = new AdvanceDialog(new Frame(), 0, false);
        dialog.setVisible(true);
    }

    public void valueChanged(ListSelectionEvent e) {
        this.associationComboBox.setSelectedIndex(0);
        if (!this.theList.isSelectionEmpty()) {
            this.selectButton.setEnabled(true);
            this.associationComboBox.setEnabled(true);
        } else {
            this.selectButton.setEnabled(false);
            this.associationComboBox.setEnabled(false);
        }
    }

    public byte getAdditionalInfo() {
        return this.associationType;
    }

    public void setVisible(boolean b) {
        if (b) {
            this.value = null;
        }
        if (this.listModel.getSize() == 0) {
            this.selectButton.setEnabled(false);
        } else {
            this.theList.setSelectedIndex(0);
            this.selectButton.setEnabled(true);
        }
        super.setVisible(b);
    }
}

