/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin;

import com.sap.engine.lib.jaxp.SAXParserFactoryImpl;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import com.sap.engine.lib.logging.descriptors.PersistenceAdapter;
import com.sap.engine.lib.util.HashMapObjectByte;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LogXMLParser
extends DefaultHandler {
    private static final Location TRACER = Location.getLocation((Class)(class$com$sap$engine$services$log_configurator$admin$LogXMLParser == null ? (class$com$sap$engine$services$log_configurator$admin$LogXMLParser = LogXMLParser.class$("com.sap.engine.services.log_configurator.admin.LogXMLParser")) : class$com$sap$engine$services$log_configurator$admin$LogXMLParser));
    private static final ClassLoader LOADER = (class$com$sap$engine$services$log_configurator$admin$LogXMLParser == null ? (class$com$sap$engine$services$log_configurator$admin$LogXMLParser = LogXMLParser.class$("com.sap.engine.services.log_configurator.admin.LogXMLParser")) : class$com$sap$engine$services$log_configurator$admin$LogXMLParser).getClassLoader();
    private static final StandardDOMParser DOM_PARSER = new StandardDOMParser();
    static final String DELETION_PREFIX = "~$~DeLeTeD~$~";
    static final int DELETION_PREFIX_LENGTH = "~$~DeLeTeD~$~".length();
    private static final byte FORMATTERS_POS = 0;
    private static final byte DESTINATIONS_POS = 1;
    private static final byte CONTROLLERS_POS = 2;
    private static final byte INPUT_DIMENSION = 3;
    private static final String DTD_BASE = "./dtd";
    private static final String DTD_FILE = "log-configuration.dtd";
    private static final String SHORT_DTD = "<!DOCTYPE log-configuration SYSTEM \"log-configuration.dtd\">";
    private static final String FULL_DTD = "<!DOCTYPE log-configuration [\n\n<!ENTITY % severities \"(NONE|FATAL|ERROR|WARNING|INFO|PATH|DEBUG|ALL)\">\n<!ENTITY % association-types \"(PRIVATE_LOG|LOCAL_LOG|LOG)\">\n<!ENTITY % boolean \"(TRUE | FALSE)\">\n\n<!ELEMENT log-configuration (log-formatters?, log-destinations?, log-controllers?)>\n\n<!ELEMENT log-formatters          (log-formatter*)>\n<!ELEMENT log-destinations        (log-destination*)>\n<!ELEMENT log-controllers         (log-controller*)>\n<!ELEMENT log-filters             (log-filter*)>\n<!ELEMENT associated-destinations ((destination-ref|anonymous-destination)*)>\n\n<!ELEMENT log-formatter     EMPTY>\n<!ATTLIST log-formatter     name CDATA      #REQUIRED>\n<!ATTLIST log-formatter     type NMTOKEN    #REQUIRED>\n<!ATTLIST log-formatter     pattern CDATA   #IMPLIED>\n\n<!ELEMENT log-destination   ((formatter-ref|anonymous-formatter)?, log-filters?)>\n<!ATTLIST log-destination   name ID         #REQUIRED>\n<!ATTLIST log-destination   type NMTOKEN    #REQUIRED>\n<!ATTLIST log-destination   pattern CDATA   #IMPLIED>\n<!ATTLIST log-destination   effective-severity %severities; #IMPLIED>\n<!ATTLIST log-destination   encoding CDATA  #IMPLIED>\n<!ATTLIST log-destination   count CDATA     #IMPLIED>\n<!ATTLIST log-destination   limit CDATA     #IMPLIED>\n\n<!ELEMENT formatter-ref     EMPTY>\n<!ATTLIST formatter-ref     name CDATA #REQUIRED>\n\n<!ELEMENT anonymous-formatter     EMPTY>\n<!ATTLIST anonymous-formatter     type NMTOKEN #REQUIRED>\n\n<!ELEMENT log-controller  (relative-severity*, associated-destinations?, log-filters?)>\n<!ATTLIST log-controller  name                      CDATA #REQUIRED>\n<!ATTLIST log-controller  effective-severity %severities; #IMPLIED>\n<!ATTLIST log-controller  minimum-severity   %severities; #IMPLIED>\n<!ATTLIST log-controller  maximum-severity   %severities; #IMPLIED>\n<!ATTLIST log-controller  bundle-name               CDATA #IMPLIED>\n<!ATTLIST log-controller  db-log                %boolean; #IMPLIED>\n\n<!ELEMENT relative-severity  EMPTY>\n<!ATTLIST relative-severity  relative-controller  CDATA #REQUIRED>\n<!ATTLIST relative-severity  value         %severities; #IMPLIED>\n<!ATTLIST relative-severity  minimum-value %severities; #IMPLIED>\n<!ATTLIST relative-severity  maximum-value %severities; #IMPLIED>\n\n<!ELEMENT log-filter        EMPTY>\n<!ATTLIST log-filter        type NMTOKEN #REQUIRED>\n\n<!ELEMENT destination-ref   EMPTY>\n<!ATTLIST destination-ref   name IDREF #REQUIRED>\n<!ATTLIST destination-ref   association-type %association-types; #REQUIRED>\n\n<!ELEMENT anonymous-destination   EMPTY>\n<!ATTLIST anonymous-destination   type NMTOKEN #REQUIRED>\n<!ATTLIST anonymous-destination   association-type %association-types; #REQUIRED>\n\n]>\n";
    private static final byte IN_NOTHING = 0;
    private static final byte IN_FORMATTERS = 1;
    private static final byte IN_DESTTINATIONS = 2;
    private static final byte IN_CONTROLLERS = 3;
    private byte inCategory = 0;
    private LogFormatterDescriptor currentFormatter;
    private LogDestinationDescriptor currentDestination;
    private LogControllerDescriptor currentController;
    private LogConfiguration config;
    private Vector errors;
    private PersistenceAdapter adapter;
    private String prefix;
    static /* synthetic */ Class class$com$sap$engine$services$log_configurator$admin$LogXMLParser;

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) {
        if (rawName.equals("log-formatters")) {
            this.inCategory = 1;
        } else if (rawName.equals("log-formatter")) {
            this.currentFormatter = new LogFormatterDescriptor(this.adapter);
            this.currentFormatter.setPrefix(this.prefix);
            String name = atts.getValue("name");
            if (name == null) {
                this.errors.addElement("Formatter without name!");
            } else {
                this.currentFormatter.setName(name);
            }
            String type = atts.getValue("type");
            if (type == null) {
                this.errors.addElement("Formatter '" + name + "' have not type!");
            } else {
                this.currentFormatter.setType(type);
            }
            this.currentFormatter.setPattern(atts.getValue("pattern"));
            if (this.currentFormatter.getType().equalsIgnoreCase("TraceFormatter") && this.currentFormatter.getPattern() == null) {
                this.currentFormatter.setPattern(LogFormatterDescriptor.DEFAULT_TRACEFORMATTER_PATTERN);
            }
        } else if (rawName.equals("log-destinations")) {
            this.inCategory = (byte)2;
        } else if (rawName.equals("log-destination")) {
            this.currentDestination = new LogDestinationDescriptor(this.adapter);
            this.currentDestination.setPrefix(this.prefix);
            String name = atts.getValue("name");
            if (name == null) {
                this.errors.addElement("Destination without name!");
            } else {
                this.currentDestination.setName(name);
            }
            String type = atts.getValue("type");
            if (type == null) {
                this.errors.addElement("Destination '" + name + "' have not type!");
            } else {
                this.currentDestination.setType(type);
            }
            this.currentDestination.setPattern(atts.getValue("pattern"));
            String severity = atts.getValue("effective-severity");
            try {
                if (severity != null) {
                    this.currentDestination.setEffectiveSeverity(Severity.parse((String)severity));
                }
            }
            catch (IllegalArgumentException e) {
                this.errors.addElement("Invalid value for effective severity '" + severity + "'!");
            }
            this.currentDestination.setEncoding(atts.getValue("encoding"));
            String intValue = atts.getValue("count");
            if (intValue != null) {
                try {
                    this.currentDestination.setCount(Integer.parseInt(intValue));
                }
                catch (Exception e) {
                    this.errors.addElement("Invalid integer value '" + intValue + "' for count in log destination '" + name + "'!");
                }
            }
            if ((intValue = atts.getValue("limit")) != null) {
                try {
                    this.currentDestination.setLimit(Integer.parseInt(intValue));
                }
                catch (Exception e) {
                    this.errors.addElement("Invalid integer value '" + intValue + "' for limit in log destination '" + name + "'!");
                }
            }
        } else if (rawName.equals("formatter-ref")) {
            String name = atts.getValue("name");
            LogFormatterDescriptor[] formatters = this.config.getLogFormatters();
            int i = 0;
            while (i < formatters.length) {
                LogFormatterDescriptor formatter = formatters[i];
                if (formatter.getName().equals(name)) {
                    this.currentDestination.setFormatter(formatter);
                    return;
                }
                ++i;
            }
            this.errors.addElement("Invalid formatter reference '" + name + "'!");
        } else if (rawName.equals("anonymous-formatter")) {
            LogFormatterDescriptor lfd = new LogFormatterDescriptor();
            lfd.setPrefix(this.prefix);
            String type = atts.getValue("type");
            if (type == null) {
                this.errors.addElement("Anonymous formatter in destination '" + this.currentDestination.getName() + "' have not type!");
            } else {
                lfd.setType(type);
                this.currentDestination.setFormatter(lfd);
            }
        } else if (rawName.equals("log-controllers")) {
            this.inCategory = (byte)3;
        } else if (rawName.equals("log-controller")) {
            this.currentController = new LogControllerDescriptor(this.adapter);
            String name = atts.getValue("name");
            if (name == null) {
                this.errors.addElement("Controller without name!");
            } else {
                this.currentController.setName(name);
            }
            String effectiveSeverity = atts.getValue("effective-severity");
            if (effectiveSeverity != null) {
                try {
                    this.currentController.setMinSeverity(effectiveSeverity);
                    this.currentController.setMaxSeverity(effectiveSeverity);
                }
                catch (IllegalArgumentException e) {
                    this.errors.addElement("Invalid effective severity '" + effectiveSeverity + "'!");
                }
            } else {
                String maxSeverity;
                String minSeverity = atts.getValue("minimum-severity");
                if (minSeverity != null) {
                    try {
                        this.currentController.setMinSeverity(minSeverity);
                    }
                    catch (IllegalArgumentException e) {
                        this.errors.addElement("Invalid minimum severity '" + minSeverity + "'!");
                    }
                }
                if ((maxSeverity = atts.getValue("maximum-severity")) != null) {
                    try {
                        this.currentController.setMaxSeverity(maxSeverity);
                    }
                    catch (IllegalArgumentException e) {
                        this.errors.addElement("Invalid maximum severity '" + maxSeverity + "'!");
                    }
                }
            }
            this.currentController.setBundleName(atts.getValue("bundle-name"));
            String dbLogEnabled = atts.getValue("db-log");
            if ("FALSE".equalsIgnoreCase(dbLogEnabled)) {
                this.currentController.setDBLog(false);
            }
        } else if (rawName.equals("destination-ref")) {
            String name = atts.getValue("name");
            if (name == null) {
                this.errors.addElement("Invalid destination reference - missing name!");
                return;
            }
            String type = atts.getValue("association-type");
            if (type == null) {
                this.errors.addElement("Invalid destination reference - missing association type!");
                return;
            }
            LogDestinationDescriptor[] destinations = this.config.getLogDestinations();
            int i = 0;
            while (i < destinations.length) {
                LogDestinationDescriptor destination = destinations[i];
                if (destination.getName().equals(name)) {
                    if (type.equals("PRIVATE_LOG")) {
                        this.currentController.addDestination(destination, (byte)1);
                    } else if (type.equals("LOCAL_LOG")) {
                        this.currentController.addDestination(destination, (byte)2);
                    } else if (type.equals("LOG")) {
                        this.currentController.addDestination(destination, (byte)0);
                    } else {
                        this.errors.addElement("Invalid association type '" + type + "' for destination reference '" + name + "'!");
                    }
                    return;
                }
                ++i;
            }
            this.errors.addElement("Invalid formatter reference '" + name + "'!");
        } else if (rawName.equals("anonymous-destination")) {
            String name = atts.getValue("type");
            if (name == null) {
                this.errors.addElement("Invalid anonymous destination - missing type!");
                return;
            }
            String type = atts.getValue("association-type");
            if (type == null) {
                this.errors.addElement("Invalid anonymous destination - missing association type!");
                return;
            }
            LogDestinationDescriptor destination = new LogDestinationDescriptor();
            destination.setPrefix(this.prefix);
            destination.setType(name);
            if (type.equals("PRIVATE_LOG")) {
                this.currentController.addDestination(destination, (byte)1);
            } else if (type.equals("LOCAL_LOG")) {
                this.currentController.addDestination(destination, (byte)2);
            } else if (type.equals("LOG")) {
                this.currentController.addDestination(destination, (byte)0);
            } else {
                this.errors.addElement("Invalid association type '" + type + "' for anonymous destination!");
            }
        } else if (rawName.equals("log-filter")) {
            String type = atts.getValue("type");
            if (this.inCategory == 3) {
                if (type == null) {
                    this.errors.addElement("Missing filter type! Current controller is '" + this.currentController.getName() + "'.");
                } else {
                    this.currentController.addFilter(type);
                }
            } else if (this.inCategory == 2) {
                if (type == null) {
                    this.errors.addElement("Missing filter type! Current destination is '" + this.currentDestination.getName() + "'.");
                } else {
                    this.currentDestination.addFilter(type);
                }
            }
        } else if (rawName.equals("relative-severity")) {
            String relativeControllerName = atts.getValue("relative-controller");
            String relativeSeverity = atts.getValue("value");
            if (relativeSeverity != null) {
                try {
                    int severity = Severity.parse((String)relativeSeverity);
                    this.currentController.setRelativeSeverity(relativeControllerName, severity);
                }
                catch (IllegalArgumentException e) {
                    this.errors.addElement("Relative severity '" + relativeSeverity + "' is incorrect!");
                }
                catch (Exception e) {
                    this.errors.addElement("Error in relative severity: " + e.getMessage());
                }
            } else {
                String min = atts.getValue("minimum-value");
                String max = atts.getValue("maximum-value");
                int minValue = 100;
                try {
                    if (min != null) {
                        minValue = Severity.parse((String)min);
                    }
                }
                catch (IllegalArgumentException e) {
                    this.errors.addElement("Minimum relative severity '" + min + "' is incorrect!");
                }
                catch (Exception e) {
                    this.errors.addElement("Error in minimum relative severity: " + e.getMessage());
                }
                int maxValue = 701;
                try {
                    if (max != null) {
                        maxValue = Severity.parse((String)max);
                    }
                }
                catch (IllegalArgumentException e) {
                    this.errors.addElement("Maximum relative severity '" + max + "' is incorrect!");
                }
                catch (Exception e) {
                    this.errors.addElement("Error in maximum relative severity: " + e.getMessage());
                }
                this.currentController.setMinRelativeSeverity(relativeControllerName, minValue);
                this.currentController.setMaxRelativeSeverity(relativeControllerName, maxValue);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) {
        if (rawName.equals("log-formatter")) {
            this.config.addLogFormatter(this.currentFormatter);
        } else if (rawName.equals("log-destination")) {
            this.config.addLogDestination(this.currentDestination);
        } else if (rawName.equals("log-controller")) {
            this.config.addLogController(this.currentController);
        }
    }

    public LogConfiguration parse(PersistenceAdapter adapter, String prefix) {
        return this.parse(adapter.getPersistentEntryStream(), adapter, prefix);
    }

    public LogConfiguration parse(InputStream in, PersistenceAdapter adapter, String prefix) {
        this.adapter = adapter;
        this.prefix = prefix;
        return this.parse(in);
    }

    public LogConfiguration parse(InputStream in) {
        if (in == null) {
            return null;
        }
        this.config = new LogConfiguration();
        this.errors = new Vector();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(LOADER);
        try {
            SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
            try {
                factory.setFeature("http://inqmy.org/sax/features/read-dtd", false);
            }
            catch (Throwable thr) {
                factory.setValidating(false);
            }
            factory.newSAXParser().parse(in, (DefaultHandler)this);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Thread.currentThread().setContextClassLoader(cl);
        return this.config;
    }

    public String[] getErrors() {
        return this.errors.toArray(new String[this.errors.size()]);
    }

    private static void addAttr(Document doc, Element element, String key, String value) {
        Attr attr = doc.createAttribute(key);
        attr.setValue(value);
        element.setAttributeNode(attr);
    }

    public static Document writeToXml(OutputStream xml, LogConfiguration logConfiguration) {
        return LogXMLParser.writeToXml(xml, logConfiguration, false);
    }

    public static Document writeToXml(OutputStream xml, LogConfiguration logConfiguration, boolean DTD) {
        LogControllerDescriptor[] controllers = logConfiguration.getLogControllers();
        LogDestinationDescriptor[] destinations = logConfiguration.getLogDestinations();
        LogFormatterDescriptor[] formatters = logConfiguration.getLogFormatters();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(LOADER);
        Document doc = null;
        try {
            int i;
            doc = StandardDOMParser.createDocument();
            Element mainNode = doc.createElement("log-configuration");
            if (formatters.length != 0) {
                Element formattersElement = doc.createElement("log-formatters");
                i = formatters.length;
                while (--i >= 0) {
                    LogFormatterDescriptor lfd = formatters[i];
                    Element formatterElement = doc.createElement("log-formatter");
                    LogXMLParser.addAttr(doc, formatterElement, "name", lfd.getName());
                    LogXMLParser.addAttr(doc, formatterElement, "type", lfd.getType());
                    String pattern = lfd.getPattern();
                    if (pattern != null && !LogFormatterDescriptor.DEFAULT_TRACEFORMATTER_PATTERN.equals(pattern)) {
                        LogXMLParser.addAttr(doc, formatterElement, "pattern", lfd.getPattern());
                    }
                    formattersElement.appendChild(formatterElement);
                }
                mainNode.appendChild(formattersElement);
            }
            if (destinations.length != 0) {
                Element destinationsElement = doc.createElement("log-destinations");
                i = 0;
                while (i < destinations.length) {
                    String[] fs;
                    LogFormatterDescriptor lfd;
                    LogDestinationDescriptor ldd = destinations[i];
                    Element destinationElement = doc.createElement("log-destination");
                    LogXMLParser.addAttr(doc, destinationElement, "name", ldd.getName());
                    LogXMLParser.addAttr(doc, destinationElement, "type", ldd.getType());
                    if (ldd.getCount() != 0) {
                        LogXMLParser.addAttr(doc, destinationElement, "count", String.valueOf(ldd.getCount()));
                    }
                    if (ldd.getEffectiveSeverity() != null) {
                        LogXMLParser.addAttr(doc, destinationElement, "effective-severity", ldd.getEffectiveSeverity());
                    }
                    if (ldd.getEncoding() != null) {
                        LogXMLParser.addAttr(doc, destinationElement, "encoding", ldd.getEncoding());
                    }
                    if (ldd.getLimit() != 0) {
                        LogXMLParser.addAttr(doc, destinationElement, "limit", String.valueOf(ldd.getLimit()));
                    }
                    if (ldd.getPattern() != null) {
                        LogXMLParser.addAttr(doc, destinationElement, "pattern", ldd.getPattern());
                    }
                    if ((lfd = ldd.getFormatter()) != null) {
                        if (lfd.getName() == null) {
                            String type = lfd.getType();
                            if (!(type == null || ldd.getType().equalsIgnoreCase("FileLog") && type.equalsIgnoreCase("ListFormatter") || ldd.getType().equalsIgnoreCase("ConsoleLog") && type.equalsIgnoreCase("TraceFormatter"))) {
                                Element anonymousFormatterElement = doc.createElement("anonymous-formatter");
                                LogXMLParser.addAttr(doc, anonymousFormatterElement, "type", type);
                                destinationElement.appendChild(anonymousFormatterElement);
                            }
                        } else {
                            Element formatterRefElement = doc.createElement("formatter-ref");
                            LogXMLParser.addAttr(doc, formatterRefElement, "name", lfd.getName());
                            destinationElement.appendChild(formatterRefElement);
                        }
                    }
                    if ((fs = ldd.getFilters()) != null && fs.length != 0) {
                        Element filtersElement = doc.createElement("log-filters");
                        int j = 0;
                        while (j < fs.length) {
                            Element filterElement = doc.createElement("log-filter");
                            LogXMLParser.addAttr(doc, filterElement, "type", fs[j]);
                            filtersElement.appendChild(filterElement);
                            ++j;
                        }
                        destinationElement.appendChild(filtersElement);
                    }
                    destinationsElement.appendChild(destinationElement);
                    ++i;
                }
                mainNode.appendChild(destinationsElement);
            }
            if (controllers.length != 0) {
                Element controllersElement = doc.createElement("log-controllers");
                i = 0;
                while (i < controllers.length) {
                    LogControllerDescriptor lcd = controllers[i];
                    Element controllerElement = doc.createElement("log-controller");
                    LogXMLParser.addAttr(doc, controllerElement, "name", lcd.getName());
                    if (lcd.getBundleName() != null) {
                        LogXMLParser.addAttr(doc, controllerElement, "bundle-name", lcd.getBundleName());
                    }
                    if (lcd.getMinSeverityInt() == lcd.getMaxSeverityInt()) {
                        LogXMLParser.addAttr(doc, controllerElement, "effective-severity", lcd.getMaxSeverity());
                    } else {
                        String max;
                        String min;
                        if (lcd.getMinSeverityInt() != 0 && lcd.getMinSeverityInt() != 100 && (min = lcd.getMinSeverity()) != null) {
                            LogXMLParser.addAttr(doc, controllerElement, "minimum-severity", min);
                        }
                        if (lcd.getMaxSeverityInt() != 701 && (max = lcd.getMaxSeverity()) != null) {
                            LogXMLParser.addAttr(doc, controllerElement, "maximum-severity", max);
                        }
                    }
                    if (!lcd.hasDBLog()) {
                        LogXMLParser.addAttr(doc, controllerElement, "db-log", "false");
                    }
                    String[] relativeControllersNames = lcd.getRelativeControllersNames();
                    int j = 0;
                    while (j < relativeControllersNames.length) {
                        Element relativeSeverityElement = doc.createElement("relative-severity");
                        LogXMLParser.addAttr(doc, relativeSeverityElement, "relative-controller", relativeControllersNames[j]);
                        int min = lcd.getMinRelativeSeverity(relativeControllersNames[j]);
                        int max = lcd.getMaxRelativeSeverity(relativeControllersNames[j]);
                        if (min == max) {
                            LogXMLParser.addAttr(doc, relativeSeverityElement, "value", Severity.toString((int)lcd.getMaxRelativeSeverity(relativeControllersNames[j])));
                        } else {
                            if (min != 100) {
                                LogXMLParser.addAttr(doc, relativeSeverityElement, "minimum-value", Severity.toString((int)lcd.getMinRelativeSeverity(relativeControllersNames[j])));
                            }
                            if (max != 701) {
                                LogXMLParser.addAttr(doc, relativeSeverityElement, "maximum-value", Severity.toString((int)lcd.getMaxRelativeSeverity(relativeControllersNames[j])));
                            }
                        }
                        controllerElement.appendChild(relativeSeverityElement);
                        ++j;
                    }
                    HashMapObjectByte descriptors = lcd.getAssociatedDestinations();
                    Object[] keys = descriptors.getAllKeys();
                    Element destinationsElement = doc.createElement("associated-destinations");
                    int j2 = 0;
                    while (j2 < keys.length) {
                        String strType = null;
                        switch (descriptors.get(keys[j2])) {
                            case 2: {
                                strType = "LOCAL_LOG";
                                break;
                            }
                            case 0: {
                                strType = "LOG";
                                break;
                            }
                            case 1: {
                                strType = "PRIVATE_LOG";
                            }
                        }
                        LogDestinationDescriptor ldd = (LogDestinationDescriptor)keys[j2];
                        if (ldd.getName() != null) {
                            Element destinationRefElement = doc.createElement("destination-ref");
                            LogXMLParser.addAttr(doc, destinationRefElement, "name", ldd.getName());
                            LogXMLParser.addAttr(doc, destinationRefElement, "association-type", strType);
                            destinationsElement.appendChild(destinationRefElement);
                        } else {
                            Element anonymousDestinationElement = doc.createElement("anonymous-destination");
                            LogXMLParser.addAttr(doc, anonymousDestinationElement, "type", ldd.getType());
                            LogXMLParser.addAttr(doc, anonymousDestinationElement, "association-type", strType);
                            destinationsElement.appendChild(anonymousDestinationElement);
                        }
                        ++j2;
                    }
                    controllerElement.appendChild(destinationsElement);
                    String[] fs = lcd.getFilters();
                    if (fs != null && fs.length != 0) {
                        Element filtersElement = doc.createElement("log-filters");
                        int j3 = 0;
                        while (j3 < fs.length) {
                            Element filterElement = doc.createElement("log-filter");
                            LogXMLParser.addAttr(doc, filterElement, "type", fs[j3]);
                            filtersElement.appendChild(filterElement);
                            ++j3;
                        }
                        controllerElement.appendChild(filtersElement);
                    }
                    controllersElement.appendChild(controllerElement);
                    ++i;
                }
                mainNode.appendChild(controllersElement);
            }
            doc.appendChild(mainNode);
            if (DTD) {
                new StandardDOMWriter().write(doc, xml, FULL_DTD);
            } else {
                new StandardDOMWriter().write(doc, xml, SHORT_DTD);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        Thread.currentThread().setContextClassLoader(cl);
        return doc;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource src = null;
        try {
            systemId = DTD_FILE;
            File f = new File(DTD_BASE + File.separator + systemId);
            src = new InputSource(new FileInputStream(f.getCanonicalPath()));
            src.setSystemId(systemId);
        }
        catch (Exception exc) {
            src = new InputSource(new StringReader(FULL_DTD));
        }
        return src;
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1 || args[0] == null || args[0].trim().equals("")) {
            System.out.println("\r\nUSAGE: LOG_PROPS_TO_XML <propertiesFile> [outputDirectory] [-dtd]\r\n\r\n       propertiesFile - path and name of properties file\r\n       outputDirectory - direcory where the output should be placed\r\n       -dtd - add full DTD\r\n");
            return;
        }
        LogConfiguration config = null;
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(args[0]));
            config = LogConfiguration.readFromProperties(props);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("ERROR: File '" + args[0] + "' not found!");
            return;
        }
        catch (IOException ioe) {
            System.out.println("ERROR: Can not read form '" + args[0] + "'!");
            return;
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            return;
        }
        String output = null;
        try {
            boolean fullDTD;
            boolean bl = fullDTD = args.length > 2 && args[2].equalsIgnoreCase("-DTD");
            if (args.length < 2 || args[1] == null || args[1].equalsIgnoreCase("-DTD")) {
                output = "log-configuration.xml";
                fullDTD = true;
            } else {
                new File(args[1]).mkdirs();
                output = args[1].endsWith("\\") || args[1].endsWith("/") ? args[1] + "log-configuration.xml" : args[1] + "/log-configuration.xml";
            }
            LogXMLParser.writeToXml(new FileOutputStream(output), config, fullDTD);
        }
        catch (FileNotFoundException e) {
            System.out.println("ERROR: Can not create XML file with name '" + output + "'!");
            return;
        }
        System.out.println("\r\nXML file '" + output + "' created successfully.\r\n");
    }

    public static LogConfiguration extractConfiguration(PersistenceAdapter storage, String componentPrefix) {
        return LogXMLParser.extractConfiguration(storage.getDefaultPersistentEntryStream(), storage.getPersistentEntryStream(), storage, componentPrefix);
    }

    public static LogConfiguration extractConfiguration(InputStream defaultSettings, InputStream customChanges, PersistenceAdapter storage, String componentPrefix) {
        try {
            if (defaultSettings == null) {
                return null;
            }
            if (componentPrefix == null) {
                componentPrefix = "";
            }
            Object[] document = LogXMLParser.processData(defaultSettings, customChanges);
            LogConfiguration configuration = new LogConfiguration();
            LogXMLParser.processFormatters((Element[])document[0], configuration, storage, componentPrefix);
            LogXMLParser.processDestinations((Element[])document[1], configuration, storage, componentPrefix);
            LogXMLParser.processControllers((Element[])document[2], configuration, storage, componentPrefix);
            return configuration;
        }
        catch (Exception e) {
            TRACER.traceThrowableT(500, "extractConfiguration(.,.,.,.)", "Unable to obtain the logging configuration for component \"" + componentPrefix + "\" !", (Throwable)e);
            return null;
        }
    }

    private static Object[] processData(InputStream defaultSettings, InputStream customChanges) throws Exception {
        Element defaultData = DOM_PARSER.parse(defaultSettings).getDocumentElement();
        Element customData = customChanges != null ? DOM_PARSER.parse(customChanges).getDocumentElement() : null;
        HashMapObjectObject formatterElements = new HashMapObjectObject();
        HashMapObjectObject destinationElements = new HashMapObjectObject();
        HashMapObjectObject controllerElements = new HashMapObjectObject();
        NodeList list = defaultData.getElementsByTagName("log-formatter");
        int i = list.getLength();
        while (--i >= 0) {
            Element element = (Element)list.item(i);
            formatterElements.put(element.getAttribute("name"), element);
        }
        list = defaultData.getElementsByTagName("log-destination");
        int i2 = list.getLength();
        while (--i2 >= 0) {
            Element element = (Element)list.item(i2);
            destinationElements.put(element.getAttribute("name"), element);
        }
        list = defaultData.getElementsByTagName("log-controller");
        int i3 = list.getLength();
        while (--i3 >= 0) {
            Element element = (Element)list.item(i3);
            controllerElements.put(element.getAttribute("name"), element);
        }
        if (customData != null) {
            list = customData.getElementsByTagName("log-formatter");
            int i4 = list.getLength();
            while (--i4 >= 0) {
                Element element = (Element)list.item(i4);
                String name = element.getAttribute("name");
                formatterElements.put(name, element);
            }
            list = customData.getElementsByTagName("log-destination");
            int i5 = list.getLength();
            while (--i5 >= 0) {
                Element element = (Element)list.item(i5);
                String name = element.getAttribute("name");
                destinationElements.put(name, element);
            }
            list = customData.getElementsByTagName("log-controller");
            int i6 = list.getLength();
            while (--i6 >= 0) {
                Element element = (Element)list.item(i6);
                String name = element.getAttribute("name");
                controllerElements.put(name, element);
            }
        }
        Object[] result = new Object[]{formatterElements.getAllValues(new Element[formatterElements.size()]), destinationElements.getAllValues(new Element[destinationElements.size()]), controllerElements.getAllValues(new Element[controllerElements.size()])};
        return result;
    }

    private static void processFormatters(Element[] list, LogConfiguration configuration, PersistenceAdapter storage, String componentPrefix) {
        int i = list.length;
        while (--i >= 0) {
            LogFormatterDescriptor formatterDescriptor = new LogFormatterDescriptor(storage);
            formatterDescriptor.setType(list[i].getAttribute("type"));
            formatterDescriptor.setName(list[i].getAttribute("name"));
            formatterDescriptor.setPrefix(componentPrefix);
            String pattern = list[i].getAttribute("pattern");
            if (!"".equals(pattern)) {
                formatterDescriptor.setPattern(pattern);
            }
            configuration.addLogFormatter(formatterDescriptor);
        }
    }

    private static void processDestinations(Element[] list, LogConfiguration configuration, PersistenceAdapter storage, String componentPrefix) {
        int i = list.length;
        while (--i >= 0) {
            NodeList assFormatters;
            String effSeverity;
            String encoding;
            Element element = list[i];
            LogDestinationDescriptor logDescriptor = new LogDestinationDescriptor(storage);
            logDescriptor.setType(element.getAttribute("type"));
            logDescriptor.setName(element.getAttribute("name"));
            logDescriptor.setPrefix(componentPrefix);
            if (logDescriptor.getType().equals("FileLog")) {
                logDescriptor.setPattern(element.getAttribute("pattern"));
                try {
                    logDescriptor.setLimit(Integer.parseInt(element.getAttribute("limit")));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    logDescriptor.setCount(Integer.parseInt(element.getAttribute("count")));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!"".equals(encoding = element.getAttribute("encoding"))) {
                logDescriptor.setEncoding(encoding);
            }
            if (!"".equals(effSeverity = element.getAttribute("effective-severity"))) {
                logDescriptor.setEffectiveSeverity(effSeverity);
            }
            if ((assFormatters = element.getElementsByTagName("formatter-ref")).getLength() > 0) {
                logDescriptor.setFormatter(configuration.getLogFormatter(componentPrefix + ((Element)assFormatters.item(0)).getAttribute("name")));
            } else {
                String formatterType;
                assFormatters = element.getElementsByTagName("anonymous-formatter");
                if (assFormatters.getLength() > 0 && !"".equals(formatterType = ((Element)assFormatters.item(0)).getAttribute("type"))) {
                    LogFormatterDescriptor formatterDescriptor = new LogFormatterDescriptor(storage);
                    formatterDescriptor.setPrefix(componentPrefix);
                    formatterDescriptor.setType(formatterType);
                    logDescriptor.setFormatter(formatterDescriptor);
                }
            }
            NodeList filters = element.getElementsByTagName("log-filter");
            int j = filters.getLength();
            while (--j >= 0) {
                logDescriptor.addFilter(((Element)filters.item(j)).getAttribute("type"));
            }
            configuration.addLogDestination(logDescriptor);
        }
    }

    private static void processControllers(Element[] list, LogConfiguration configuration, PersistenceAdapter storage, String componentPrefix) {
        int i = list.length;
        while (--i >= 0) {
            String severity;
            Element element = list[i];
            LogControllerDescriptor controllerDescriptor = new LogControllerDescriptor(storage);
            controllerDescriptor.setName(element.getAttribute("name"));
            String bundleName = element.getAttribute("bundle-name");
            if (!"".equals(bundleName)) {
                controllerDescriptor.setBundleName(bundleName);
            }
            if (!"".equals(severity = element.getAttribute("effective-severity"))) {
                controllerDescriptor.setEffectiveSeverity(severity);
            } else {
                severity = element.getAttribute("minimum-severity");
                if (!"".equals(severity) && !"Debug".equalsIgnoreCase(severity)) {
                    controllerDescriptor.setMinSeverity(severity);
                }
                if (!"".equals(severity = element.getAttribute("maximum-severity"))) {
                    controllerDescriptor.setMaxSeverity(severity);
                }
            }
            NodeList filters = element.getElementsByTagName("log-filter");
            int j = filters.getLength();
            while (--j >= 0) {
                controllerDescriptor.addFilter(((Element)filters.item(j)).getAttribute("type"));
            }
            NodeList relativeSeverities = element.getElementsByTagName("relative-severity");
            int j2 = relativeSeverities.getLength();
            while (--j2 >= 0) {
                Element relativeSeverity = (Element)relativeSeverities.item(j2);
                String relativeControllerName = relativeSeverity.getAttribute("relative-controller");
                String value = relativeSeverity.getAttribute("value");
                if (!"".equals(value)) {
                    controllerDescriptor.setRelativeSeverity(relativeControllerName, value);
                    continue;
                }
                value = relativeSeverity.getAttribute("minimum-value");
                if (!"".equals(value)) {
                    controllerDescriptor.setMinRelativeSeverity(relativeControllerName, value);
                }
                if ("".equals(value = relativeSeverity.getAttribute("maximum-value"))) continue;
                controllerDescriptor.setMaxRelativeSeverity(relativeControllerName, value);
            }
            NodeList destRefs = element.getElementsByTagName("destination-ref");
            int j3 = destRefs.getLength();
            while (--j3 >= 0) {
                Element destRef = (Element)destRefs.item(j3);
                String assType = destRef.getAttribute("association-type");
                LogDestinationDescriptor logDescriptor = configuration.getLogDestination(componentPrefix + destRef.getAttribute("name"));
                if (logDescriptor == null) continue;
                if ("PRIVATE_LOG".equals(assType)) {
                    controllerDescriptor.addDestination(logDescriptor, (byte)1);
                    continue;
                }
                if ("LOCAL_LOG".equals(assType)) {
                    controllerDescriptor.addDestination(logDescriptor, (byte)2);
                    continue;
                }
                controllerDescriptor.addDestination(logDescriptor, (byte)0);
            }
            NodeList anonymousDestinations = element.getElementsByTagName("anonymous-destination");
            int j4 = anonymousDestinations.getLength();
            while (--j4 >= 0) {
                Element anonymousDest = (Element)anonymousDestinations.item(j4);
                String assType = anonymousDest.getAttribute("association-type");
                LogDestinationDescriptor logDescriptor = new LogDestinationDescriptor(storage);
                logDescriptor.setType(anonymousDest.getAttribute("type"));
                logDescriptor.setPrefix(componentPrefix);
                if ("PRIVATE_LOG".equals(assType)) {
                    controllerDescriptor.addDestination(logDescriptor, (byte)1);
                    continue;
                }
                if ("LOCAL_LOG".equals(assType)) {
                    controllerDescriptor.addDestination(logDescriptor, (byte)2);
                    continue;
                }
                controllerDescriptor.addDestination(logDescriptor, (byte)0);
            }
            if ("FALSE".equals(element.getAttribute("db-log"))) {
                controllerDescriptor.setDBLog(false);
            }
            configuration.addLogController(controllerDescriptor);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            DOM_PARSER.setValidation(false);
            DOM_PARSER.setReadDTD(false);
        }
        catch (Exception e) {
            TRACER.traceThrowableT(400, "Unable to disable the validation feature for this XML parser!", (Throwable)e);
        }
    }
}

