/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.spi;

import com.sap.engine.services.keystore.impl.KeyStoreEntry;
import com.sap.engine.services.keystore.impl.util.PasswordProperties;
import com.sap.engine.services.keystore.interfaces.KeyStoreEntryCoder;
import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class EBSDKSKeyStoreSpiImpl
extends KeyStoreSpi {
    public static final String X509_FORMAT = "X509";
    public static final String PKSC8_FORMAT = "PKCS8";
    public static final String INNER_FORMAT = "BER";
    private String aliasOfTheCurrentKeystoreView = "DEFAULT";
    private static Properties initialContextProperties = null;
    protected KeystoreManagerWrapper keystoreServiceInterface = null;
    protected GregorianCalendar calendar = null;
    protected boolean initialized = false;
    protected boolean insideServer = false;

    public EBSDKSKeyStoreSpiImpl() {
        try {
            this.init();
            this.calendar = new GregorianCalendar();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void setInitialContextProperties(Properties props) {
        initialContextProperties = props;
    }

    protected void init() throws Exception {
        if (this.initialized) {
            return;
        }
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            this.insideServer = true;
        }
        catch (NamingException e) {
            this.insideServer = false;
        }
        if (initialContextProperties != null) {
            try {
                ctx = new InitialContext(initialContextProperties);
                initialContextProperties = null;
            }
            catch (Exception e) {
                ctx = null;
            }
        } else {
            Properties prop = new Properties();
            ((Hashtable)prop).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
            ctx = new InitialContext(prop);
        }
        if (ctx != null) {
            this.keystoreServiceInterface = (KeystoreManagerWrapper)ctx.lookup("keystore");
            if (this.keystoreServiceInterface == null) {
                throw new Exception("The 'keystore' service is not started");
            }
        } else {
            throw new Exception("Cannot get JNDI Context with specified properties: " + initialContextProperties);
        }
        this.initialized = true;
    }

    public synchronized Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStoreSpiEntry keyEntry = null;
        try {
            keyEntry = this.keystoreServiceInterface.readEntry(this.aliasOfTheCurrentKeystoreView, alias);
            if (keyEntry == null || keyEntry.isCertificateEntry()) {
                return null;
            }
            return keyEntry.getKey();
        }
        catch (RemoteException re) {
            throw new NoSuchAlgorithmException("ID21109: " + re.getMessage());
        }
        catch (KeyStoreException kse) {
            throw new UnrecoverableKeyException("ID21103: " + kse.getMessage());
        }
    }

    public synchronized Certificate[] engineGetCertificateChain(String alias) {
        try {
            KeyStoreSpiEntry keyEntry = null;
            keyEntry = this.keystoreServiceInterface.readEntry(this.aliasOfTheCurrentKeystoreView, alias);
            if (keyEntry == null || !keyEntry.isKeyEntry()) {
                return null;
            }
            return keyEntry.getCertificateChain();
        }
        catch (Exception e) {
            return null;
        }
    }

    public synchronized Certificate engineGetCertificate(String alias) {
        try {
            KeyStoreSpiEntry entry = null;
            entry = this.keystoreServiceInterface.readEntry(this.aliasOfTheCurrentKeystoreView, alias);
            if (entry == null) {
                return null;
            }
            if (entry.isKeyEntry()) {
                Certificate[] chain = entry.getCertificateChain();
                return chain == null || chain.length == 0 ? null : entry.getCertificateChain()[0];
            }
            return entry.getCertificate();
        }
        catch (Exception e) {
            return null;
        }
    }

    public synchronized Date engineGetCreationDate(String alias) {
        try {
            KeyStoreSpiEntry entry = null;
            entry = this.keystoreServiceInterface.readEntry(this.aliasOfTheCurrentKeystoreView, alias);
            if (entry == null) {
                return null;
            }
            return entry.getCreationDate();
        }
        catch (Exception re) {
            return null;
        }
    }

    public synchronized void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        KeyStoreEntry entry = new KeyStoreEntry(key, chain);
        try {
            this.keystoreServiceInterface.writeEntry(this.aliasOfTheCurrentKeystoreView, alias, entry);
        }
        catch (Exception re) {
            throw new KeyStoreException(re.getMessage());
        }
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("ID21150: not implemented");
    }

    public synchronized void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        KeyStoreEntry entry = new KeyStoreEntry(cert);
        try {
            this.keystoreServiceInterface.writeEntry(this.aliasOfTheCurrentKeystoreView, alias, entry);
        }
        catch (Exception re) {
            throw new KeyStoreException(re.getMessage());
        }
    }

    public synchronized void engineDeleteEntry(String alias) {
        try {
            this.keystoreServiceInterface.deleteEntry(this.aliasOfTheCurrentKeystoreView, alias);
        }
        catch (Exception re) {
            return;
        }
    }

    public synchronized Enumeration engineAliases() {
        String[] aliases = null;
        Vector<String> v = new Vector<String>();
        try {
            aliases = this.keystoreServiceInterface.aliases(this.aliasOfTheCurrentKeystoreView);
        }
        catch (Exception kse) {
            return new Vector().elements();
        }
        int i = 0;
        while (i < aliases.length) {
            v.addElement(aliases[i]);
            ++i;
        }
        return v.elements();
    }

    public synchronized boolean engineContainsAlias(String alias) {
        try {
            return this.keystoreServiceInterface.exists(this.aliasOfTheCurrentKeystoreView, alias);
        }
        catch (Exception re) {
            return false;
        }
    }

    public synchronized int engineSize() {
        try {
            return this.keystoreServiceInterface.size(this.aliasOfTheCurrentKeystoreView);
        }
        catch (Exception re) {
            return 0;
        }
    }

    public synchronized boolean engineIsKeyEntry(String alias) {
        try {
            return this.keystoreServiceInterface.isKeyEntry(this.aliasOfTheCurrentKeystoreView, alias);
        }
        catch (Exception npe) {
            return false;
        }
    }

    public synchronized boolean engineIsCertificateEntry(String alias) {
        try {
            return !this.keystoreServiceInterface.isKeyEntry(this.aliasOfTheCurrentKeystoreView, alias);
        }
        catch (Exception npe) {
            return false;
        }
    }

    public synchronized String engineGetCertificateAlias(Certificate cert) {
        try {
            KeyStoreEntry entry = new KeyStoreEntry(cert);
            return this.keystoreServiceInterface.findAlias(this.aliasOfTheCurrentKeystoreView, entry);
        }
        catch (Exception e) {
            return null;
        }
    }

    public synchronized void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream == null) {
            return;
        }
        PasswordProperties properties = new PasswordProperties(password);
        Properties p = null;
        if ("PKCS12".equals(properties.getProperty("format"))) {
            p = new Properties();
            p.setProperty("alias", properties.getProperty("alias"));
            p.setProperty("password", properties.getProperty("password"));
        }
        try {
            KeyStoreSpiEntry entry = null;
            entry = this.keystoreServiceInterface.readEntry(this.aliasOfTheCurrentKeystoreView, properties.getProperty("alias"));
            KeyStoreEntryCoder coder = KeyStoreEntryCoder.getCoder(properties.getProperty("format"));
            KeyStoreEntryCoder.setProperties(p);
            coder.encode(entry, stream);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public synchronized void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        block13: {
            if (password == null) {
                return;
            }
            if (stream == null) {
                PasswordProperties properties = new PasswordProperties(password);
                String keystoreViewAlias = properties.getProperty("KEY_VIEW_ALIAS");
                if (keystoreViewAlias != null) {
                    this.aliasOfTheCurrentKeystoreView = keystoreViewAlias;
                    boolean isExists = this.keystoreServiceInterface.existKeystoreView(this.aliasOfTheCurrentKeystoreView);
                    if (!isExists) {
                        throw new IOException("Keystore view [" + this.aliasOfTheCurrentKeystoreView + "] do not exists!");
                    }
                }
                return;
            }
            PasswordProperties properties = new PasswordProperties(password);
            Properties p = new Properties();
            try {
                String alias = properties.getProperty("alias");
                String format = properties.getProperty("format");
                KeyStoreSpiEntry entry = null;
                if ("PKCS12".equals(properties.getProperty("format"))) {
                    p.setProperty("password", properties.getProperty("password"));
                }
                if (format != null) {
                    KeyStoreEntryCoder coder = KeyStoreEntryCoder.getCoder(format);
                    KeyStoreEntryCoder.setProperties(p);
                    entry = coder.decode(stream);
                } else {
                    Enumeration formats = KeyStoreEntryCoder.getCoderFormats();
                    while (formats.hasMoreElements()) {
                        try {
                            KeyStoreEntryCoder coder = KeyStoreEntryCoder.getCoder((String)formats.nextElement());
                            entry = coder.decode(stream);
                            break;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (entry != null) {
                    this.keystoreServiceInterface.writeEntry(this.aliasOfTheCurrentKeystoreView, alias, entry);
                    break block13;
                }
                throw new IOException("Unknown entry format found or the input stream is corrupted");
            }
            catch (KeyStoreException kse) {
                throw new CertificateException(kse.getMessage());
            }
        }
    }
}

