/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.spi;

import com.sap.engine.services.keystore.impl.util.PasswordProperties;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;

public class BackupKeyStoreSpiImpl
extends KeyStoreSpi {
    private KeyStore ebsdks = KeyStore.getInstance("EBSDKS");

    public BackupKeyStoreSpiImpl() throws KeyStoreException {
        try {
            this.ebsdks.load(null, null);
        }
        catch (Exception e) {
            throw new KeyStoreException(" Unexpected error: " + e.toString());
        }
    }

    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        throw new IllegalStateException("ID21105: Illegal state. Use KeyStore of type EBSDKS.");
    }

    public Certificate[] engineGetCertificateChain(String alias) {
        throw new IllegalStateException("ID21105: Illegal state. Use KeyStore of type EBSDKS.");
    }

    public Certificate engineGetCertificate(String alias) {
        throw new IllegalStateException("ID21105: Illegal state. Use KeyStore of type EBSDKS.");
    }

    public Date engineGetCreationDate(String alias) {
        throw new IllegalStateException("ID21105: Illegal state. Use KeyStore of type EBSDKS.");
    }

    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new IllegalStateException("ID21105: Illegal state. Use KeyStore of type EBSDKS.");
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new IllegalStateException("ID21105: Illegal state. Use KeyStore of type EBSDKS.");
    }

    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new IllegalStateException("ID21105: Illegal state. Use KeyStore of type EBSDKS.");
    }

    public void engineDeleteEntry(String alias) {
        throw new IllegalStateException("ID21105: Illegal state. Use KeyStore of type EBSDKS.");
    }

    public Enumeration engineAliases() {
        throw new IllegalStateException("ID21105: Illegal state. Use KeyStore of type EBSDKS.");
    }

    public boolean engineContainsAlias(String alias) {
        throw new IllegalStateException("ID21105: Illegal state. Use KeyStore of type EBSDKS.");
    }

    public int engineSize() {
        throw new IllegalStateException("ID21105: Illegal state. Use KeyStore of type EBSDKS.");
    }

    public boolean engineIsKeyEntry(String alias) {
        throw new IllegalStateException("ID21105: Illegal state. Use KeyStore of type EBSDKS.");
    }

    public boolean engineIsCertificateEntry(String alias) {
        throw new IllegalStateException("ID21105: Illegal state. Use KeyStore of type EBSDKS.");
    }

    public String engineGetCertificateAlias(Certificate cert) {
        throw new IllegalStateException("ID21105: Illegal state. Use KeyStore of type EBSDKS.");
    }

    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream == null) {
            return;
        }
        String name = null;
        Key key = null;
        Certificate cert = null;
        Certificate[] chain = null;
        PasswordProperties properties = new PasswordProperties(password);
        String keystore = properties.getProperty("keystore");
        if (keystore != null) {
            KeyStore externalStore = null;
            char[] backupPassword = null;
            String file = properties.getProperty("file");
            String pass = properties.getProperty("password");
            String provider = properties.getProperty("provider");
            name = properties.getProperty("alias");
            if (pass != null) {
                backupPassword = pass.toCharArray();
            }
            try {
                externalStore = KeyStore.getInstance(keystore, provider);
                if (file != null) {
                    externalStore.load(new FileInputStream(file), backupPassword);
                } else {
                    externalStore.load(null, null);
                }
            }
            catch (Exception kse) {
                throw new IOException("ID21199: External KeyStore could not be initialized. " + kse);
            }
            if (name != null) {
                try {
                    if (this.ebsdks.isKeyEntry(name)) {
                        key = this.ebsdks.getKey(name, null);
                        chain = this.ebsdks.getCertificateChain(name);
                        externalStore.setKeyEntry(name, key, null, chain);
                    }
                    cert = this.ebsdks.getCertificate(name);
                    externalStore.setCertificateEntry(name, cert);
                }
                catch (KeyStoreException e) {
                    e.printStackTrace(System.err);
                    throw new IOException(e.toString());
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace(System.err);
                    throw new IOException(e.toString());
                }
                catch (UnrecoverableKeyException e) {
                    e.printStackTrace(System.err);
                    throw new IOException(e.toString());
                }
            } else {
                try {
                    Enumeration<String> all = this.ebsdks.aliases();
                    while (all.hasMoreElements()) {
                        name = all.nextElement();
                        try {
                            if (this.ebsdks.isKeyEntry(name)) {
                                key = this.ebsdks.getKey(name, null);
                                chain = this.ebsdks.getCertificateChain(name);
                                externalStore.setKeyEntry(name, key, null, chain);
                                continue;
                            }
                            cert = this.ebsdks.getCertificate(name);
                            externalStore.setCertificateEntry(name, cert);
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                            throw new IOException(e.toString());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    throw new IOException(e.toString());
                }
            }
            try {
                externalStore.store(stream, backupPassword);
            }
            catch (Exception e) {
                throw new IOException("ID21199: External KeyStore could not store data. " + e);
            }
        }
        try {
            Enumeration<String> all = this.ebsdks.aliases();
            while (all.hasMoreElements()) {
                name = all.nextElement();
                try {
                    int i = 0;
                    while (i < name.length()) {
                        stream.write(name.charAt(i));
                        ++i;
                    }
                    stream.write(61);
                    String format = this.ebsdks.isKeyEntry(name) ? "PKCS#8" : "X.509";
                    this.ebsdks.store(stream, ("alias=" + name + ';' + "format" + '=' + "EBSDKS" + ';').toCharArray());
                }
                catch (Exception e) {
                    throw new IOException("Cannot store the entry[" + name + "]: " + e);
                }
            }
            stream.flush();
        }
        catch (Exception e) {
            throw new IOException("Store failed: " + e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream == null) {
            return;
        }
        name = null;
        key = null;
        cert = null;
        chain = null;
        properties = new PasswordProperties(password);
        keystore = properties.getProperty("keystore");
        if (keystore == null) ** GOTO lbl57
        externalStore = null;
        backupPassword = null;
        file = properties.getProperty("file");
        pass = properties.getProperty("password");
        provider = properties.getProperty("provider");
        if (pass != null) {
            backupPassword = pass.toCharArray();
        }
        try {
            externalStore = KeyStore.getInstance(keystore, provider);
            if (file != null) {
                externalStore.load(new FileInputStream(file), backupPassword);
            } else {
                externalStore.load(null, null);
            }
        }
        catch (Exception kse) {
            throw new IOException("ID21199: External KeyStore could not be initialized. " + kse);
        }
        try {
            all = externalStore.aliases();
            while (all.hasMoreElements()) {
                name = all.nextElement();
                try {
                    if (this.ebsdks.isKeyEntry(name)) {
                        key = externalStore.getKey(name, null);
                        chain = externalStore.getCertificateChain(name);
                        this.ebsdks.setKeyEntry(name, key, null, chain);
                        continue;
                    }
                    cert = externalStore.getCertificate(name);
                    this.ebsdks.setCertificateEntry(name, cert);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    throw new IOException(e.toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new IOException(e.toString());
        }
lbl-1000:
        // 1 sources

        {
            name = "";
            ch = (char)stream.read();
            while (ch != '\uffffffff' && ch != '=') {
                name = name + ch;
                ch = (char)stream.read();
            }
            try {
                this.ebsdks.load(stream, ("alias=" + name + ';' + "format" + '=' + "EBSDKS" + ';').toCharArray());
                continue;
            }
            catch (Exception e) {
                throw new IOException("EBSDKS cannot load entry[" + name + "]: " + e);
            }
lbl57:
            // 2 sources

            ** while (stream.available() > 0)
        }
lbl58:
        // 2 sources

    }
}

