/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.server.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.keystore.interfaces.KeyStoreProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.KeyStore;
import java.security.cert.Certificate;

public class Store
implements Command {
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream errorStream = new PrintStream(env.getErrorStream());
        PrintWriter pw = new PrintWriter(os, true);
        FileOutputStream fos = null;
        KeyStore keyStore = null;
        if (params.length > 0 && (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help"))) {
            pw.println(this.getHelpMessage());
            return;
        }
        if (params.length != 4) {
            pw.println(this.getHelpMessage());
            return;
        }
        if (!params[1].equals("-chain")) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("alias=");
            buffer.append(params[2] + ';');
            buffer.append("format=");
            if (params[1].equals("-key")) {
                buffer.append("PKCS8;");
            } else if (params[1].equals("-certificate")) {
                buffer.append("X509;");
            } else {
                buffer.append(";");
            }
            buffer.append("password=");
            try {
                fos = new FileOutputStream(params[params.length - 1]);
            }
            catch (FileNotFoundException fnfe) {
                pw.println("No file with such file destination");
                return;
            }
            try {
                keyStore = KeyStoreProvider.getKeyStore(params[0]);
                keyStore.store(fos, buffer.toString().toCharArray());
            }
            catch (Exception kse) {
                errorStream.println(kse.getMessage());
            }
        } else {
            Certificate[] chain = null;
            byte[] data = null;
            File output = new File(params[params.length - 1]);
            try {
                keyStore = KeyStoreProvider.getKeyStore(params[0]);
            }
            catch (Exception kse) {
                errorStream.println(kse.getMessage());
            }
            try {
                chain = keyStore.getCertificateChain(params[2]);
                if (chain.length == 0) {
                    pw.println("Chain not available.");
                    return;
                }
                int i = 0;
                while (i < chain.length) {
                    fos = new FileOutputStream(output.getAbsolutePath() + i);
                    data = chain[i].getEncoded();
                    fos.write(data);
                    ++i;
                }
            }
            catch (FileNotFoundException fnfe) {
                pw.println("No file with such file destination. " + fnfe.getMessage());
                return;
            }
            catch (IOException ioe) {
                pw.println("ID21108: I/O exception. " + ioe.getMessage());
                return;
            }
            catch (Exception cee) {
                pw.println("ID21107: Encoding exception. " + cee.getMessage());
                return;
            }
        }
    }

    public String getName() {
        return "STORE";
    }

    public String getGroup() {
        return "keystore";
    }

    public String getHelpMessage() {
        return "Stores key, certificate or chain with the specified alias from the specified keystore view in a file.\nUsage: " + this.getName() + " <viewAlias> <entryType> <alias> <fileName>\nParameters:\n       " + "<viewAlias> - The name of the view to check.\n       " + "<entryType> - The type of the entry to store:\n              " + "-key         - Stores a key entry.\n              " + "-certificate - Stores a certificate entry.\n              " + "-chain       - Stores a certificate chain.\n       " + "<alias>     - The name to store the entry under.\n       " + "<fileName>  - The full path and name of the file to store the entry in.\n";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

