/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.server.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.keystore.interfaces.KeyStoreProvider;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;

public class Load
implements Command {
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        block15: {
            PrintStream errorStream = new PrintStream(env.getErrorStream());
            PrintWriter pw = new PrintWriter(os, true);
            if (params.length > 0 && (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help"))) {
                pw.println(this.getHelpMessage());
                return;
            }
            if (params.length < 4) {
                pw.println(this.getHelpMessage());
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("alias=");
            buffer.append(params[1] + ';');
            buffer.append("format=");
            buffer.append(params[2] + ';');
            buffer.append("password=");
            buffer.append(" ;");
            FileInputStream fis = null;
            PrivateKey pk = null;
            try {
                fis = new FileInputStream(params[3]);
            }
            catch (FileNotFoundException fnfe) {
                pw.println("No file with such file destination");
                return;
            }
            try {
                KeyStore keyStore = KeyStoreProvider.getKeyStore(params[0]);
                if (params[2].equals("X509")) {
                    keyStore.load(fis, buffer.toString().toCharArray());
                    break block15;
                }
                if (params[2].equals("PKCS8")) {
                    keyStore.load(null, null);
                    CertificateFactory factory = CertificateFactory.getInstance("X.509");
                    Certificate[] chain = new Certificate[params.length - 4];
                    FileInputStream f = null;
                    byte[] read = null;
                    int length = 0;
                    try {
                        length = fis.available();
                        read = new byte[length];
                        fis.read(read);
                    }
                    catch (IOException ioe) {
                        pw.println("ID21108: " + ioe.getMessage());
                        return;
                    }
                    try {
                        pk = PrivateKeyInfo.getPrivateKey((byte[])read);
                    }
                    catch (Exception e) {
                        pw.println("ID21112: Not a PKCS#8 formatted key. ");
                        return;
                    }
                    int i = 4;
                    while (i < params.length) {
                        try {
                            f = new FileInputStream(params[i]);
                        }
                        catch (FileNotFoundException fnfe) {
                            pw.println("No file with such file destination");
                            return;
                        }
                        chain[i - 3] = factory.generateCertificate(f);
                        ++i;
                    }
                    keyStore.setKeyEntry(params[1], pk, new char[0], chain);
                    break block15;
                }
                pw.println(this.getHelpMessage());
                return;
            }
            catch (Exception kse) {
                errorStream.println("[EXCEPTION --> LOAD]");
                errorStream.println(kse.getMessage());
            }
        }
    }

    public String getName() {
        return "LOAD";
    }

    public String getGroup() {
        return "keystore";
    }

    public String getHelpMessage() {
        return "Loads key or certificate with the given alias from a file to the specified keystore view.\nUsage: " + this.getName() + " <viewAlias> <entryAlias> <entryFormat> <fileName> [cert]*\nParameters:\n       " + "<viewAlias>       - The name of the view to load the entry from.\n       " + "<entryAlias>      - The name of the entry to load.\n       " + "<entryFormat>     - The format of the entry.\n       " + "<fileName>        - The name of the file to load.\n       " + "[cert1 cert2 ...] - The list of certificates to load.\n";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

