/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.server.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.keystore.interfaces.KeyStoreProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.KeyStore;
import java.util.Enumeration;

public class List
implements Command {
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream errorStream = new PrintStream(env.getErrorStream());
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length > 0 && (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help"))) {
            pw.println(this.getHelpMessage());
            return;
        }
        if (params.length != 1) {
            pw.println(this.getHelpMessage());
            return;
        }
        try {
            KeyStore keyStore = KeyStoreProvider.getKeyStore(params[0]);
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                pw.println((Object)e.nextElement());
            }
        }
        catch (Exception kse) {
            errorStream.println(kse.getMessage());
        }
    }

    public String getName() {
        return "LIST";
    }

    public String getGroup() {
        return "keystore";
    }

    public String getHelpMessage() {
        return "Lists the aliases of the available entries in the specified keystore view.\nUsage: " + this.getName() + " <viewAlias>\nParameters:\n       <viewAlias> - The name of the view to check the entry from.\n";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

