/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.server.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.KeyStore;

public class Backup
implements Command {
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream errorStream = new PrintStream(env.getErrorStream());
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length > 0 && (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help"))) {
            pw.println(this.getHelpMessage());
            return;
        }
        if (params.length != 1) {
            pw.println(this.getHelpMessage());
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(params[0]);
        }
        catch (FileNotFoundException fnfe) {
            pw.println("File not found: " + fnfe.getMessage());
            return;
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("Backup");
            keyStore.load(null, null);
            keyStore.store(fos, new char[0]);
        }
        catch (Exception kse) {
            errorStream.println(kse.getMessage());
        }
    }

    public String getName() {
        return "BACKUP";
    }

    public String getGroup() {
        return "keystore";
    }

    public String getHelpMessage() {
        return "Creates and stores a back-up file for the keystore.\nUsage: " + this.getName() + " <fileName>\nParameters:\n       <fileName> - The full path and name to the backup file to upload.";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

