/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.container.ApplicationContainerContext;
import com.sap.engine.frame.core.CoreContext;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.state.PersistentContainer;
import com.sap.engine.frame.state.ServiceState;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import com.sap.engine.services.keystore.impl.AbstractKeystoreManager;
import com.sap.engine.services.keystore.impl.EntriesReadCache;
import com.sap.engine.services.keystore.impl.KeystoreManagerImpl;
import com.sap.engine.services.keystore.impl.KeystoreManagerManagementImpl;
import com.sap.engine.services.keystore.impl.ParameterChecker;
import com.sap.engine.services.keystore.impl.RemoteSecurityConnectorImpl;
import com.sap.engine.services.keystore.impl.StorageManager;
import com.sap.engine.services.keystore.impl.security.CodeBasedSecurityConnector;
import com.sap.engine.services.keystore.impl.security.SecurityRestrictionsChecker;
import com.sap.engine.services.keystore.impl.security.UserBasedSecurityConnector;
import com.sap.engine.services.keystore.impl.util.Util;
import com.sap.engine.services.keystore.interfaces.KeyStoreProvider;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerManagement;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerWrapper;
import com.sap.engine.services.keystore.patch.Patch;
import com.sap.engine.services.keystore.server.ServerContainerEventListener;
import com.sap.engine.services.keystore.server.ServerKeyStoreSpi;
import com.sap.engine.services.security.SecurityServerFrame;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;

public class KeyStoreServiceFrame
implements ApplicationServiceFrame,
Runnable {
    private AbstractKeystoreManager localKeystoreManager = null;
    private KeystoreManagerWrapper runtimeKeystoreManager = null;
    private KeystoreManagerManagement managementKeystoreManager = null;
    private KeyStoreProvider provider = null;
    private ApplicationContainerContext containerContext = null;
    private ServerContainerEventListener containerEventListener = null;
    private ConfigurationHandlerFactory configurationHandlerFactory = null;
    private static CoreContext coreContext = null;
    ServiceState state = null;
    private static final String PATCH_FAILED = "patch_failed";
    private static final String UNEXPECTED_SERVICE_NOT_STARTED = "unexpected_service_exception";
    private static final String UNEXPECTED_SERVICE_STOP_PROBLEM = "unexpected_service_stop_problem";
    private static final String INITIAL_VIEW_NOT_CREATED = "initial_view_not_created";
    private static final String UNEXPECTED_PROBLEM_INITIAL_VIEWS_CREATION = "initial_views_creation_problem";

    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        try {
            KeystoreResourceAccessor.getResourceAccessor();
            this.provider = KeyStoreProvider.getProvider();
            this.provider.put("KeyStore.EBSDKS", "com.sap.engine.services.keystore.server.ServerKeyStoreSpi");
            this.provider.install();
            this.state = serviceContext.getServiceState();
            this.containerContext = serviceContext.getContainerContext();
            coreContext = serviceContext.getCoreContext();
            this.configurationHandlerFactory = coreContext.getConfigurationHandlerFactory();
            SecurityContext securityContext = (SecurityContext)this.containerContext.getObjectRegistry().getServiceInterface("security");
            boolean isInitialized = false;
            try {
                isInitialized = new Patch(securityContext, this.configurationHandlerFactory, serviceContext.getServiceState().getWorkingDirectoryName()).isInitialized();
            }
            catch (Exception e) {
                KeystoreResourceAccessor.log(400, e.toString(), PATCH_FAILED);
                KeystoreResourceAccessor.traceThrowable(400, PATCH_FAILED, null, e);
            }
            UserBasedSecurityConnector.setSecurityContext(securityContext, this.configurationHandlerFactory, !isInitialized);
            CodeBasedSecurityConnector.setSecurityContext(securityContext);
            StorageManager local = new StorageManager(this.configurationHandlerFactory, !isInitialized);
            EntriesReadCache cache = new EntriesReadCache(local);
            SecurityRestrictionsChecker securityRestrictionsChecker = null;
            if (local.registerCache(cache)) {
                securityRestrictionsChecker = new SecurityRestrictionsChecker(cache, securityContext);
                KeystoreResourceAccessor.trace(300, "EntriesCache registered");
            } else {
                securityRestrictionsChecker = new SecurityRestrictionsChecker(local, securityContext);
                KeystoreResourceAccessor.trace(400, "EntriesCache unregistered");
            }
            this.localKeystoreManager = new ParameterChecker(securityRestrictionsChecker);
            RemoteSecurityConnectorImpl securityConnector = new RemoteSecurityConnectorImpl(CodeBasedSecurityConnector.getConnector(), UserBasedSecurityConnector.getConnector(), securityRestrictionsChecker);
            this.runtimeKeystoreManager = new KeystoreManagerImpl(this.localKeystoreManager, securityConnector);
            this.managementKeystoreManager = new KeystoreManagerManagementImpl(this.localKeystoreManager, SecurityServerFrame.getManagementContext(), securityConnector);
            ServerKeyStoreSpi.setKeystoreManager(this.runtimeKeystoreManager);
            this.containerEventListener = new ServerContainerEventListener(this.localKeystoreManager, this.containerContext.getObjectRegistry());
            this.containerContext.getObjectRegistry().registerInterface(this.runtimeKeystoreManager);
            this.containerContext.getObjectRegistry().registerInterfaceProvider("keystore_api", this.runtimeKeystoreManager);
            serviceContext.getServiceState().registerManagementInterface(this.managementKeystoreManager);
            int mask = 192;
            HashSet<String> names = new HashSet<String>(1);
            names.add("shell");
            serviceContext.getServiceState().registerContainerEventListener(mask, names, this.containerEventListener);
            this.loadInitialViews();
        }
        catch (Exception e) {
            KeystoreResourceAccessor.log(600, e, UNEXPECTED_SERVICE_NOT_STARTED);
            KeystoreResourceAccessor.traceThrowable(600, "Service not started", e);
            try {
                this.stop();
            }
            catch (Exception _) {
                KeystoreResourceAccessor.traceThrowable(600, "Stop() after failed start()", e);
            }
            throw new ServiceException(UNEXPECTED_SERVICE_NOT_STARTED, null, e);
        }
    }

    public void stop() throws ServiceRuntimeException {
        try {
            this.containerContext.getObjectRegistry().unregisterInterface();
            this.containerContext.getObjectRegistry().unregisterInterfaceProvider("keystore_api");
            this.localKeystoreManager.stop();
            ((KeystoreManagerImpl)this.runtimeKeystoreManager).stop();
            this.containerEventListener.stop();
            this.provider.shutdown();
        }
        catch (Exception e) {
            KeystoreResourceAccessor.log(400, e, UNEXPECTED_SERVICE_STOP_PROBLEM);
            KeystoreResourceAccessor.traceThrowable(400, UNEXPECTED_SERVICE_STOP_PROBLEM, null, e);
            throw new ServiceRuntimeException(UNEXPECTED_SERVICE_STOP_PROBLEM, null, e);
        }
    }

    public static CoreContext getCoreContext() {
        return coreContext;
    }

    public void run() {
        this.loadInitialViews();
    }

    private void loadInitialViews() {
        PersistentContainer persistentContainer = this.state.getPersistentContainer();
        try {
            String[] viewImageAliases = persistentContainer.listPersistentEntryNames(true);
            int i = 0;
            while (i < viewImageAliases.length) {
                File file = persistentContainer.getPersistentEntryFile(viewImageAliases[i], true);
                String fileName = viewImageAliases[i];
                if (file.isFile()) {
                    try {
                        if (!this.localKeystoreManager.existKeystoreView(fileName)) {
                            this.localKeystoreManager.createKeystoreViewEntry(fileName, null);
                            FileInputStream fis = new FileInputStream(file);
                            Util.loadView(fileName, fis, this.localKeystoreManager);
                            fis.close();
                            KeystoreResourceAccessor.trace(300, "initial view [" + fileName + "] created.");
                        } else {
                            KeystoreResourceAccessor.trace(300, "initial view [" + fileName + "] exists.");
                        }
                    }
                    catch (Exception e) {
                        Object[] params = new String[]{fileName};
                        KeystoreResourceAccessor.log(400, e, INITIAL_VIEW_NOT_CREATED, params);
                        KeystoreResourceAccessor.traceThrowable(400, INITIAL_VIEW_NOT_CREATED, params, e);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            KeystoreResourceAccessor.log(400, e, UNEXPECTED_PROBLEM_INITIAL_VIEWS_CREATION);
            KeystoreResourceAccessor.traceThrowable(400, UNEXPECTED_PROBLEM_INITIAL_VIEWS_CREATION, null, e);
        }
    }
}

