/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl.util;

import com.sap.engine.services.keystore.admin.cert.CertificateCoder;
import com.sap.engine.services.keystore.impl.AbstractKeystoreManager;
import com.sap.engine.services.keystore.interfaces.KeyStoreConstants;
import com.sap.engine.services.keystore.interfaces.KeyStoreEntryCoder;
import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import iaik.asn1.ObjectID;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Calendar;
import java.util.Properties;

public class Util
implements KeyStoreConstants {
    public static byte[][] parseRequest(byte[] request, int offset, int length) {
        int[] delimiters = new int[]{-1, -1, -1, -1};
        int j = 0;
        int i = 0;
        while (i < length) {
            if (request[offset + i] == 59) {
                delimiters[j++] = offset + i;
            }
            ++i;
        }
        byte[][] result = new byte[j + 1][];
        if (j == 0) {
            byte[] param = new byte[length - offset + 1];
            System.arraycopy(request, offset, param, 0, length - offset + 1);
            result[0] = param;
        } else {
            byte[] param;
            int param_length;
            int param_offset = offset;
            int i2 = 0;
            while (i2 < j) {
                param_length = delimiters[i2] - param_offset;
                param = new byte[param_length];
                System.arraycopy(request, param_offset, param, 0, param_length);
                result[i2] = param;
                param_offset = delimiters[i2] + 1;
                ++i2;
            }
            param_length = length - delimiters[j - 1];
            param = new byte[param_length];
            System.arraycopy(request, param_offset, param, 0, param_length);
            result[j] = param;
        }
        return result;
    }

    public static byte[] createMessage(byte commandId) {
        return new byte[]{commandId};
    }

    public static byte[] createMessage(byte commandID, byte[] command) {
        byte[] message = new byte[command.length + 1];
        System.arraycopy(command, 0, message, 1, command.length);
        message[0] = commandID;
        return message;
    }

    public static byte[] createMessage(byte commandId, byte[] bytesArr1, byte[] bytesArr2) {
        int length1 = bytesArr1.length;
        int length2 = bytesArr2.length;
        byte[] message = new byte[1 + length1 + 1 + length2];
        message[0] = commandId;
        message[length1 + 1] = 59;
        System.arraycopy(bytesArr1, 0, message, 1, length1);
        System.arraycopy(bytesArr2, 0, message, 1 + length1 + 1, length2);
        return message;
    }

    public static byte[] createMessage(byte commandId, byte[] bytesArr1, byte[] bytesArr2, byte[] bytesArr3) {
        int length1 = bytesArr1.length;
        int length2 = bytesArr2.length;
        int length3 = bytesArr3.length;
        byte[] message = new byte[1 + length1 + 1 + length2 + 1 + length3];
        message[0] = commandId;
        message[length1 + 1] = 59;
        message[length1 + 1 + length2 + 1] = 59;
        System.arraycopy(bytesArr1, 0, message, 1, length1);
        System.arraycopy(bytesArr2, 0, message, 1 + length1 + 1, length2);
        System.arraycopy(bytesArr3, 0, message, 1 + length1 + 1 + length2 + 1, length3);
        return message;
    }

    public static String byteArrToString(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length);
    }

    public static String byteArrToString(byte[] bytes) {
        return new String(bytes);
    }

    public static byte[] stringToByteArr(String str) {
        return str.getBytes();
    }

    public static void loadView(String keystoreView, InputStream stream, AbstractKeystoreManager keystoreManager) throws IOException {
        String name = null;
        while (stream.available() > 0) {
            name = "";
            char ch = (char)stream.read();
            while (ch != '\uffffffff' && ch != '=') {
                name = name + ch;
                ch = (char)stream.read();
            }
            try {
                Util.loadSingleEntry(keystoreView, stream, name, keystoreManager);
            }
            catch (Exception e) {
                throw new IOException("Cannot load credential entry[" + name + "]: " + e);
            }
        }
    }

    private static void loadSingleEntry(String keystoreView, InputStream stream, String alias, AbstractKeystoreManager keystoreManager) throws IOException, KeyStoreException {
        KeyStoreSpiEntry entry = null;
        KeyStoreEntryCoder coder = KeyStoreEntryCoder.getCoder("EBSDKS");
        KeyStoreEntryCoder.setProperties(new Properties());
        entry = coder.decode(stream);
        if (entry != null) {
            keystoreManager.writeEntry(keystoreView, alias, entry);
        }
    }

    public static void generateKeiPair(KeyStore readKeystore, String caKeyPairName, KeyStore writeKeystore, String destinationKeyPairName, String algName, int keySize, Calendar validityStartDate, Calendar validityEndDate, Object[][] subjectValues, boolean certificateSave) throws Exception {
        CertificateCoder certCoder = new CertificateCoder(readKeystore, writeKeystore, algName, keySize, validityStartDate, validityEndDate);
        certCoder.storeCertificate(certificateSave);
        certCoder.setCAAlias(caKeyPairName);
        certCoder.setAlias(destinationKeyPairName);
        int i = 0;
        while (i < subjectValues.length) {
            certCoder.assertSubjectValue((ObjectID)subjectValues[i][0], subjectValues[i][1]);
            ++i;
        }
        certCoder.generateSignature();
    }

    public static final String getStackTrace(Throwable t) {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(ostr));
        return ostr.toString();
    }
}

