/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl.storage;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.services.keystore.exceptions.BaseKeystoreException;
import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import java.security.KeyStoreException;
import java.util.Properties;

public class PropertiesStorage {
    public static Properties getKeystoreViewProperties(String keystoreViewAlias, Configuration view) throws KeyStoreException {
        Properties result = new Properties();
        try {
            String[] propsEntryNames = view.getAllConfigEntryNames();
            int i = 0;
            while (i < propsEntryNames.length) {
                result.setProperty(propsEntryNames[i], (String)view.getConfigEntry(propsEntryNames[i]));
                ++i;
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{keystoreViewAlias};
            BaseKeystoreException bex = new BaseKeystoreException("ps_0000", params, (Throwable)e);
            KeystoreResourceAccessor.log(500, e, "ps_0000", params);
            KeystoreResourceAccessor.traceThrowable(500, "ps_0000", params, e);
            throw bex;
        }
        return result;
    }

    public static void setProperty(String keystoreViewAlias, String key, String value, Configuration view) throws KeyStoreException {
        try {
            if (view.existsConfigEntry(key)) {
                view.modifyConfigEntry(key, value);
            } else {
                view.addConfigEntry(key, value);
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{keystoreViewAlias, key, value};
            BaseKeystoreException bex = new BaseKeystoreException("ps_0001", params, (Throwable)e);
            KeystoreResourceAccessor.log(500, e, "ps_0001", params);
            KeystoreResourceAccessor.traceThrowable(500, "ps_0001", params, e);
            throw bex;
        }
    }

    public static void removeProperty(String keystoreViewAlias, String key, Configuration view) throws KeyStoreException {
        try {
            if (view.existsConfigEntry(key)) {
                view.deleteConfigEntry(key);
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{keystoreViewAlias, key};
            BaseKeystoreException bex = new BaseKeystoreException("ps_0002", params, (Throwable)e);
            KeystoreResourceAccessor.log(500, e, "ps_0002", params);
            KeystoreResourceAccessor.traceThrowable(500, "ps_0002", params, e);
            throw bex;
        }
    }

    public static String getProperty(String keystoreViewAlias, String key, Configuration view) throws KeyStoreException {
        String result = null;
        try {
            result = (String)view.getConfigEntry(key);
        }
        catch (Exception e) {
            Object[] params = new Object[]{keystoreViewAlias, key};
            BaseKeystoreException bex = new BaseKeystoreException("ps_0003", params, (Throwable)e);
            KeystoreResourceAccessor.log(500, e, "ps_0003", params);
            KeystoreResourceAccessor.traceThrowable(500, "ps_0003", params, e);
            throw bex;
        }
        return result;
    }
}

