/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl.storage;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.services.keystore.exceptions.BaseKeystoreException;
import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import com.sap.engine.services.keystore.impl.KeyStoreEntry;
import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStoreException;
import java.security.cert.Certificate;

public class EntriesStorage {
    public static boolean exists(String alias, Configuration configuration) throws KeyStoreException {
        boolean result = false;
        try {
            result = configuration.existsFile(alias);
        }
        catch (Exception e) {
            Object[] params = new Object[]{alias, configuration.getPath()};
            BaseKeystoreException bex = new BaseKeystoreException("es_0001", params, (Throwable)e);
            KeystoreResourceAccessor.log(500, e, "es_0001", params);
            KeystoreResourceAccessor.traceThrowable(500, "es_0001", params, e);
            throw bex;
        }
        return result;
    }

    public static String[] aliases(Configuration configuration) throws KeyStoreException {
        String[] result = null;
        try {
            result = configuration.getAllFileEntryNames();
        }
        catch (Exception e) {
            Object[] params = new Object[]{configuration.getPath()};
            BaseKeystoreException bex = new BaseKeystoreException("es_0002", params, (Throwable)e);
            KeystoreResourceAccessor.log(500, e, "es_0002", params);
            KeystoreResourceAccessor.traceThrowable(500, "es_0002", params, e);
            throw bex;
        }
        return result;
    }

    public static void deleteEntry(String alias, Configuration configuration) throws KeyStoreException {
        try {
            if (configuration.existsFile(alias)) {
                configuration.deleteFile(alias);
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{alias, configuration.getPath()};
            BaseKeystoreException bex = new BaseKeystoreException("es_0003", params, (Throwable)e);
            KeystoreResourceAccessor.log(500, e, "es_0003", params);
            KeystoreResourceAccessor.traceThrowable(500, "es_0003", params, e);
            throw bex;
        }
    }

    public static String findAlias(KeyStoreEntry entry, Configuration configuration) throws KeyStoreException {
        String result = null;
        try {
            result = EntriesStorage.engine_findAlias(configuration, entry);
        }
        catch (Exception e) {
            Object[] params = new Object[]{entry, configuration.getPath()};
            BaseKeystoreException bex = new BaseKeystoreException("es_0004", params, (Throwable)e);
            KeystoreResourceAccessor.log(500, e, "es_0004", params);
            KeystoreResourceAccessor.traceThrowable(500, "es_0004", params, e);
            throw bex;
        }
        return result;
    }

    public static KeyStoreSpiEntry readEntry(String alias, Configuration configuration) throws KeyStoreException {
        try {
            KeyStoreEntry result = EntriesStorage.readEntry(configuration.getFile(alias));
            return result;
        }
        catch (Exception e) {
            Object[] params = new Object[]{alias, configuration.getPath()};
            BaseKeystoreException bex = new BaseKeystoreException("es_0005", params, (Throwable)e);
            KeystoreResourceAccessor.log(500, e, "es_0005", params);
            KeystoreResourceAccessor.traceThrowable(500, "es_0005", params, e);
            throw bex;
        }
    }

    public static int size(Configuration configuration) throws KeyStoreException {
        int result = -1;
        try {
            result = configuration.getAllFileEntryNames().length;
        }
        catch (Exception e) {
            Object[] params = new Object[]{configuration.getPath()};
            BaseKeystoreException bex = new BaseKeystoreException("es_0006", params, (Throwable)e);
            KeystoreResourceAccessor.log(500, e, "es_0006", params);
            KeystoreResourceAccessor.traceThrowable(500, "es_0006", params, e);
            throw bex;
        }
        return result;
    }

    public static void writeEntry(String alias, KeyStoreSpiEntry entry, Configuration configuration) throws KeyStoreException {
        try {
            configuration.updateFileAsStream(alias, new ByteArrayInputStream(((KeyStoreEntry)entry).data), true);
        }
        catch (Exception e) {
            Object[] params = new Object[]{alias, entry, configuration.getPath()};
            BaseKeystoreException bex = new BaseKeystoreException("es_0007", params, (Throwable)e);
            KeystoreResourceAccessor.log(500, e, "es_0007", params);
            KeystoreResourceAccessor.traceThrowable(500, "es_0007", params, e);
            throw bex;
        }
    }

    public static boolean isKeyEntry(String alias, Configuration configuration) throws KeyStoreException {
        boolean result = false;
        try {
            KeyStoreEntry result1 = EntriesStorage.readEntry(configuration.getFile(alias));
            result = result1.isKeyEntry();
        }
        catch (Exception e) {
            Object[] params = new Object[]{alias, configuration.getPath()};
            BaseKeystoreException bex = new BaseKeystoreException("es_0008", params, (Throwable)e);
            KeystoreResourceAccessor.log(500, e, "es_0008", params);
            KeystoreResourceAccessor.traceThrowable(500, "es_0008", params, e);
            throw bex;
        }
        return result;
    }

    public static void renameEntry(String oldAlias, String newAlias, Configuration configuration) throws KeyStoreException {
        try {
            KeyStoreEntry result = EntriesStorage.readEntry(configuration.getFile(oldAlias));
            configuration.deleteFile(oldAlias);
            configuration.addFileAsStream(newAlias, new ByteArrayInputStream(result.data));
        }
        catch (Exception e) {
            Object[] params = new Object[]{oldAlias, newAlias, configuration.getPath()};
            BaseKeystoreException bex = new BaseKeystoreException("es_0009", params, (Throwable)e);
            KeystoreResourceAccessor.log(500, e, "es_0009", params);
            KeystoreResourceAccessor.traceThrowable(500, "es_0009", params, e);
            throw bex;
        }
    }

    private static String engine_findAlias(Configuration cfg, KeyStoreEntry entry) throws ConfigurationException, IOException, KeyStoreException {
        String[] fileNames = cfg.getAllFileEntryNames();
        int i = 0;
        while (i < fileNames.length) {
            Certificate[] current_entry_chain;
            InputStream fileValue = cfg.getFile(fileNames[i]);
            byte[] value = EntriesStorage.readInputStream(fileValue);
            KeyStoreEntry current_entry = KeyStoreEntry.createEntry(value);
            if (current_entry.isCertificateEntry() && current_entry.getCertificate().equals(entry.getCertificate())) {
                return fileNames[i];
            }
            if (current_entry.isKeyEntry() && (current_entry_chain = current_entry.getCertificateChain()) != null && current_entry_chain.length > 0 && current_entry_chain[0].equals(entry.getCertificate())) {
                return fileNames[i];
            }
            ++i;
        }
        return null;
    }

    private static KeyStoreEntry readEntry(InputStream file) throws IOException, KeyStoreException {
        byte[] value = EntriesStorage.readInputStream(file);
        KeyStoreEntry result = KeyStoreEntry.createEntry(value);
        return result;
    }

    private static byte[] readInputStream(InputStream file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int bufferSize = 256;
        byte[] io_buffer = new byte[bufferSize];
        int readBytesCount = -1;
        while ((readBytesCount = file.read(io_buffer)) != -1) {
            out.write(io_buffer, 0, readBytesCount);
        }
        return out.toByteArray();
    }
}

